/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.itemlist.recipebook;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.ItemPrice;
import de.hysky.skyblocker.skyblock.item.wikilookup.WikiLookupManager;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.itemlist.recipebook.FilterOption;
import de.hysky.skyblocker.skyblock.itemlist.recipebook.RecipeAreaDisplay;
import de.hysky.skyblocker.skyblock.itemlist.recipebook.SkyblockRecipeResultButton;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockCraftingRecipe;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockForgeRecipe;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockNpcShopRecipe;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockRecipe;
import de.hysky.skyblocker.utils.render.HudHelper;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_513;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_9334;
import org.joml.Vector2i;
import org.jspecify.annotations.Nullable;

public class SkyblockRecipeResults
implements RecipeAreaDisplay {
    private static final int MAX_TEXT_WIDTH = 124;
    private static final String ELLIPSIS_STRING = class_5244.field_39678.getString();
    private final List<SkyblockRecipeResultButton> resultButtons = Lists.newArrayListWithCapacity((int)20);
    private final List<SkyblockRecipeResultButton> recipeSlotButtons = Lists.newArrayListWithCapacity((int)16);
    private @Nullable class_1799 recipeIcon = null;
    private final class_310 client = class_310.method_1551();
    private @Nullable class_344 nextPageButton;
    private @Nullable class_344 prevPageButton;
    private SkyblockRecipeResultButton hoveredResultButton;
    private @Nullable String lastSearchQuery = null;
    private final List<class_1799> searchResults = new ArrayList<class_1799>();
    private class_2561 hoveredText;
    private List<SkyblockRecipe> recipeResults = new ArrayList<SkyblockRecipe>();
    private int pageCount = 0;
    private int currentPage = 0;
    private boolean recipeView = false;

    protected SkyblockRecipeResults() {
        for (int i = 0; i < 20; ++i) {
            this.resultButtons.add(new SkyblockRecipeResultButton());
        }
    }

    @Override
    public void initialize(class_310 client, int parentLeft, int parentTop) {
        for (int i = 0; i < this.resultButtons.size(); ++i) {
            this.resultButtons.get(i).method_48229(parentLeft + 11 + 25 * (i % 5), parentTop + 31 + 25 * (i / 5));
        }
        this.nextPageButton = new class_344(parentLeft + 93, parentTop + 137, 12, 17, class_513.field_45552, _ignored -> {});
        this.prevPageButton = new class_344(parentLeft + 38, parentTop + 137, 12, 17, class_513.field_45553, _ignored -> {});
        this.updateResultButtons();
    }

    @Override
    public void draw(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
        class_327 textRenderer = this.client.field_1772;
        this.hoveredText = null;
        if (this.recipeView) {
            this.drawRecipeDisplay(context, textRenderer, x, y, mouseX, mouseY);
        }
        if (this.pageCount > 1) {
            class_5250 text = class_2561.method_43469((String)"gui.recipebook.page", (Object[])new Object[]{this.currentPage + 1, this.pageCount});
            int width = textRenderer.method_27525((class_5348)text);
            context.method_51439(textRenderer, (class_2561)text, x - width / 2 + 73, y + 141, -1, false);
        }
        this.hoveredResultButton = null;
        for (SkyblockRecipeResultButton resultButton : this.recipeView ? this.recipeSlotButtons : this.resultButtons) {
            resultButton.method_25394(context, mouseX, mouseY, delta);
            if (!resultButton.field_22764 || !resultButton.method_25367()) continue;
            this.hoveredResultButton = resultButton;
        }
        if (this.prevPageButton != null) {
            this.prevPageButton.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.nextPageButton != null) {
            this.nextPageButton.method_25394(context, mouseX, mouseY, delta);
        }
    }

    private void drawRecipeDisplay(class_332 context, class_327 textRenderer, int x, int y, int mouseX, int mouseY) {
        class_2561 itemName;
        SkyblockRecipe recipe = this.recipeResults.get(this.currentPage);
        Object craftText = recipe.getExtraText().getString();
        if (!((String)craftText).isEmpty()) {
            if (textRenderer.method_1727((String)craftText) > 124) {
                if (this.isMouseHoveringText(x + 11, y + 31, mouseX, mouseY)) {
                    this.hoveredText = class_2561.method_43470((String)craftText);
                }
                craftText = textRenderer.method_27523((String)craftText, 124) + ELLIPSIS_STRING;
            }
            context.method_25303(textRenderer, (String)craftText, x + 11, y + 31, -1);
        }
        if (textRenderer.method_27525((class_5348)(itemName = recipe.getOutputs().getFirst().method_7964())) > 124) {
            class_5348 trimmed = class_5348.method_29433((class_5348[])new class_5348[]{textRenderer.method_1714((class_5348)itemName, 124), class_5244.field_39678});
            class_5481 ordered = class_2477.method_10517().method_30934(trimmed);
            context.method_35720(textRenderer, ordered, x + 11, y + 43, -1);
            if (this.isMouseHoveringText(x + 11, y + 43, mouseX, mouseY)) {
                this.hoveredText = itemName;
            }
        } else {
            context.method_27535(textRenderer, itemName, x + 11, y + 43, -1);
        }
        context.method_25303(textRenderer, "\u25b6", x + 96, y + 90, -1426063361);
        if (this.hoveredText == null && mouseX >= x + 86 && mouseY >= y + 81 && mouseX < x + 86 + 25 && mouseY < y + 81 + 25 && recipe instanceof SkyblockForgeRecipe) {
            SkyblockForgeRecipe forgeRecipe = (SkyblockForgeRecipe)recipe;
            this.hoveredText = class_2561.method_30163((String)forgeRecipe.getDurationString());
        }
        if (this.recipeIcon != null) {
            context.method_51427(this.recipeIcon, x + 115, y + 61);
        }
    }

    @Override
    public void drawTooltip(class_332 context, int x, int y) {
        if (this.client.field_1755 != null) {
            if (this.hoveredResultButton != null && !this.hoveredResultButton.getDisplayStack().method_7960()) {
                class_1799 stack = this.hoveredResultButton.getDisplayStack();
                class_2960 tooltipStyle = (class_2960)stack.method_58694(class_9334.field_54198);
                context.method_64037(this.client.field_1772, SkyblockRecipeResultButton.getTooltip(stack), x, y, tooltipStyle);
            } else if (this.hoveredText != null) {
                context.method_51438(this.client.field_1772, this.hoveredText, x, y);
            }
        }
    }

    private boolean isMouseHoveringText(int textX, int textY, int mouseX, int mouseY) {
        double d = mouseX;
        double d2 = mouseY;
        double d3 = textX;
        double d4 = textY;
        double d5 = textX + 124 + 4;
        Objects.requireNonNull(this.client.field_1772);
        return HudHelper.pointIsInArea(d, d2, d3, d4, d5, textY + 9);
    }

    protected void closeRecipeView() {
        this.currentPage = 0;
        this.pageCount = (this.searchResults.size() - 1) / this.resultButtons.size() + 1;
        this.recipeView = false;
        this.updateResultButtons();
    }

    @Override
    public void updateSearchResults(String query, FilterOption filterOption, boolean refresh) {
        if (!ItemRepository.filesImported()) {
            return;
        }
        if (!query.equals(this.lastSearchQuery) || refresh) {
            this.lastSearchQuery = query;
            this.searchResults.clear();
            for (class_1799 stack : ItemRepository.getItems()) {
                String name = stack.method_7964().getString().toLowerCase(Locale.ENGLISH);
                if (!filterOption.test(name)) continue;
                List lore = stack.skyblocker$getLoreStrings();
                if (!name.contains(query) && !lore.stream().map(string -> string.toLowerCase(Locale.ENGLISH)).anyMatch(line -> line.contains(query))) continue;
                this.searchResults.add(stack);
            }
            this.closeRecipeView();
        } else {
            this.hideShowPageButtons();
        }
    }

    private void updateResultButtons() {
        if (this.recipeView) {
            SkyblockRecipe recipe = this.recipeResults.get(this.currentPage);
            for (SkyblockRecipeResultButton button : this.resultButtons) {
                button.clearDisplayStack();
            }
            this.recipeSlotButtons.clear();
            SkyblockRecipe skyblockRecipe = recipe;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SkyblockCraftingRecipe.class, SkyblockForgeRecipe.class, SkyblockNpcShopRecipe.class}, (Object)skyblockRecipe, n)) {
                case 0: {
                    SkyblockCraftingRecipe craftingRecipe = (SkyblockCraftingRecipe)skyblockRecipe;
                    this.recipeIcon = new class_1799((class_1935)class_1802.field_8465);
                    this.recipeSlotButtons.add(this.resultButtons.get(5).setDisplayStack(craftingRecipe.getGrid().getFirst()));
                    this.recipeSlotButtons.add(this.resultButtons.get(6).setDisplayStack(craftingRecipe.getGrid().get(1)));
                    this.recipeSlotButtons.add(this.resultButtons.get(7).setDisplayStack(craftingRecipe.getGrid().get(2)));
                    this.recipeSlotButtons.add(this.resultButtons.get(10).setDisplayStack(craftingRecipe.getGrid().get(3)));
                    this.recipeSlotButtons.add(this.resultButtons.get(11).setDisplayStack(craftingRecipe.getGrid().get(4)));
                    this.recipeSlotButtons.add(this.resultButtons.get(12).setDisplayStack(craftingRecipe.getGrid().get(5)));
                    this.recipeSlotButtons.add(this.resultButtons.get(15).setDisplayStack(craftingRecipe.getGrid().get(6)));
                    this.recipeSlotButtons.add(this.resultButtons.get(16).setDisplayStack(craftingRecipe.getGrid().get(7)));
                    this.recipeSlotButtons.add(this.resultButtons.get(17).setDisplayStack(craftingRecipe.getGrid().get(8)));
                    this.recipeSlotButtons.add(this.resultButtons.get(14).setDisplayStack(craftingRecipe.getResult()));
                    break;
                }
                case 1: {
                    SkyblockForgeRecipe forgeRecipe = (SkyblockForgeRecipe)skyblockRecipe;
                    this.recipeIcon = new class_1799((class_1935)class_1802.field_8187);
                    Vector2i gridSize = forgeRecipe.getGridSize();
                    SkyblockRecipeResultButton button = this.resultButtons.get(11);
                    int startX = button.method_46426() + button.method_25368() / 2 - gridSize.x * 25 / 2;
                    int startY = button.method_46427() + button.method_25364() / 2 - gridSize.y * 25 / 2;
                    for (int i = 0; i < forgeRecipe.getInputs().size(); ++i) {
                        int x = startX + i % gridSize.x * 25;
                        int y = startY + i / gridSize.x * 25;
                        this.recipeSlotButtons.add(new SkyblockRecipeResultButton(x, y).setDisplayStack(forgeRecipe.getInputs().get(i)));
                    }
                    this.recipeSlotButtons.add(this.resultButtons.get(14).setDisplayStack(forgeRecipe.getResult()));
                    break;
                }
                case 2: {
                    SkyblockNpcShopRecipe npcShopRecipe = (SkyblockNpcShopRecipe)skyblockRecipe;
                    this.recipeIcon = new class_1799((class_1935)class_1802.field_8397);
                    this.recipeSlotButtons.add(this.resultButtons.get(8).setDisplayStack(npcShopRecipe.getNpcItem()));
                    int slotsPerRow = 3;
                    int rows = npcShopRecipe.getInputs().size() / slotsPerRow + 1;
                    SkyblockRecipeResultButton button = this.resultButtons.get(11);
                    int startX = this.resultButtons.getFirst().method_46426();
                    int startY = button.method_46427() + button.method_25364() / 2 - rows * 25 / 2;
                    for (int i = 0; i < npcShopRecipe.getInputs().size(); ++i) {
                        int x = startX + i % slotsPerRow * 25;
                        int y = startY + i / slotsPerRow * 25;
                        this.recipeSlotButtons.add(new SkyblockRecipeResultButton(x, y).setDisplayStack(npcShopRecipe.getInputs().get(i)));
                    }
                    this.recipeSlotButtons.add(this.resultButtons.get(14).setDisplayStack(npcShopRecipe.getOutputs().getFirst()));
                    break;
                }
            }
        } else {
            this.recipeIcon = null;
            for (int i = 0; i < this.resultButtons.size(); ++i) {
                int index = this.currentPage * this.resultButtons.size() + i;
                if (index < this.searchResults.size()) {
                    this.resultButtons.get(i).setDisplayStack(this.searchResults.get(index));
                    continue;
                }
                this.resultButtons.get(i).clearDisplayStack();
            }
        }
        this.hideShowPageButtons();
    }

    private void hideShowPageButtons() {
        this.prevPageButton.field_22763 = this.currentPage > 0;
        this.nextPageButton.field_22763 = this.currentPage < this.pageCount - 1;
    }

    @Override
    public boolean mouseClicked(class_11909 click, boolean doubled) {
        if (this.nextPageButton.method_25402(click, doubled)) {
            ++this.currentPage;
            this.updateResultButtons();
            return true;
        }
        if (this.prevPageButton.method_25402(click, doubled)) {
            --this.currentPage;
            this.updateResultButtons();
            return true;
        }
        if (this.recipeView && click.method_74245() == 1) {
            SkyblockRecipeResultButton result = this.resultButtons.get(14);
            String rawID = result.getDisplayStack().getSkyblockId();
            if (result.method_25405(click.comp_4798(), click.comp_4799())) {
                MessageScheduler.INSTANCE.sendMessageAfterCooldown(String.format("/viewrecipe %s", rawID), true);
                return true;
            }
        }
        for (SkyblockRecipeResultButton resultButton : this.recipeView ? this.recipeSlotButtons : this.resultButtons) {
            String itemId;
            if (!resultButton.method_25402(click, doubled) || (itemId = resultButton.getDisplayStack().getSkyblockId()).isEmpty()) continue;
            List<SkyblockRecipe> recipes = ItemRepository.getRecipesAndUsages(resultButton.getDisplayStack());
            if (!recipes.isEmpty()) {
                this.recipeResults = recipes;
                this.currentPage = 0;
                this.pageCount = recipes.size();
                this.recipeView = true;
                this.updateResultButtons();
            }
            return true;
        }
        return false;
    }

    private @Nullable class_1799 getHoveredItemStack(double mouseX, double mouseY) {
        return this.resultButtons.stream().filter(btn -> btn.method_25405(mouseX, mouseY)).findFirst().map(SkyblockRecipeResultButton::getDisplayStack).orElse(null);
    }

    @Override
    public boolean keyPressed(double mouseX, double mouseY, class_11908 input) {
        class_1799 hovered = this.getHoveredItemStack(mouseX, mouseY);
        if (hovered == null) {
            return false;
        }
        if (WikiLookupManager.handleWikiLookup((Either<class_1735, class_1799>)Either.right((Object)hovered), (class_1657)this.client.field_1724, input)) {
            return true;
        }
        if (SkyblockerConfigManager.get().helpers.itemPrice.enableItemPriceLookup && ItemPrice.ITEM_PRICE_LOOKUP.method_1417(input)) {
            ItemPrice.itemPriceLookup(this.client.field_1724, hovered);
            return true;
        }
        return false;
    }
}

