/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.itemlist.recipebook;

import de.hysky.skyblocker.skyblock.events.EventNotifications;
import de.hysky.skyblocker.skyblock.itemlist.recipebook.FilterOption;
import de.hysky.skyblocker.skyblock.itemlist.recipebook.RecipeTab;
import de.hysky.skyblocker.skyblock.tabhud.widget.JacobsContestWidget;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.SkyblockTime;
import de.hysky.skyblocker.utils.render.HudHelper;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8001;
import org.jspecify.annotations.Nullable;

public class UpcomingEventsTab
implements RecipeTab {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final class_1799 CLOCK = new class_1799((class_1935)class_1802.field_8557);
    private final List<EventRenderer> events = new ArrayList<EventRenderer>();
    private EventRenderer hovered = null;

    protected UpcomingEventsTab() {
        List<EventRenderer> renderers = EventNotifications.getEvents().entrySet().stream().sorted(Comparator.comparingLong(a -> ((LinkedList)a.getValue()).isEmpty() ? Long.MAX_VALUE : ((EventNotifications.SkyblockEvent)((LinkedList)a.getValue()).peekFirst()).start())).map(stringLinkedListEntry -> new EventRenderer((String)stringLinkedListEntry.getKey(), (LinkedList)stringLinkedListEntry.getValue())).toList();
        this.events.addAll(renderers);
    }

    @Override
    public void initialize(class_310 client, int parentLeft, int parentTop) {
    }

    @Override
    public void draw(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
        context.method_44379(x += 9, y += 9, x + 131, y + 150);
        context.method_51445(CLOCK, x, y + 4);
        context.method_25303(UpcomingEventsTab.CLIENT.field_1772, "Upcoming Events", x + 17, y + 7, -1);
        int eventsY = y + 7 + 24;
        this.hovered = null;
        for (EventRenderer eventRenderer : this.events) {
            eventRenderer.render(context, x + 1, eventsY, mouseX, mouseY);
            if (HudHelper.pointIsInArea(mouseX, mouseY, x, y, x + 131, y + 150) && EventRenderer.isMouseOver(mouseX, mouseY, x + 1, eventsY)) {
                this.hovered = eventRenderer;
            }
            eventsY += 20;
        }
        context.method_44380();
    }

    @Override
    public void drawTooltip(class_332 context, int x, int y) {
        if (this.hovered != null) {
            context.method_51435(UpcomingEventsTab.CLIENT.field_1772, this.hovered.getTooltip(), x, y, class_8001.field_41687, null);
        }
    }

    @Override
    public boolean mouseClicked(class_11909 click, boolean doubled) {
        if (this.hovered != null && this.hovered.getWarpCommand() != null) {
            MessageScheduler.INSTANCE.sendMessageAfterCooldown(this.hovered.getWarpCommand(), true);
            return true;
        }
        return false;
    }

    @Override
    public class_1799 icon() {
        return CLOCK;
    }

    @Override
    public void updateSearchResults(String query, FilterOption filterOption, boolean refresh) {
    }

    private record EventRenderer(String eventName, LinkedList<EventNotifications.SkyblockEvent> events) {
        private static final int HEIGHT = 20;

        private void render(class_332 context, int x, int y, int mouseX, int mouseY) {
            long time = System.currentTimeMillis() / 1000L;
            class_327 textRenderer = UpcomingEventsTab.CLIENT.field_1772;
            context.method_27535(textRenderer, (class_2561)class_2561.method_43470((String)this.eventName).method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(EventRenderer.isMouseOver(mouseX, mouseY, x, y)))), x, y, -1);
            if (this.events.isEmpty()) {
                class_5250 class_52502 = class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.events.tab.noMore"));
                Objects.requireNonNull(textRenderer);
                context.method_51439(textRenderer, (class_2561)class_52502, x, y + 9, -8355712, false);
            } else if (this.events.peekFirst().start() > time) {
                class_5250 formatted = class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"skyblocker.events.tab.startsIn", (Object[])new Object[]{SkyblockTime.formatTime((int)(this.events.peekFirst().start() - time))})).method_27692(class_124.field_1054);
                Objects.requireNonNull(textRenderer);
                context.method_27535(textRenderer, (class_2561)formatted, x, y + 9, -1);
            } else {
                class_5250 formatted = class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)"skyblocker.events.tab.endsIn", (Object[])new Object[]{SkyblockTime.formatTime((int)(this.events.peekFirst().start() + (long)this.events.peekFirst().duration() - time))})).method_27692(class_124.field_1060);
                Objects.requireNonNull(textRenderer);
                context.method_27535(textRenderer, (class_2561)formatted, x, y + 9, -1);
            }
        }

        private static boolean isMouseOver(int mouseX, int mouseY, int x, int y) {
            return HudHelper.pointIsInArea(mouseX, mouseY, x, y, x + 131, y + 20);
        }

        private List<class_5684> getTooltip() {
            ArrayList<class_5684> components = new ArrayList<class_5684>();
            EventNotifications.SkyblockEvent event = this.events.peekFirst();
            if (event == null) {
                return components;
            }
            if (this.eventName.equals("Jacob's Farming Contest")) {
                components.add(new JacobsTooltip(event.extras()));
            }
            if (event.warpCommand() != null) {
                components.add(class_5684.method_32662((class_5481)class_2561.method_43471((String)"skyblocker.events.tab.clickToWarp").method_27692(class_124.field_1056).method_30937()));
            }
            components.add(class_5684.method_32662((class_5481)class_2561.method_43470((String)Formatters.DATE_FORMATTER.format(Instant.ofEpochSecond(event.start()))).method_27695(new class_124[]{class_124.field_1056, class_124.field_1063}).method_30937()));
            return components;
        }

        private @Nullable String getWarpCommand() {
            return !this.events.isEmpty() ? this.events.peek().warpCommand() : null;
        }
    }

    private record JacobsTooltip(String[] crops) implements class_5684
    {
        private static final class_1799 BARRIER = new class_1799((class_1935)class_1802.field_8077);

        public int method_32661(class_327 textRenderer) {
            return 20;
        }

        public int method_32664(class_327 textRenderer) {
            return 52;
        }

        public void method_32666(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
            for (int i = 0; i < this.crops.length; ++i) {
                String crop = this.crops[i];
                context.method_51445(JacobsContestWidget.FARM_DATA.getOrDefault(crop, BARRIER), x + 18 * i, y + 2);
            }
        }
    }
}

