/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.museum;

import de.hysky.skyblocker.skyblock.museum.PriceData;
import it.unimi.dsi.fastutil.objects.ObjectDoublePair;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import it.unimi.dsi.fastutil.objects.ObjectObjectMutablePair;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;

public class Donation {
    private final String category;
    private final String id;
    private final List<ObjectObjectMutablePair<String, PriceData>> set;
    private final List<String> downgrades = new ArrayList<String>();
    private final int xp;
    private List<ObjectIntPair<String>> countsTowards;
    private PriceData priceData;
    private @Nullable ObjectDoublePair<String> discount;
    private int totalXp;
    private double xpCoinsRatio;

    public Donation(String category, String id, List<ObjectObjectMutablePair<String, PriceData>> set, int xp) {
        this.category = category;
        this.id = id;
        this.set = set;
        this.xp = xp;
    }

    public int getTotalXp() {
        return this.totalXp;
    }

    public void setTotalXp(int totalXp) {
        this.totalXp = totalXp;
    }

    public List<ObjectIntPair<String>> getCountsTowards() {
        return this.countsTowards;
    }

    public void setCountsTowards(List<ObjectIntPair<String>> countsTowards) {
        this.countsTowards = countsTowards;
    }

    public PriceData getPriceData() {
        return this.priceData;
    }

    public void setPriceData() {
        this.priceData = new PriceData(this);
    }

    public @Nullable ObjectDoublePair<String> getDiscount() {
        return this.discount;
    }

    public void setDiscount(@Nullable ObjectDoublePair<String> discount) {
        this.discount = discount;
    }

    public boolean hasDiscount() {
        return this.discount != null && this.discount.rightDouble() > 0.0;
    }

    public void addDowngrade(String downgrade) {
        this.downgrades.add(downgrade);
    }

    public List<String> getDowngrades() {
        return this.downgrades;
    }

    public double getXpCoinsRatio() {
        return this.xpCoinsRatio;
    }

    public void setXpCoinsRatio(double xpCoinsRatio) {
        this.xpCoinsRatio = xpCoinsRatio;
    }

    public String getCategory() {
        return this.category;
    }

    public String getId() {
        return this.id;
    }

    public boolean isSet() {
        return !this.set.isEmpty();
    }

    public List<ObjectObjectMutablePair<String, PriceData>> getSet() {
        return this.set;
    }

    public int getXp() {
        return this.xp;
    }

    public boolean isCraftable() {
        return this.priceData.getCraftCost() > 0.0;
    }

    public boolean hasLBinPrice() {
        return this.priceData.getLBinPrice() > 0.0;
    }

    public boolean hasPrice() {
        return this.priceData.getEffectivePrice() > 0.0;
    }
}

