/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer;

import com.google.gson.JsonObject;
import de.hysky.skyblocker.skyblock.accessories.AccessoriesHelper;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.BackpackItemLoader;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.InventoryItemLoader;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.ItemLoader;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.PetsInventoryItemLoader;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.WardrobeInventoryItemLoader;
import de.hysky.skyblocker.skyblock.profileviewer.utils.ProfileViewerUtils;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.utils.networth.NetworthCalculator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;

public class ProfileViewerTextWidget {
    private static final int ROW_GAP = 9;
    private String PROFILE_NAME = "UNKNOWN";
    private int SKYBLOCK_LEVEL = 0;
    private double PURSE = 0.0;
    private double BANK = 0.0;
    private double NETWORTH = 0.0;
    private int MAGICAL_POWER = 0;
    private final List<class_2561> networthTooltip = new ArrayList<class_2561>();

    public ProfileViewerTextWidget(JsonObject hypixelProfile, JsonObject playerProfile) {
        try {
            this.PROFILE_NAME = hypixelProfile.get("cute_name").getAsString();
            this.SKYBLOCK_LEVEL = playerProfile.getAsJsonObject("leveling").get("experience").getAsInt() / 100;
            this.PURSE = playerProfile.getAsJsonObject("currencies").get("coin_purse").getAsDouble();
            this.BANK = hypixelProfile.getAsJsonObject("banking").get("balance").getAsDouble();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.NETWORTH = this.PURSE + this.BANK + this.getItemsNetworth(playerProfile);
        this.MAGICAL_POWER = this.getMagicalPower(playerProfile);
    }

    public int getMagicalPower(JsonObject playerProfile) {
        int totalMagicalPower = 0;
        boolean hatCounted = false;
        boolean abicaseCounted = false;
        HashMap<String, Integer> accessories = new HashMap<String, Integer>();
        if (TooltipInfoType.ACCESSORIES.getData() == null) {
            return totalMagicalPower;
        }
        try {
            JsonObject inventoryData;
            if (playerProfile.has("rift") && playerProfile.getAsJsonObject("rift").has("access") && playerProfile.getAsJsonObject("rift").getAsJsonObject("access").has("consumed_prism")) {
                totalMagicalPower += 11;
            }
            if ((inventoryData = playerProfile.getAsJsonObject("inventory")).has("bag_contents") && inventoryData.getAsJsonObject("bag_contents").has("talisman_bag")) {
                for (class_1799 item : new ItemLoader().loadItems(inventoryData.getAsJsonObject("bag_contents").getAsJsonObject("talisman_bag"))) {
                    AccessoriesHelper.Accessory accessory;
                    String name;
                    if (item.getSkyblockId().isEmpty() || accessories.getOrDefault(name = (accessory = Objects.requireNonNull(TooltipInfoType.ACCESSORIES.getData()).get(item.getSkyblockId())).family().orElse(accessory.id()), 0) >= item.getSkyblockRarity().getMP()) continue;
                    if (item.getSkyblockId().startsWith("ABICASE") && !abicaseCounted) {
                        JsonObject data;
                        if (playerProfile.has("nether_island_player_data") && (data = playerProfile.get("nether_island_player_data").getAsJsonObject()).has("abiphone") && data.get("abiphone").getAsJsonObject().has("active_contacts")) {
                            totalMagicalPower += (int)((double)(data.get("abiphone").getAsJsonObject().get("active_contacts").getAsJsonArray().size() / 2));
                            abicaseCounted = true;
                        }
                    } else if (item.getSkyblockId().startsWith("BALLOON_HAT") || item.getSkyblockId().startsWith("PARTY_HAT")) {
                        if (hatCounted) continue;
                        hatCounted = true;
                    } else if (item.getSkyblockId().equals("HEGEMONY_ARTIFACT")) {
                        accessories.put(name, item.getSkyblockRarity().getMP() * 2);
                        continue;
                    }
                    accessories.put(name, item.getSkyblockRarity().getMP());
                }
            }
        }
        catch (Exception ignored) {
            return -1;
        }
        for (Map.Entry entry : accessories.entrySet()) {
            totalMagicalPower += ((Integer)entry.getValue()).intValue();
        }
        return totalMagicalPower;
    }

    private double getItemsNetworth(JsonObject playerProfile) {
        double value = 0.0;
        PriorityQueue<ItemValue> top = new PriorityQueue<ItemValue>(Comparator.comparingDouble(ItemValue::price));
        try {
            JsonObject inventoryData = playerProfile.getAsJsonObject("inventory");
            if (inventoryData != null) {
                for (class_1799 stack : new InventoryItemLoader().loadItems(inventoryData)) {
                    value += this.addItemNetworth(top, stack);
                }
                if (inventoryData.has("ender_chest_contents")) {
                    for (class_1799 stack : new ItemLoader().loadItems(inventoryData.getAsJsonObject("ender_chest_contents"))) {
                        value += this.addItemNetworth(top, stack);
                    }
                }
                if (inventoryData.has("backpack_contents")) {
                    for (class_1799 stack : new BackpackItemLoader().loadItems(inventoryData.getAsJsonObject("backpack_contents"))) {
                        value += this.addItemNetworth(top, stack);
                    }
                }
                if (inventoryData.has("wardrobe_contents")) {
                    int activeSlot = inventoryData.get("wardrobe_equipped_slot").getAsInt();
                    HashSet<Integer> skip = new HashSet<Integer>();
                    if (activeSlot != -1) {
                        for (int i = 0; i < 4; ++i) {
                            int baseIndex = (activeSlot - 1) % 9;
                            int page = (activeSlot - 1) / 9;
                            int slotIndex = page * 36 + i * 9 + baseIndex;
                            skip.add(slotIndex);
                        }
                    }
                    WardrobeInventoryItemLoader loader = new WardrobeInventoryItemLoader(inventoryData);
                    List<class_1799> wardrobeItems = loader.loadItems(inventoryData.getAsJsonObject("wardrobe_contents"));
                    for (int index = 0; index < wardrobeItems.size(); ++index) {
                        if (skip.contains(index)) continue;
                        class_1799 stack = wardrobeItems.get(index);
                        value += this.addItemNetworth(top, stack);
                    }
                }
                if (inventoryData.has("bag_contents") && inventoryData.getAsJsonObject("bag_contents").has("talisman_bag")) {
                    for (class_1799 stack : new ItemLoader().loadItems(inventoryData.getAsJsonObject("bag_contents").getAsJsonObject("talisman_bag"))) {
                        value += this.addItemNetworth(top, stack);
                    }
                }
            }
            for (class_1799 stack : new PetsInventoryItemLoader().loadItems(playerProfile)) {
                value += this.addItemNetworth(top, stack);
            }
        }
        catch (Exception inventoryData) {
            // empty catch block
        }
        ArrayList<ItemValue> list = new ArrayList<ItemValue>(top);
        list.sort(Comparator.comparingDouble(ItemValue::price).reversed());
        this.networthTooltip.add((class_2561)class_2561.method_43470((String)"Top Items:").method_27692(class_124.field_1065));
        for (ItemValue iv : list) {
            this.networthTooltip.add((class_2561)class_2561.method_43470((String)(iv.name + ": ")).method_10852((class_2561)class_2561.method_43470((String)ProfileViewerUtils.numLetterFormat(iv.price)).method_27692(class_124.field_1054)));
        }
        return value;
    }

    private double addItemNetworth(PriorityQueue<ItemValue> top, class_1799 stack) {
        double p = NetworthCalculator.getItemNetworth(stack).price();
        if (p > 0.0) {
            top.offer(new ItemValue(stack.method_7964().getString(), p));
            if (top.size() > 10) {
                top.poll();
            }
        }
        return p;
    }

    public void render(class_332 context, class_327 textRenderer, int root_x, int root_y, int mouseX, int mouseY) {
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.scale(0.75f, 0.75f);
        int rootAdjustedX = (int)((float)root_x / 0.75f);
        int rootAdjustedY = (int)((float)root_y / 0.75f);
        context.method_51427(Ico.PAINTING, rootAdjustedX, rootAdjustedY + 8);
        matrices.popMatrix();
        context.method_51433(textRenderer, "\u00a7n" + this.PROFILE_NAME, root_x + 14, root_y + 7, -1, true);
        context.method_51433(textRenderer, "\u00a7aLevel:\u00a7r " + this.SKYBLOCK_LEVEL, root_x + 2, root_y + 9 + 9, -1, true);
        context.method_51433(textRenderer, "\u00a76Purse:\u00a7r " + ProfileViewerUtils.numLetterFormat(this.PURSE), root_x + 2, root_y + 8 + 18, -1, true);
        context.method_51433(textRenderer, "\u00a76Bank:\u00a7r " + ProfileViewerUtils.numLetterFormat(this.BANK), root_x + 2, root_y + 7 + 27, -1, true);
        String nwString = "\u00a76NW:\u00a7r " + ProfileViewerUtils.numLetterFormat(this.NETWORTH);
        int nwX = root_x + 2;
        int nwY = root_y + 7 + 36;
        context.method_51433(textRenderer, nwString, nwX, nwY, -1, true);
        if (mouseX >= nwX && mouseX <= nwX + textRenderer.method_1727(nwString) && mouseY >= nwY) {
            Objects.requireNonNull(textRenderer);
            if (mouseY <= nwY + 9) {
                context.method_51434(textRenderer, this.networthTooltip, mouseX, mouseY);
            }
        }
        context.method_51433(textRenderer, "\u00a76MP:\u00a7r " + this.MAGICAL_POWER, root_x + 2, root_y + 7 + 45, -1, true);
    }

    private record ItemValue(String name, double price) {
    }
}

