/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.collections;

import com.google.gson.JsonObject;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerPage;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerScreen;
import de.hysky.skyblocker.skyblock.profileviewer.collections.GenericCategory;
import de.hysky.skyblocker.skyblock.profileviewer.utils.SubPageSelectButton;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import org.jspecify.annotations.Nullable;

public class CollectionsPage
implements ProfileViewerPage {
    private static final String[] COLLECTION_CATEGORIES = new String[]{"MINING", "FARMING", "COMBAT", "FISHING", "FORAGING", "RIFT"};
    private static final int TOTAL_HEIGHT = 165;
    private static final Map<String, class_1799> ICON_MAP = Map.ofEntries(Map.entry("MINING", Ico.STONE_PICKAXE), Map.entry("FARMING", Ico.GOLDEN_HOE), Map.entry("COMBAT", Ico.STONE_SWORD), Map.entry("FISHING", Ico.FISH_ROD), Map.entry("FORAGING", Ico.JUNGLE_SAPLING), Map.entry("RIFT", Ico.MYCELIUM));
    private static final class_327 textRenderer = class_310.method_1551().field_1772;
    private final @Nullable GenericCategory[] collections = new GenericCategory[COLLECTION_CATEGORIES.length];
    private final List<SubPageSelectButton> collectionSelectButtons = new ArrayList<SubPageSelectButton>();
    private int activePage = 0;

    public CollectionsPage(JsonObject hProfile, JsonObject pProfile) {
        for (int i = 0; i < COLLECTION_CATEGORIES.length; ++i) {
            try {
                this.collectionSelectButtons.add(new SubPageSelectButton(this, -100, 0, i, ICON_MAP.getOrDefault(COLLECTION_CATEGORIES[i], Ico.BARRIER)));
                this.collections[i] = new GenericCategory(hProfile, pProfile, COLLECTION_CATEGORIES[i]);
                continue;
            }
            catch (Exception e) {
                ProfileViewerScreen.LOGGER.error("[Skyblocker Profile Viewer] Error creating Collections Page", (Throwable)e);
            }
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta, int rootX, int rootY) {
        int startingY = rootY + (165 - this.collectionSelectButtons.size() * 21) / 2;
        for (int i = 0; i < this.collectionSelectButtons.size(); ++i) {
            this.collectionSelectButtons.get(i).method_46421(rootX);
            this.collectionSelectButtons.get(i).method_46419(startingY + i * 21);
            this.collectionSelectButtons.get(i).method_25394(context, mouseX, mouseY, delta);
        }
        if (this.collections[this.activePage] == null) {
            context.method_51433(textRenderer, "No data...", rootX + 92, rootY + 72, Color.DARK_GRAY.getRGB(), false);
            return;
        }
        this.collections[this.activePage].markWidgetsAsVisible();
        this.collections[this.activePage].render(context, mouseX, mouseY, delta, rootX + 35, rootY + 6);
    }

    @Override
    public void onNavButtonClick(SubPageSelectButton selectButton) {
        if (this.collections[this.activePage] != null) {
            this.collections[this.activePage].markWidgetsAsInvisible();
        }
        for (SubPageSelectButton button : this.collectionSelectButtons) {
            button.setToggled(false);
        }
        this.activePage = selectButton.getIndex();
        selectButton.setToggled(true);
    }

    @Override
    public List<class_339> getButtons() {
        ArrayList<class_339> clickableWidgets = new ArrayList<class_339>(this.collectionSelectButtons);
        for (GenericCategory page : this.collections) {
            if (page == null || page.getButtons() == null) continue;
            clickableWidgets.addAll(page.getButtons());
        }
        return clickableWidgets;
    }

    @Override
    public void markWidgetsAsVisible() {
        for (SubPageSelectButton button : this.collectionSelectButtons) {
            button.field_22764 = true;
            button.field_22763 = true;
        }
    }

    @Override
    public void markWidgetsAsInvisible() {
        for (SubPageSelectButton button : this.collectionSelectButtons) {
            button.field_22764 = false;
            button.field_22763 = false;
        }
    }
}

