/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.collections;

import com.google.gson.JsonObject;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerPage;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerScreen;
import de.hysky.skyblocker.skyblock.profileviewer.utils.Collection;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.RomanNumerals;
import it.unimi.dsi.fastutil.ints.IntList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class GenericCategory
implements ProfileViewerPage {
    private final String category;
    private final LinkedList<class_1799> collections = new LinkedList();
    private static final class_327 textRenderer = class_310.method_1551().field_1772;
    private static final class_2960 BUTTON_TEXTURE = SkyblockerMod.id("textures/gui/profile_viewer/button_icon_toggled.png");
    private static final int COLUMN_GAP = 26;
    private static final int ROW_GAP = 34;
    private static final int COLUMNS = 7;
    private final Map<String, List<Collection>> collectionsData;
    private final Map<String, String> ICON_TRANSLATION = Map.ofEntries(Map.entry("MUSHROOM_COLLECTION", "RED_MUSHROOM"));

    public GenericCategory(JsonObject hProfile, JsonObject pProfile, String collection) {
        this.collectionsData = ProfileViewerScreen.getCollections();
        this.category = collection;
        this.setupItemStacks(hProfile, pProfile);
    }

    private int calculateTier(long achieved, IntList requirements) {
        return (int)requirements.intStream().filter(req -> achieved >= (long)req).count();
    }

    private void setupItemStacks(JsonObject hProfile, JsonObject pProfile) {
        JsonObject playerCollection = pProfile.getAsJsonObject("collection");
        for (Collection collection : this.collectionsData.get(this.category)) {
            class_1799 itemStack = ItemRepository.getItemStack(this.ICON_TRANSLATION.getOrDefault(collection.id(), collection.id()).replace(':', '-'));
            class_1799 class_17992 = itemStack = itemStack == null ? Ico.BARRIER.method_7972() : itemStack.method_7972();
            if (itemStack.method_7909().method_63680().getString().equals("Barrier")) {
                itemStack.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)collection.id()));
                System.out.println(collection);
                System.out.println(this.category);
            }
            class_2583 style = class_2583.field_24360.method_10977(class_124.field_1068).method_10978(Boolean.valueOf(false));
            itemStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)class_124.method_539((String)((class_2561)itemStack.method_57353().method_58694(class_9334.field_49631)).getString())).method_10862(style));
            long personalColl = playerCollection != null && playerCollection.has(collection.id()) ? playerCollection.get(collection.id()).getAsLong() : 0L;
            long totalCollection = 0L;
            for (String member : hProfile.get("members").getAsJsonObject().keySet()) {
                if (!hProfile.getAsJsonObject("members").getAsJsonObject(member).has("collection")) continue;
                JsonObject memberColl = hProfile.getAsJsonObject("members").getAsJsonObject(member).getAsJsonObject("collection");
                totalCollection += memberColl.has(collection.id()) ? memberColl.get(collection.id()).getAsLong() : 0L;
            }
            int collectionTier = this.calculateTier(totalCollection, collection.tiers());
            IntList tierRequirements = collection.tiers();
            ArrayList<class_5250> lore = new ArrayList<class_5250>();
            lore.add(class_2561.method_43470((String)"Collection Item").method_10862(style).method_27692(class_124.field_1063));
            lore.add(class_2561.method_43473());
            if (hProfile.get("members").getAsJsonObject().keySet().size() > 1) {
                lore.add(class_2561.method_43470((String)("Personal: " + Formatters.INTEGER_NUMBERS.format(personalColl))).method_10862(style).method_27692(class_124.field_1065));
                lore.add(class_2561.method_43470((String)("Co-op: " + Formatters.INTEGER_NUMBERS.format(totalCollection - personalColl))).method_10862(style).method_27692(class_124.field_1075));
            }
            lore.add(class_2561.method_43470((String)("Collection: " + Formatters.INTEGER_NUMBERS.format(totalCollection))).method_10862(style).method_27692(class_124.field_1054));
            lore.add(class_2561.method_43473());
            lore.add(class_2561.method_43470((String)("Collection Tier: " + collectionTier + "/" + tierRequirements.size())).method_10862(style).method_27692(class_124.field_1076));
            if (collectionTier == tierRequirements.size()) {
                itemStack.method_57379(class_9334.field_49641, (Object)true);
            }
            itemStack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
            itemStack.method_57379(class_9334.field_49628, (Object)class_9279.field_49302);
            this.collections.add(itemStack);
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta, int rootX, int rootY) {
        class_5250 categoryTitle = class_2561.method_43470((String)(this.category.charAt(0) + this.category.substring(1).toLowerCase(Locale.ENGLISH) + " Collections")).method_27692(class_124.field_1067);
        context.method_51439(textRenderer, (class_2561)categoryTitle, rootX + 88 - textRenderer.method_27525((class_5348)categoryTitle) / 2, rootY, Color.DARK_GRAY.getRGB(), false);
        for (int i = 0; i < this.collections.size(); ++i) {
            int x = rootX + 2 + i % 7 * 26;
            int y = rootY + 19 + i / 7 * 34;
            context.method_25290(class_10799.field_56883, BUTTON_TEXTURE, x - 3, y - 3, 0.0f, 0.0f, 22, 22, 22, 22);
            context.method_51427(this.collections.get(i), x, y);
            class_1799 itemStack = this.collections.get(i);
            List lore = ((class_9290)itemStack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340)).comp_2400();
            for (class_2561 text : lore) {
                if (!text.getString().startsWith("Collection Tier: ")) continue;
                String tierText = text.getString().substring("Collection Tier: ".length());
                if (!tierText.contains("/")) break;
                String[] parts = tierText.split("/");
                int cTier = Integer.parseInt(parts[0].trim());
                Color colour = itemStack.method_7958() ? Color.MAGENTA : Color.darkGray;
                context.method_51439(textRenderer, (class_2561)class_2561.method_43470((String)RomanNumerals.decimalToRoman(cTier)), x + 9 - textRenderer.method_1727(RomanNumerals.decimalToRoman(cTier)) / 2, y + 21, colour.getRGB(), false);
                break;
            }
            if (mouseX <= x || mouseX >= x + 16 || mouseY <= y || mouseY >= y + 16) continue;
            List tooltip = this.collections.get(i).method_7950(class_1792.class_9635.field_51353, (class_1657)class_310.method_1551().field_1724, (class_1836)class_1836.field_41070);
            context.method_51434(textRenderer, tooltip, mouseX, mouseY);
        }
    }
}

