/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.inventory;

import com.google.gson.JsonObject;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerPage;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerScreen;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.Inventory;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.PlayerInventory;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.BackpackItemLoader;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.PetsInventoryItemLoader;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.WardrobeInventoryItemLoader;
import de.hysky.skyblocker.skyblock.profileviewer.utils.ProfileViewerUtils;
import de.hysky.skyblocker.skyblock.profileviewer.utils.SubPageSelectButton;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import org.jspecify.annotations.Nullable;

public class InventoryPage
implements ProfileViewerPage {
    private static final String[] INVENTORY_PAGES = new String[]{"inventory", "enderchest", "backpack", "wardrobe", "pets", "accessoryBag"};
    private static final int TOTAL_HEIGHT = 165;
    private static final Map<String, class_1799> ICON_MAP = Map.ofEntries(Map.entry("wardrobe", Ico.L_CHESTPLATE), Map.entry("inventory", Ico.CHEST), Map.entry("backpack", ProfileViewerUtils.createSkull("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHBzOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzYyZjNiM2EwNTQ4MWNkZTc3MjQwMDA1YzBkZGNlZTFjMDY5ZTU1MDRhNjJjZTA5Nzc4NzlmNTVhMzkzOTYxNDYifX19")), Map.entry("pets", Ico.BONE), Map.entry("enderchest", Ico.E_CHEST), Map.entry("accessoryBag", ProfileViewerUtils.createSkull("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTYxYTkxOGMwYzQ5YmE4ZDA1M2U1MjJjYjkxYWJjNzQ2ODkzNjdiNGQ4YWEwNmJmYzFiYTkxNTQ3MzA5ODVmZiJ9fX0=")));
    private static final class_327 textRenderer = class_310.method_1551().field_1772;
    private final @Nullable ProfileViewerPage[] inventorySubPages = new ProfileViewerPage[6];
    private final List<SubPageSelectButton> inventorySelectButtons = new ArrayList<SubPageSelectButton>();
    private int activePage = 0;

    public InventoryPage(JsonObject pProfile) {
        for (int i = 0; i < INVENTORY_PAGES.length; ++i) {
            this.inventorySelectButtons.add(new SubPageSelectButton(this, -100, 0, i, ICON_MAP.getOrDefault(INVENTORY_PAGES[i], Ico.BARRIER)));
        }
        try {
            JsonObject inventoryData = pProfile.getAsJsonObject("inventory");
            if (inventoryData == null) {
                return;
            }
            this.inventorySubPages[0] = new PlayerInventory(inventoryData);
            if (inventoryData.has("ender_chest_contents")) {
                this.inventorySubPages[1] = new Inventory(INVENTORY_PAGES[1], IntIntPair.of((int)5, (int)9), inventoryData.getAsJsonObject("ender_chest_contents"));
            }
            if (inventoryData.has("backpack_contents")) {
                this.inventorySubPages[2] = new Inventory(INVENTORY_PAGES[2], IntIntPair.of((int)5, (int)9), inventoryData.getAsJsonObject("backpack_contents"), new BackpackItemLoader());
            }
            if (inventoryData.has("wardrobe_contents")) {
                this.inventorySubPages[3] = new Inventory(INVENTORY_PAGES[3], IntIntPair.of((int)4, (int)9), inventoryData.getAsJsonObject("wardrobe_contents"), new WardrobeInventoryItemLoader(inventoryData));
            }
            this.inventorySubPages[4] = new Inventory(INVENTORY_PAGES[4], IntIntPair.of((int)4, (int)9), pProfile, new PetsInventoryItemLoader());
            if (inventoryData.has("bag_contents") && inventoryData.getAsJsonObject("bag_contents").has("talisman_bag")) {
                this.inventorySubPages[5] = new Inventory(INVENTORY_PAGES[5], IntIntPair.of((int)5, (int)9), inventoryData.getAsJsonObject("bag_contents").getAsJsonObject("talisman_bag"));
            }
        }
        catch (Exception e) {
            ProfileViewerScreen.LOGGER.error("[Skyblocker Profile Viewer] Error while loading inventory data: ", (Throwable)e);
        }
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta, int rootX, int rootY) {
        int startingY = rootY + (165 - this.inventorySelectButtons.size() * 21) / 2;
        for (int i = 0; i < this.inventorySelectButtons.size(); ++i) {
            this.inventorySelectButtons.get(i).method_46421(rootX);
            this.inventorySelectButtons.get(i).method_46419(startingY + i * 21);
            this.inventorySelectButtons.get(i).method_25394(context, mouseX, mouseY, delta);
        }
        if (this.inventorySubPages[this.activePage] == null) {
            context.method_51433(textRenderer, "No data...", rootX + 92, rootY + 72, Color.DARK_GRAY.getRGB(), false);
            return;
        }
        this.inventorySubPages[this.activePage].markWidgetsAsVisible();
        this.inventorySubPages[this.activePage].render(context, mouseX, mouseY, delta, rootX + 35, rootY + 6);
    }

    @Override
    public void onNavButtonClick(SubPageSelectButton clickedButton) {
        if (this.inventorySubPages[this.activePage] != null) {
            this.inventorySubPages[this.activePage].markWidgetsAsInvisible();
        }
        for (SubPageSelectButton button : this.inventorySelectButtons) {
            button.setToggled(false);
        }
        this.activePage = clickedButton.getIndex();
        clickedButton.setToggled(true);
    }

    @Override
    public List<class_339> getButtons() {
        ArrayList<class_339> clickableWidgets = new ArrayList<class_339>(this.inventorySelectButtons);
        for (ProfileViewerPage page : this.inventorySubPages) {
            if (page == null || page.getButtons() == null) continue;
            clickableWidgets.addAll(page.getButtons());
        }
        return clickableWidgets;
    }

    @Override
    public void markWidgetsAsVisible() {
        if (this.inventorySubPages[this.activePage] != null) {
            this.inventorySubPages[this.activePage].markWidgetsAsVisible();
        }
        for (SubPageSelectButton button : this.inventorySelectButtons) {
            button.field_22764 = true;
            button.field_22763 = true;
        }
    }

    @Override
    public void markWidgetsAsInvisible() {
        if (this.inventorySubPages[this.activePage] != null) {
            this.inventorySubPages[this.activePage].markWidgetsAsInvisible();
        }
        for (SubPageSelectButton button : this.inventorySelectButtons) {
            button.field_22764 = false;
            button.field_22763 = false;
        }
    }
}

