/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.slayers;

import com.google.gson.JsonObject;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.skyblock.profileviewer.utils.LevelFinder;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.render.HudHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class SlayerWidget {
    private final String slayerName;
    private final LevelFinder.LevelInfo slayerLevel;
    private JsonObject slayerData = null;
    private static final class_2960 TEXTURE = SkyblockerMod.id("textures/gui/profile_viewer/icon_data_widget.png");
    private static final class_2960 BAR_FILL = SkyblockerMod.id("bars/bar_fill");
    private static final class_2960 BAR_BACK = SkyblockerMod.id("bars/bar_back");
    private final class_2960 item;
    private final class_1799 drop;
    public static final Map<String, class_2960> HEAD_ICON = Map.ofEntries(Map.entry("Zombie", SkyblockerMod.id("textures/gui/profile_viewer/zombie.png")), Map.entry("Spider", SkyblockerMod.id("textures/gui/profile_viewer/spider.png")), Map.entry("Wolf", SkyblockerMod.id("textures/gui/profile_viewer/wolf.png")), Map.entry("Enderman", SkyblockerMod.id("textures/gui/profile_viewer/enderman.png")), Map.entry("Vampire", SkyblockerMod.id("textures/gui/profile_viewer/vampire.png")), Map.entry("Blaze", SkyblockerMod.id("textures/gui/profile_viewer/blaze.png")));
    public static final Map<String, class_1799> DROP_ICON = Map.ofEntries(Map.entry("Zombie", Ico.FLESH), Map.entry("Spider", Ico.STRING), Map.entry("Wolf", Ico.MUTTON), Map.entry("Enderman", Ico.E_PEARL), Map.entry("Vampire", Ico.REDSTONE), Map.entry("Blaze", Ico.B_POWDER));

    public SlayerWidget(String slayer, long xp, JsonObject playerProfile) {
        this.slayerName = slayer;
        this.slayerLevel = LevelFinder.getLevelInfo(slayer, xp);
        this.item = HEAD_ICON.get(slayer);
        this.drop = DROP_ICON.getOrDefault(slayer, Ico.BARRIER);
        try {
            this.slayerData = playerProfile.getAsJsonObject("slayer").getAsJsonObject("slayer_bosses").getAsJsonObject(this.slayerName.toLowerCase(Locale.ENGLISH));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void render(class_332 context, int mouseX, int mouseY, int x, int y) {
        class_327 font = class_310.method_1551().field_1772;
        context.method_25290(class_10799.field_56883, TEXTURE, x, y, 0.0f, 0.0f, 109, 26, 109, 26);
        context.method_25290(class_10799.field_56883, this.item, x + 1, y + 3, 0.0f, 0.0f, 20, 20, 20, 20);
        context.method_51433(font, this.slayerName + " " + this.slayerLevel.level, x + 31, y + 5, Color.white.hashCode(), false);
        int col2 = x + 113;
        context.method_25290(class_10799.field_56883, TEXTURE, col2, y, 0.0f, 0.0f, 109, 26, 109, 26);
        context.method_51427(this.drop, col2 + 3, y + 5);
        context.method_51433(font, "\u00a7aKills: \u00a7r" + this.findTotalKills(), col2 + 30, y + 4, Color.white.hashCode(), true);
        context.method_51433(font, this.findTopTierKills(), this.findTopTierKills().equals("No Data") ? col2 + 30 : col2 + 29, y + 15, Color.white.hashCode(), true);
        context.method_52706(class_10799.field_56883, BAR_BACK, x + 30, y + 15, 75, 6);
        Color fillColor = this.slayerLevel.fill == 1.0 ? Color.MAGENTA : Color.green;
        HudHelper.renderNineSliceColored(context, BAR_FILL, x + 30, y + 15, (int)(75.0 * this.slayerLevel.fill), 6, fillColor);
        if (mouseX > x + 30 && mouseX < x + 105 && mouseY > y + 12 && mouseY < y + 22) {
            ArrayList<class_5250> tooltipText = new ArrayList<class_5250>();
            tooltipText.add(class_2561.method_43470((String)this.slayerName).method_27692(class_124.field_1060));
            tooltipText.add(class_2561.method_43470((String)("XP: " + Formatters.INTEGER_NUMBERS.format(this.slayerLevel.xp))).method_27692(class_124.field_1065));
            context.method_51434(font, tooltipText, mouseX, mouseY);
        }
    }

    private int findTotalKills() {
        try {
            int totalKills = 0;
            for (String key : this.slayerData.keySet()) {
                if (!key.startsWith("boss_kills_tier_")) continue;
                totalKills += this.slayerData.get(key).getAsInt();
            }
            return totalKills;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String findTopTierKills() {
        try {
            for (int tier = 4; tier >= 0; --tier) {
                String key = "boss_kills_tier_" + tier;
                if (!this.slayerData.has(key)) continue;
                return "\u00a7cT" + (tier + 1) + " Kills: \u00a7r" + this.slayerData.get(key).getAsInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "No Data";
    }
}

