/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer2;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import com.mojang.util.UndashedUuid;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.skyblock.profileviewer2.ErrorProfileViewerScreen;
import de.hysky.skyblocker.skyblock.profileviewer2.LoadingProfileViewerScreen;
import de.hysky.skyblocker.skyblock.profileviewer2.ProfileViewerScreen;
import de.hysky.skyblocker.skyblock.profileviewer2.model.ApiProfile;
import de.hysky.skyblocker.skyblock.profileviewer2.model.ApiProfileResponse;
import de.hysky.skyblocker.skyblock.profileviewer2.model.ProfileMember;
import de.hysky.skyblocker.skyblock.profileviewer2.utils.LenientUuidTypeAdapter;
import de.hysky.skyblocker.utils.ApiUtils;
import de.hysky.skyblocker.utils.ProfileUtils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.Pair;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_11786;
import net.minecraft.class_2172;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_9296;
import org.slf4j.Logger;

public class ProfileViewer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = SkyblockerMod.GSON.newBuilder().registerTypeHierarchyAdapter(UUID.class, new LenientUuidTypeAdapter()).create();

    @Init
    public static void init() {
        if (!Debug.debugEnabled()) {
            return;
        }
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, commandContext) -> {
            LiteralArgumentBuilder pvCommandBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pv2").executes(Scheduler.queueOpenScreenFactoryCommand(context -> ProfileViewer.openProfileViewer((FabricClientCommandSource)context.getSource(), ((FabricClientCommandSource)context.getSource()).getClient().method_1548().method_1676())))).then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9253((String[])ProfileViewer.getPlayerSuggestions((FabricClientCommandSource)context.getSource()), (SuggestionsBuilder)builder)).executes(Scheduler.queueOpenScreenFactoryCommand(context -> ProfileViewer.openProfileViewer((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name")))));
            dispatcher.register(pvCommandBuilder);
        });
    }

    private static String[] getPlayerSuggestions(FabricClientCommandSource source) {
        return (String[])source.method_9262().stream().filter(playerName -> playerName.matches("[A-Za-z0-9_]+")).toArray(String[]::new);
    }

    private static class_437 openProfileViewer(FabricClientCommandSource source, String name) {
        class_310 minecraft = source.getClient();
        CompletionStage dataFuture = ((CompletableFuture)((CompletableFuture)ProfileViewer.loadData(name).thenApplyAsync(pair -> {
            Optional apiProfileResponse = (Optional)pair.left();
            Optional<ApiProfile> selectedProfile = apiProfileResponse.map(ApiProfileResponse::getSelectedProfile);
            Optional gameProfile = (Optional)pair.right();
            boolean loadedSkyblockProfile = apiProfileResponse.isPresent();
            boolean hasSkyblockProfile = selectedProfile.isPresent();
            boolean loadedGameProfile = gameProfile.isPresent();
            if (!loadedSkyblockProfile) {
                return new ErrorProfileViewerScreen("Failed to load Skyblock profiles.");
            }
            if (!hasSkyblockProfile) {
                return new ErrorProfileViewerScreen("This user has no Skyblock profiles.");
            }
            if (!loadedGameProfile) {
                return new ErrorProfileViewerScreen("Player not found.");
            }
            ProfileMember member = Objects.requireNonNull(selectedProfile.get().members.get(((GameProfile)gameProfile.get()).id()), "profile member must not be null");
            LOGGER.info("[Skyblocker Profile Viewer] Successfully loaded the profile for {}!", (Object)name);
            return new ProfileViewerScreen((ApiProfileResponse)apiProfileResponse.get(), selectedProfile.get(), (GameProfile)gameProfile.get(), member);
        }, (Executor)minecraft)).thenAcceptAsync(arg_0 -> ((class_310)minecraft).method_1507(arg_0), (Executor)minecraft)).exceptionallyAsync(throwable -> {
            LOGGER.error("[Skyblocker Profile Viewer] Encountered an unknown exception when loading the data.", throwable);
            minecraft.method_1507((class_437)new ErrorProfileViewerScreen("Encountered an unknown error."));
            return null;
        }, (Executor)minecraft);
        return new LoadingProfileViewerScreen(name);
    }

    private static CompletableFuture<Pair<Optional<ApiProfileResponse>, Optional<GameProfile>>> loadData(String name) {
        class_310 minecraft = class_310.method_1551();
        CompletionStage dataFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> ApiUtils.name2Uuid(name), Executors.newVirtualThreadPerTaskExecutor()).thenComposeAsync(uuid -> {
            if (uuid.isEmpty()) {
                return CompletableFuture.failedStage(new IllegalStateException("Invalid username"));
            }
            CompletionStage skyblockProfileFuture = ProfileUtils.fetchFullProfileByUuid(uuid).thenApply(Optional::ofNullable);
            class_9296 resolvableProfile = class_9296.method_73312((UUID)UndashedUuid.fromString((String)uuid));
            CompletionStage gameProfileFuture = minecraft.method_73362().method_74320(resolvableProfile).thenApply(optional -> optional.map(class_11786.class_11787::method_73502));
            return ((CompletableFuture)skyblockProfileFuture).thenCombine(gameProfileFuture, Pair::of);
        }, (Executor)Executors.newVirtualThreadPerTaskExecutor())).thenApplyAsync(pair -> Pair.of(((Optional)pair.left()).map(json -> GSON.fromJson((JsonElement)json, ApiProfileResponse.class)), (Object)((Optional)pair.right())), (Executor)Executors.newVirtualThreadPerTaskExecutor());
        return dataFuture;
    }
}

