/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer2;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import de.hysky.skyblocker.skyblock.profileviewer2.AbstractProfileViewerScreen;
import de.hysky.skyblocker.skyblock.profileviewer2.LoadingInformation;
import de.hysky.skyblocker.skyblock.profileviewer2.model.ApiProfile;
import de.hysky.skyblocker.skyblock.profileviewer2.model.ApiProfileResponse;
import de.hysky.skyblocker.skyblock.profileviewer2.model.ProfileMember;
import de.hysky.skyblocker.skyblock.profileviewer2.pages.ProfileViewerPage;
import de.hysky.skyblocker.skyblock.profileviewer2.pages.SkillsPage;
import de.hysky.skyblocker.skyblock.profileviewer2.pages.SlayersPage;
import de.hysky.skyblocker.skyblock.profileviewer2.widgets.PageTabWidget;
import de.hysky.skyblocker.skyblock.profileviewer2.widgets.ProfileViewerWidget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_7413;
import net.minecraft.class_7843;

public final class ProfileViewerScreen
extends AbstractProfileViewerScreen {
    private final ApiProfileResponse apiProfileResponse;
    private final ApiProfile profile;
    private final GameProfile userProfile;
    private final ProfileMember member;
    private final long openedAt = System.currentTimeMillis();
    private final List<ProfileViewerPage<?>> pages = List.of(new SkillsPage(), new SlayersPage());
    private final Set<ProfileViewerPage<?>> loadedPages = new HashSet();
    private final List<PageTabWidget> tabWidgets = List.of(this.createPageTab(0), this.createPageTab(1));
    private final class_7843 contentLayout = new class_7843(337, 183);
    private int selectedPageIndex;

    protected ProfileViewerScreen(ApiProfileResponse apiProfileResponse, ApiProfile profile, GameProfile userProfile, ProfileMember member) {
        super((class_2561)class_2561.method_43470((String)"Skyblocker Profile Viewer"));
        this.apiProfileResponse = apiProfileResponse;
        this.profile = profile;
        this.userProfile = userProfile;
        this.member = member;
        this.loadPages();
        this.setSelectedPage(0);
    }

    private PageTabWidget createPageTab(int index) {
        return new PageTabWidget(this.pages.get(index).getIcon(), index, this::setSelectedPage);
    }

    private LoadingInformation createLoadingInformation() {
        return new LoadingInformation(this.profile, this.userProfile, this.member);
    }

    private void loadPages() {
        LoadingInformation loadingInformation = this.createLoadingInformation();
        for (ProfileViewerPage<?> page : this.pages) {
            page.load(loadingInformation).thenAcceptAsync(layoutElement -> {
                this.contentLayout.method_52732(layoutElement, l -> l.method_46472().method_46461());
                this.contentLayout.method_48222();
                this.method_48640();
                this.loadedPages.add(page);
            }, (Executor)this.field_22787);
        }
    }

    private ProfileViewerPage<?> getSelectedPage() {
        return this.pages.get(this.selectedPageIndex);
    }

    public void setSelectedPage(int index) {
        this.selectedPageIndex = Preconditions.checkPositionIndex((int)index, (int)this.pages.size());
        for (PageTabWidget tabWidget : this.tabWidgets) {
            tabWidget.setSelected(this.selectedPageIndex == this.tabWidgets.indexOf((Object)tabWidget));
        }
    }

    public List<? extends class_364> method_25396() {
        ArrayList<ProfileViewerWidget> children = new ArrayList<ProfileViewerWidget>();
        children.addAll(this.getSelectedPage().getWidgets());
        children.addAll(this.tabWidgets);
        return children;
    }

    protected void method_25426() {
        this.method_48640();
    }

    protected void method_48640() {
        for (PageTabWidget widget : this.tabWidgets) {
            widget.updatePosition(this.getBackgroundX(), this.getBackgroundY());
        }
        this.contentLayout.method_48229(this.getBackgroundX() + 8, this.getBackgroundY() + 8);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float a) {
        this.renderTabButtons(graphics, mouseX, mouseY, a, false);
        super.method_25394(graphics, mouseX, mouseY, a);
        this.renderTabButtons(graphics, mouseX, mouseY, a, true);
        ProfileViewerPage<?> selectedPage = this.getSelectedPage();
        if (this.loadedPages.contains(selectedPage)) {
            for (ProfileViewerWidget widget : selectedPage.getWidgets()) {
                widget.method_25394(graphics, mouseX, mouseY, a);
            }
        } else {
            int centreX = this.getBackgroundX() + 176;
            int centreY = this.getBackgroundY() + 99;
            long timeLoadingPage = System.currentTimeMillis() - this.openedAt;
            class_5250 pageLoadingText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Loading the ")).method_10852(selectedPage.getName()).method_10852((class_2561)class_2561.method_43470((String)" page..."));
            class_5250 loadingDotsText = class_2561.method_43470((String)class_7413.method_43449((long)timeLoadingPage));
            Objects.requireNonNull(this.field_22793);
            graphics.method_27534(this.field_22793, (class_2561)pageLoadingText, centreX, centreY - 9, -1);
            Objects.requireNonNull(this.field_22793);
            graphics.method_27534(this.field_22793, (class_2561)loadingDotsText, centreX, centreY + 9, -1);
        }
    }

    private void renderTabButtons(class_332 graphics, int mouseX, int mouseY, float a, boolean onlySelected) {
        for (PageTabWidget tabWidget : this.tabWidgets) {
            if (onlySelected && this.tabWidgets.indexOf((Object)tabWidget) != this.selectedPageIndex) continue;
            tabWidget.method_25394(graphics, mouseX, mouseY, a);
        }
    }
}

