/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer2.model;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jspecify.annotations.Nullable;

public class CommunityUpgrades {
    @SerializedName(value="currently_upgrading")
    public @Nullable CurrentlyUpgrading currentlyUpgrading;
    @SerializedName(value="upgrade_states")
    public List<UpgradeState> upgradeStates = List.of();

    public int getUpgradeTier(String upgradeId) {
        int tier = 0;
        for (UpgradeState upgradeState : this.upgradeStates) {
            if (!Objects.equals(upgradeId, upgradeState.upgradeId)) continue;
            tier = Math.max(tier, upgradeState.tier);
        }
        return tier;
    }

    public static class UpgradeState {
        @SerializedName(value="upgrade")
        public String upgradeId = "";
        public int tier;
        @SerializedName(value="started_ms")
        public long startedAt;
        @SerializedName(value="started_by")
        public UUID startedBy = UUID.randomUUID();
        @SerializedName(value="claimed_by")
        public UUID claimedBy = UUID.randomUUID();
    }

    public static class CurrentlyUpgrading {
        @SerializedName(value="upgrade")
        public String upgradeId = "";
        @SerializedName(value="new_tier")
        public int newTier;
        @SerializedName(value="start_ms")
        public long startedAt;
        @SerializedName(value="who_started")
        public UUID startedBy = UUID.randomUUID();
    }
}

