/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer2.model;

import com.google.gson.annotations.SerializedName;
import de.hysky.skyblocker.skyblock.dungeon.DungeonClass;
import de.hysky.skyblocker.skyblock.profileviewer2.model.DefaultCatacombs;
import de.hysky.skyblocker.skyblock.profileviewer2.model.GenericCatacombs;
import de.hysky.skyblocker.skyblock.profileviewer2.model.Treasures;
import de.hysky.skyblocker.skyblock.profileviewer2.utils.LevelCalculator;
import de.hysky.skyblocker.skyblock.profileviewer2.utils.LevelInfo;
import de.hysky.skyblocker.skyblock.profileviewer2.utils.Skill;
import java.time.LocalDate;
import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class Dungeons {
    @SerializedName(value="last_dungeon_run")
    public String lastDungeonRun = "";
    public int secrets;
    @SerializedName(value="selected_dungeon_class")
    public String selectedDungeonClass = "";
    @SerializedName(value="daily_runs")
    public DailyRuns dailyRuns = new DailyRuns();
    public Treasures treasures = new Treasures();
    @SerializedName(value="player_classes")
    public Map<String, ClassStats> classStats = Map.of();
    @SerializedName(value="dungeon_types")
    public PerDungeonType dungeonInfo;

    public ClassStats getClassData(DungeonClass dungeonClass) {
        return this.classStats.getOrDefault(dungeonClass.name().toLowerCase(Locale.ENGLISH), new ClassStats());
    }

    public static class DailyRuns {
        @SerializedName(value="current_day_stamp")
        public int currentDayStamp;
        @SerializedName(value="completed_runs_count")
        public int completedRunsCount;

        public @Nullable LocalDate getLastDailyRunDate() {
            if (this.currentDayStamp == 0) {
                return null;
            }
            return LocalDate.ofEpochDay(this.currentDayStamp);
        }
    }

    public static class ClassStats {
        public double experience;

        public LevelInfo getLevelInfo() {
            return LevelCalculator.getSkillLevel((long)this.experience, Skill.CATACOMBS);
        }
    }

    public static class PerDungeonType {
        @SerializedName(value="master_catacombs")
        public GenericCatacombs masterModeCatacombs = new GenericCatacombs();
        public DefaultCatacombs catacombs = new DefaultCatacombs();
    }
}

