/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer2.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import de.hysky.skyblocker.SkyblockerMod;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class EasterEvent {
    @SerializedName(value="chocolate")
    public long currentChocolate;
    @SerializedName(value="chocolate_since_prestige")
    public long chocolateSincePrestige;
    @SerializedName(value="total_chocolate")
    public long allTimeChocolate;
    @SerializedName(value="employees")
    public Employees employeeLevels = new Employees();
    @SerializedName(value="last_viewed_chocolate_factory")
    public long lastViewedChocolateFactory;
    @SerializedName(value="rabbits")
    private JsonObject rawRabbits = new JsonObject();
    public Shop shop = new Shop();
    @SerializedName(value="rabbit_barn_capacity_level")
    public int barnCapacity;
    @SerializedName(value="chocolate_level")
    public int chocolateFactoryLevel;
    @SerializedName(value="time_tower")
    public TimeTower timeTower = new TimeTower();
    @SerializedName(value="el_dorado_progress")
    public int elDoradoProgress;
    @SerializedName(value="chocolate_multiplier_upgrades")
    public int chocolateMultiplierUpgrades;
    @SerializedName(value="rabbit_rarity_upgrades")
    public int rabbitRarityUpgrade;
    @SerializedName(value="golden_click_amount")
    public int goldenClickAmount;
    @SerializedName(value="golden_click_year")
    public int goldenClickYear;
    @SerializedName(value="click_upgrades")
    public int clickUpgrades;
    @SerializedName(value="supreme_chocolate_bars")
    public int supremeChocolateBars;
    @SerializedName(value="refined_dark_cacao_truffles")
    public int refinedDarkCocoaTrufflesConsumer;
    @SerializedName(value="rabbit_hitmen")
    public Hitmen hitmen = new Hitmen();
    private transient @Nullable CollectedEggs collectedEggs;
    private transient @Nullable Map<String, Integer> rabbitCollectionCount;

    public Map<String, Integer> getRabbitCount() {
        if (this.rabbitCollectionCount == null) {
            this.rabbitCollectionCount = new Object2IntOpenHashMap(this.rawRabbits.size());
            for (Map.Entry<String, JsonElement> entry : this.rawRabbits.entrySet()) {
                if (Objects.equals(entry.getKey(), "collected_eggs")) continue;
                this.rabbitCollectionCount.put(entry.getKey(), entry.getValue().getAsInt());
            }
        }
        return this.rabbitCollectionCount;
    }

    public CollectedEggs getLastCollectedEggs() {
        if (this.collectedEggs == null) {
            this.collectedEggs = SkyblockerMod.GSON.fromJson((JsonElement)this.rawRabbits.getAsJsonObject("collected_eggs"), CollectedEggs.class);
        }
        return this.collectedEggs;
    }

    public static class Employees {
        @SerializedName(value="rabbit_bro")
        public long rabbitBro;
        @SerializedName(value="rabbit_cousin")
        public long rabbitCousin;
        @SerializedName(value="rabbit_sis")
        public long rabbitSis;
        @SerializedName(value="rabbit_father")
        public long rabbitFather;
        @SerializedName(value="rabbit_grandma")
        public long rabbitGrandma;
        @SerializedName(value="rabbit_uncle")
        public long rabbitUncle;
        @SerializedName(value="rabbit_dog")
        public long rabbitDog;
    }

    public static class Shop {
        public int year;
        public List<String> rabbits = List.of();
        @SerializedName(value="chocolate_spent")
        public long chocolateSpent;
        @SerializedName(value="cocoa_fortune_upgrades")
        public int cocoaFortuneUpgrade;
    }

    public static class TimeTower {
        public int charges;
        public int level;
        @SerializedName(value="activation_time")
        public long activationTime;
        @SerializedName(value="last_charge_time")
        public long lastChargeTime;
    }

    public static class Hitmen {
        @SerializedName(value="rabbit_hitmen_slots")
        public int unlockedSlots;
        @SerializedName(value="missed_uncollected_eggs")
        public int uncollectedEggCount;
        @SerializedName(value="egg_slot_cooldown_mark")
        public long eggSlotCooldownTimestamp;
        @SerializedName(value="egg_slot_cooldown_sum")
        public long eggSlotCooldownSum;
    }

    public static class CollectedEggs {
        public long breakfast;
        public long dinner;
        public long lunch;
        public long brunch;
        public long dejeuner;
        public long supper;
    }
}

