/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer2.model;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jspecify.annotations.Nullable;

public class GenericCatacombs {
    @SerializedName(value="best_score")
    public PersonalBest bestScore = new PersonalBest();
    @SerializedName(value="fastest_time")
    public PersonalBest fastestTime = new PersonalBest();
    @SerializedName(value="mobs_killed")
    public AggregateStat mobsKilled = new AggregateStat();
    @SerializedName(value="most_mobs_killed")
    public PersonalBest mobsKilledInOneRun = new PersonalBest();
    @SerializedName(value="most_healing")
    public PersonalBest mostHealing = new PersonalBest();
    @SerializedName(value="tier_completions")
    public AggregateStat tierCompletions = new AggregateStat();
    @SerializedName(value="milestone_completions")
    public AggregateStat milestoneCompletions = new AggregateStat();
    @SerializedName(value="fastest_time_s")
    public PersonalBest fastestTimeS = new PersonalBest();
    @SerializedName(value="fastest_time_s_plus")
    public PersonalBest fastestTimeSPlus = new PersonalBest();
    @SerializedName(value="most_damage_mage")
    public PersonalBest mostMageDamage = new PersonalBest();
    @SerializedName(value="most_damage_archer")
    public PersonalBest mostDamageArcher = new PersonalBest();
    @SerializedName(value="most_damage_berserk")
    public PersonalBest mostDamageBeserk = new PersonalBest();
    @SerializedName(value="most_damage_tank")
    public PersonalBest mostDamageTank = new PersonalBest();
    @SerializedName(value="most_damage_healer")
    public PersonalBest mostDamageHealer = new PersonalBest();
    @SerializedName(value="highest_tier_completed")
    public int highestTierCompleted;
    @SerializedName(value="best_runs")
    public Map<String, List<BestRun>> bestRuns = Map.of();

    public static class PersonalBest
    extends PerFloorDisambiguation {
        public @Nullable Double best;
    }

    public static class AggregateStat
    extends PerFloorDisambiguation {
        public double total;

        private static double coerce0(@Nullable Double d) {
            return d != null ? d : 0.0;
        }

        public double getManuallyCalculatedTotal() {
            double result = 0.0;
            result += AggregateStat.coerce0(this.entrance);
            result += AggregateStat.coerce0(this.one);
            result += AggregateStat.coerce0(this.two);
            result += AggregateStat.coerce0(this.three);
            result += AggregateStat.coerce0(this.four);
            result += AggregateStat.coerce0(this.five);
            result += AggregateStat.coerce0(this.six);
            return result += AggregateStat.coerce0(this.seven);
        }
    }

    public static class PerFloorDisambiguation {
        @SerializedName(value="0")
        public @Nullable Double entrance;
        @SerializedName(value="1")
        public @Nullable Double one;
        @SerializedName(value="2")
        public @Nullable Double two;
        @SerializedName(value="3")
        public @Nullable Double three;
        @SerializedName(value="4")
        public @Nullable Double four;
        @SerializedName(value="5")
        public @Nullable Double five;
        @SerializedName(value="6")
        public @Nullable Double six;
        @SerializedName(value="7")
        public @Nullable Double seven;

        public double getValueOrZero(int oneIndexedFloor) {
            Double value = this.getValue(oneIndexedFloor);
            if (value == null) {
                return 0.0;
            }
            return value;
        }

        public @Nullable Double getValue(int oneIndexedFloor) {
            return switch (oneIndexedFloor) {
                case 0 -> this.entrance;
                case 1 -> this.one;
                case 2 -> this.two;
                case 3 -> this.three;
                case 4 -> this.four;
                case 5 -> this.five;
                case 6 -> this.six;
                case 7 -> this.seven;
                default -> throw new IllegalStateException("Unexpected floor: " + oneIndexedFloor);
            };
        }
    }

    public static class BestRun {
        public long timestamp;
        @SerializedName(value="score_exploration")
        public int scoreExploration;
        @SerializedName(value="score_speed")
        public int scoreSpeed;
        @SerializedName(value="score_skill")
        public int scoreSkill;
        @SerializedName(value="score_bonus")
        public int scoreBonus;
        @SerializedName(value="dungeon_class")
        public String dungeonClass;
        public List<UUID> teammates = List.of();
        @SerializedName(value="elapsed_time")
        public int elapsedTime;
        @SerializedName(value="damage_dealt")
        public double damageDealt;
        public int deaths;
        @SerializedName(value="mobs_killed")
        public int mobsKilled;
        @SerializedName(value="secrets_found")
        public int secretsFound;
        @SerializedName(value="damage_mitigated")
        public double damageMitigated;
        @SerializedName(value="ally_healing")
        public double allyHealing;
    }
}

