/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer2.model;

import com.google.gson.annotations.SerializedName;
import de.hysky.skyblocker.skyblock.profileviewer2.utils.LevelCalculator;
import de.hysky.skyblocker.skyblock.profileviewer2.utils.LevelInfo;
import de.hysky.skyblocker.skyblock.profileviewer2.utils.Skill;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlayerData {
    @SerializedName(value="visited_zones")
    public Set<String> visitedZones = Set.of();
    @SerializedName(value="last_death")
    public long lastDeath;
    @SerializedName(value="perks")
    public Map<String, Integer> essencePerks = Map.of();
    @SerializedName(value="garden_chips")
    public Map<String, Integer> gardenChips = Map.of();
    @SerializedName(value="active_effects")
    public List<Effect> activeEffects = List.of();
    @SerializedName(value="reaper_peppers_eaten")
    public int reaperPeppersEaten;
    @SerializedName(value="death_count")
    public int deathCount;
    @SerializedName(value="disabled_potion_effects")
    public Set<String> disabledPotionEffects = Set.of();
    @SerializedName(value="achievement_spawned_island_types")
    public Set<String> spawnedIslandTypes = Set.of();
    @SerializedName(value="visited_modes")
    public Set<String> visitedIslandModes = Set.of();
    @SerializedName(value="unlocked_coll_tiers")
    public Set<String> unlockedCollectionTiers = Set.of();
    @SerializedName(value="crafted_generators")
    public Set<String> craftedMinions = Set.of();
    @SerializedName(value="fishing_treasure_caught")
    public int fishingTreasuresCaught;
    public Map<String, Double> experience = Map.of();

    public boolean hasCraftedMinionTier(String minionType, int tier) {
        return this.craftedMinions.contains(String.format("%s_%d", minionType, tier));
    }

    public double getSkillExperience(Skill skill) {
        return this.experience.getOrDefault("SKILL_" + skill.name(), 0.0);
    }

    public LevelInfo getSkillLevel(Skill skill) {
        return LevelCalculator.getSkillLevel((long)this.getSkillExperience(skill), skill);
    }

    public int getMinionTier(String resource) {
        int i;
        for (i = 1; i < 15 && this.hasCraftedMinionTier(resource, i); ++i) {
        }
        return i - 1;
    }

    public static class Effect {
        @SerializedName(value="effect")
        public String effectId = "";
        public int level = 1;
        @SerializedName(value="ticks_remaining")
        public long ticksRemaining;
        public boolean infinite;
        public int flags;
    }
}

