/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.quicknav;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.mixins.accessors.AbstractContainerScreenAccessor;
import de.hysky.skyblocker.mixins.accessors.PopupScreenAccessor;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.render.gui.AbstractPopupScreen;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import java.time.Duration;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_476;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8816;
import net.minecraft.class_8824;
import net.minecraft.class_9848;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class QuickNavButton
extends class_339 {
    private static final long TOGGLE_DURATION = 1000L;
    private final int index;
    private final boolean toggled;
    private final String command;
    private final class_1799 icon;
    protected final class_7919 tooltip;
    private boolean temporaryToggled = false;
    private long toggleTime;
    private boolean renderInFront;
    private int alpha = 255;

    private boolean isTopTab() {
        return this.index < 7;
    }

    public boolean toggled() {
        return this.toggled || this.temporaryToggled;
    }

    public void setRenderInFront(boolean renderInFront) {
        this.renderInFront = renderInFront;
    }

    public float method_75798() {
        return (float)this.alpha / 255.0f;
    }

    public QuickNavButton(int index, boolean toggled, String command, class_1799 icon, String tooltip) {
        super(0, 0, 26, 32, (class_2561)class_2561.method_43473());
        class_7919 tip;
        this.index = index;
        this.toggled = toggled;
        this.command = command;
        this.icon = icon;
        this.toggleTime = 0L;
        if (tooltip == null || tooltip.isEmpty()) {
            this.tooltip = null;
            return;
        }
        try {
            tip = class_7919.method_47407((class_2561)((class_2561)((Pair)class_8824.field_46597.decode((DynamicOps)JsonOps.INSTANCE, (Object)SkyblockerMod.GSON.fromJson(tooltip, JsonElement.class)).getOrThrow()).getFirst()));
            this.method_47400(tip);
        }
        catch (Exception e) {
            tip = class_7919.method_47407((class_2561)class_2561.method_43470((String)tooltip));
            this.method_47400(tip);
        }
        this.tooltip = tip;
        this.method_47402(Duration.ofMillis(100L));
    }

    private void updateCoordinates() {
        class_437 screen = class_310.method_1551().field_1755;
        while (screen instanceof class_8816 || screen instanceof AbstractPopupScreen) {
            if (screen instanceof class_8816) {
                if (!(screen instanceof PopupScreenAccessor)) {
                    throw new IllegalStateException("Current PopupScreen does not support AccessorPopupBackground");
                }
                PopupScreenAccessor popup = (PopupScreenAccessor)screen;
                screen = popup.getUnderlyingScreen();
                continue;
            }
            if (!(screen instanceof AbstractPopupScreen)) continue;
            AbstractPopupScreen abstractPopupScreen = (AbstractPopupScreen)screen;
            screen = abstractPopupScreen.backgroundScreen;
        }
        if (screen instanceof class_465) {
            class_465 handledScreen = (class_465)screen;
            AbstractContainerScreenAccessor accessibleScreen = (AbstractContainerScreenAccessor)handledScreen;
            int x = accessibleScreen.getX();
            int y = accessibleScreen.getY();
            int h = accessibleScreen.getImageHeight();
            if (handledScreen instanceof class_476) {
                --h;
            }
            int w = accessibleScreen.getImageWidth();
            this.method_46421(x + this.index % 7 * 25 + w / 2 - 88);
            this.method_46419(this.index < 7 ? y - 28 : y + h - 4);
        }
    }

    public void method_25348(class_11909 click, boolean doubled) {
        if (!this.temporaryToggled) {
            this.temporaryToggled = true;
            this.toggleTime = System.currentTimeMillis();
            if (this.command == null || this.command.isEmpty()) {
                class_310.method_1551().field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43470((String)("Quick Nav button index " + (this.index + 1) + " has no command!")).method_27692(class_124.field_1061)), false);
            } else {
                MessageScheduler.INSTANCE.sendMessageAfterCooldown(this.command, true);
            }
            this.alpha = 0;
        }
    }

    public @Nullable class_8016 method_48205(class_8023 navigation) {
        return null;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        this.updateCoordinates();
        if (this.temporaryToggled && System.currentTimeMillis() - this.toggleTime >= 1000L) {
            this.temporaryToggled = false;
        }
        if (this.alpha < 255) {
            this.alpha = Math.min(this.alpha + 10, 255);
        }
        class_2960 tabTexture = class_2960.method_60656((String)("container/creative_inventory/tab_" + (this.isTopTab() ? "top" : "bottom") + "_" + (this.renderInFront ? "selected" : "unselected") + "_" + (this.index % 7 + 1)));
        context.method_52707(class_10799.field_56883, tabTexture, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, this.renderInFront ? class_9848.method_61330((int)this.alpha, (int)-1) : -1);
        int yOffset = this.index < 7 ? 1 : -1;
        context.method_51427(this.icon, this.method_46426() + 5, this.method_46427() + 8 + yOffset);
        this.method_76256(context);
    }

    protected void method_47399(class_6382 builder) {
    }
}

