/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.radialMenu;

import de.hysky.skyblocker.skyblock.radialMenu.RadialButton;
import de.hysky.skyblocker.skyblock.radialMenu.RadialMenu;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1712;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.minecraft.class_8028;

public class RadialMenuScreen
extends class_437
implements class_1712 {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final int INTERNAL_RADIUS = 55;
    private static final int EXTERNAL_RADIUS = 110;
    private static final long NAVIGATION_DIRECTION_COOLDOWN_DELAY = 500L;
    private final class_1707 handler;
    private final RadialMenu menuType;
    private final Int2ObjectOpenHashMap<class_1799> options = new Int2ObjectOpenHashMap();
    private final List<RadialButton> buttons = new ArrayList<RadialButton>();
    private final class_2561 parentName;
    private float buttonArcSize;
    private int buttonsHoveredIndex = -1;
    private class_8028 lastNavigationDirectionInput = null;
    private long navigationDirectionLastTime;
    private int navigationDirection = 1;

    public RadialMenuScreen(class_1707 handler, RadialMenu type, class_2561 title) {
        super(type.getTitle(title));
        this.menuType = type;
        this.parentName = title;
        this.options.clear();
        this.handler = handler;
        handler.method_7596((class_1712)this);
    }

    protected void method_25426() {
        super.method_25426();
        this.buttons.clear();
        this.method_37067();
        float angle = 0.0f;
        int index = 0;
        this.buttonArcSize = (float)(Math.PI * 2 / (double)this.options.size());
        ArrayList optionOrdered = new ArrayList(this.options.int2ObjectEntrySet().stream().toList());
        String[] navigationNames = this.menuType.getNavigationItemNames();
        ArrayList navigationEntries = new ArrayList();
        for (String navigationName : navigationNames) {
            optionOrdered.stream().filter(option -> RadialMenuScreen.validName((class_1799)option.getValue(), navigationName)).findAny().ifPresent(navigationEntries::add);
        }
        int bottom = Math.ceilDiv(optionOrdered.size() - navigationEntries.size(), 2);
        for (Int2ObjectMap.Entry entry : navigationEntries) {
            optionOrdered.remove(entry);
        }
        for (Int2ObjectMap.Entry entry : navigationEntries) {
            optionOrdered.add(bottom, entry);
        }
        for (Int2ObjectMap.Entry stack : optionOrdered) {
            RadialButton newButton = new RadialButton(angle, this.buttonArcSize, 55.0f, 110.0f, (class_1799)stack.getValue(), this.getButtonHovered(index), stack.getIntKey());
            this.buttons.add(newButton);
            this.method_37063(newButton);
            angle += this.buttonArcSize;
            ++index;
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.config.uiAndVisuals.radialMenu.hideButton"), this::hide).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.uiAndVisuals.radialMenu.hideButton.@Tooltip"))).method_46433(this.field_22789 - 50, this.field_22790 - 25).method_46437(40, 15).method_46431());
    }

    private BooleanSupplier getButtonHovered(int index) {
        return () -> this.buttonsHoveredIndex == index;
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        if (RadialMenuScreen.CLIENT.field_1755 == null) {
            return;
        }
        float actualX = (float)(mouseX * 2.0) - (float)RadialMenuScreen.CLIENT.field_1755.field_22789;
        float actualY = (float)(mouseY * 2.0) - (float)RadialMenuScreen.CLIENT.field_1755.field_22790;
        if (actualX > (float)(RadialMenuScreen.CLIENT.field_1755.field_22789 - 100) && actualY > (float)(RadialMenuScreen.CLIENT.field_1755.field_22790 - 50)) {
            this.buttonsHoveredIndex = -1;
            return;
        }
        double angle = -Math.atan2(actualX, actualY) + Math.PI;
        this.buttonsHoveredIndex = (int)(angle / (double)this.buttonArcSize);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (this.buttonsHoveredIndex != -1 && this.buttonsHoveredIndex < this.buttons.size()) {
            this.clickSlot(this.buttons.get(this.buttonsHoveredIndex).getLinkedSlot(), click.method_74245());
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25404(class_11908 keyEvent) {
        switch (keyEvent.comp_4795()) {
            case 262: {
                this.navigateDirection(class_8028.field_41829);
                break;
            }
            case 263: {
                this.navigateDirection(class_8028.field_41828);
                break;
            }
            case 264: {
                this.navigateDirection(class_8028.field_41827);
                break;
            }
            case 265: {
                this.navigateDirection(class_8028.field_41826);
                break;
            }
            case 32: 
            case 257: {
                this.clickSlot();
                break;
            }
            default: {
                if (RadialMenuScreen.CLIENT.field_1690.field_1894.method_1417(keyEvent)) {
                    this.navigateDirection(class_8028.field_41826);
                    break;
                }
                if (RadialMenuScreen.CLIENT.field_1690.field_1881.method_1417(keyEvent)) {
                    this.navigateDirection(class_8028.field_41827);
                    break;
                }
                if (RadialMenuScreen.CLIENT.field_1690.field_1913.method_1417(keyEvent)) {
                    this.navigateDirection(class_8028.field_41828);
                    break;
                }
                if (RadialMenuScreen.CLIENT.field_1690.field_1849.method_1417(keyEvent)) {
                    this.navigateDirection(class_8028.field_41829);
                    break;
                }
                return super.method_25404(keyEvent);
            }
        }
        return false;
    }

    private void navigateDirection(class_8028 direction) {
        boolean skipUpdate;
        boolean bl = skipUpdate = this.buttonsHoveredIndex == -1;
        if (this.buttonsHoveredIndex == -1) {
            switch (direction) {
                default: {
                    throw new MatchException(null, null);
                }
                case field_41826: {
                    int n = 0;
                    break;
                }
                case field_41827: {
                    int n = this.buttons.size() / 2;
                    break;
                }
                case field_41828: {
                    int n = (int)((double)this.buttons.size() * 0.75);
                    break;
                }
                case field_41829: {
                    int n = this.buttonsHoveredIndex = (int)((double)this.buttons.size() * 0.25);
                }
            }
        }
        if (this.lastNavigationDirectionInput != direction || System.currentTimeMillis() > this.navigationDirectionLastTime + 500L) {
            this.lastNavigationDirectionInput = direction;
            float angle = (float)this.buttonsHoveredIndex * this.buttonArcSize;
            switch (direction) {
                default: {
                    throw new MatchException(null, null);
                }
                case field_41826: {
                    int n;
                    if ((double)angle > Math.PI) {
                        n = 1;
                        break;
                    }
                    n = -1;
                    break;
                }
                case field_41827: {
                    int n;
                    if ((double)angle > Math.PI) {
                        n = -1;
                        break;
                    }
                    n = 1;
                    break;
                }
                case field_41828: {
                    int n;
                    if ((double)angle > 1.5707963267948966 && (double)angle < 4.71238898038469) {
                        n = 1;
                        break;
                    }
                    n = -1;
                    break;
                }
                case field_41829: {
                    int n = this.navigationDirection = (double)angle > 1.5707963267948966 && (double)angle < 4.71238898038469 ? -1 : 1;
                }
            }
        }
        if (skipUpdate) {
            return;
        }
        this.buttonsHoveredIndex += this.navigationDirection;
        if (this.buttonsHoveredIndex < 0) {
            this.buttonsHoveredIndex = this.buttons.size() - 1;
        }
        if (this.buttonsHoveredIndex >= this.buttons.size()) {
            this.buttonsHoveredIndex = 0;
        }
        this.navigationDirectionLastTime = System.currentTimeMillis();
    }

    private void hide(class_4185 button) {
        if (RadialMenuScreen.CLIENT.field_1724 == null) {
            return;
        }
        CLIENT.method_1507((class_437)new class_476(this.handler, RadialMenuScreen.CLIENT.field_1724.method_31548(), this.parentName));
    }

    private static boolean validName(class_1799 stack, String validName) {
        class_2561 customName = stack.method_65130();
        if (customName == null) {
            return false;
        }
        return customName.getString().equals(validName);
    }

    private void clickSlot() {
        if (this.buttonsHoveredIndex != -1 && this.buttonsHoveredIndex < this.buttons.size()) {
            this.clickSlot(this.buttons.get(this.buttonsHoveredIndex).getLinkedSlot(), 0);
        }
    }

    private void clickSlot(int slotId, int button) {
        if (RadialMenuScreen.CLIENT.field_1761 == null) {
            return;
        }
        RadialMenuScreen.CLIENT.field_1761.method_2906(this.handler.field_7763, slotId + this.menuType.clickSlotOffset(slotId), this.menuType.remapClickSlotButton(button, slotId + this.menuType.clickSlotOffset(slotId)), class_1713.field_7790, (class_1657)RadialMenuScreen.CLIENT.field_1724);
    }

    public void method_7635(class_1703 handler, int slotId, class_1799 stack) {
        if (this.handler == null || slotId >= this.handler.method_17388() * 9) {
            return;
        }
        if (this.menuType.itemMatches(slotId, stack)) {
            this.options.put(slotId, (Object)stack);
            this.method_25426();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        class_2561 class_25612 = this.method_25440();
        int n = this.field_22789 / 2;
        int n2 = this.field_22790 / 2;
        Objects.requireNonNull(this.field_22793);
        context.method_27534(this.field_22793, class_25612, n, n2 - 9, -1);
        int textWidth = this.field_22793.method_27525((class_5348)this.method_25440());
        context.method_51738(this.field_22789 / 2 - textWidth / 2, this.field_22789 / 2 + textWidth / 2, this.field_22790 / 2, -1);
        if (this.buttonsHoveredIndex != -1 && this.buttonsHoveredIndex < this.buttons.size()) {
            context.method_25300(this.field_22793, this.buttons.get(this.buttonsHoveredIndex).getName(), this.field_22789 / 2, this.field_22790 / 2 + 2, -1);
        }
    }

    public void method_7633(class_1703 handler, int property, int value) {
    }

    public void method_25419() {
        if (RadialMenuScreen.CLIENT.field_1724 != null) {
            RadialMenuScreen.CLIENT.field_1724.method_7346();
        }
        super.method_25419();
    }
}

