/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.searchoverlay;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.searchoverlay.SearchOverManager;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7845;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class OverlayScreen
extends class_437 {
    protected static final class_2960 SEARCH_ICON_TEXTURE = class_2960.method_60656((String)"icon/search");
    protected static final class_2960 DELETE_ICON_TEXTURE = class_2960.method_60656((String)"textures/gui/sprites/pending_invite/reject.png");
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60656((String)"social_interactions/background");
    private static final int rowHeight = 20;
    private static final int specialButtonSize = 20;
    private class_342 searchField;
    private class_4185 finishedButton;
    private class_4185 maxPetButton;
    private class_4185 dungeonStarButton;
    private class_4185[] suggestionButtons;
    private class_4185[] historyButtons;
    private class_4185[] deleteButtons;

    public OverlayScreen() {
        super((class_2561)class_2561.method_43473());
    }

    protected void method_25426() {
        super.method_25426();
        int rowWidth = (int)((double)this.field_22789 * 0.4);
        int startX = (int)((double)this.field_22789 * 0.5) - rowWidth / 2;
        int startY = (int)((double)((int)((double)this.field_22790 * 0.5)) - 20.0 * ((double)(1 + SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.maxSuggestions) + 0.75 + (double)SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.historyLength) / 2.0);
        this.searchField = new class_342(this.field_22793, startX, startY, rowWidth - 20, 20, (class_2561)class_2561.method_43471((String)"gui.recipebook.search_hint"));
        this.searchField.method_1852(SearchOverManager.search);
        this.searchField.method_1863(SearchOverManager::updateSearch);
        this.searchField.method_1880(30);
        this.finishedButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), a -> this.method_25419()).method_46433(startX + rowWidth - 20, startY).method_46437(20, 20).method_46431();
        int totalSuggestions = SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.maxSuggestions;
        this.suggestionButtons = new class_4185[totalSuggestions];
        class_8667 suggestionLayoutWidget = new class_8667(startX, startY + 20, class_8667.class_8668.field_45404);
        for (int i = 0; i < totalSuggestions; ++i) {
            this.suggestionButtons[i] = class_4185.method_46430((class_2561)class_2561.method_43473(), a -> {
                SearchOverManager.updateSearch(a.method_25369().getString());
                this.method_25419();
            }).method_46437(rowWidth, 20).method_46431();
            suggestionLayoutWidget.method_52736((class_8021)this.suggestionButtons[i]);
            this.suggestionButtons[i].field_22764 = false;
        }
        int historyOffset = (int)(20.0 * ((double)totalSuggestions + 1.75));
        int historyLength = SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.historyLength;
        this.historyButtons = new class_4185[historyLength];
        this.deleteButtons = new class_4185[historyLength];
        class_7845 historyGridWidget = new class_7845(startX, startY + historyOffset);
        class_7845.class_7939 historyAdder = historyGridWidget.method_47610(2);
        for (int i = 0; i < historyLength; ++i) {
            this.historyButtons[i] = class_4185.method_46430((class_2561)class_2561.method_43473(), a -> {
                SearchOverManager.search = a.method_25369().getString();
                SearchOverManager.updateSearch(a.method_25369().getString());
                this.method_25419();
            }).method_46437(rowWidth - 20, 20).method_46431();
            this.historyButtons[i].field_22764 = false;
            historyAdder.method_47612((class_8021)this.historyButtons[i]);
            int slotId = i;
            this.deleteButtons[i] = class_4185.method_46430((class_2561)class_2561.method_43473(), a -> this.removeHistoryItem(slotId)).method_46437(20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.general.searchOverlay.deleteTooltip"))).method_46431();
            this.deleteButtons[i].field_22764 = false;
            historyAdder.method_47612((class_8021)this.deleteButtons[i]);
        }
        this.updateHistoryButtons();
        if (SearchOverManager.location == SearchOverManager.SearchLocation.AUCTION) {
            this.maxPetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), a -> {
                SearchOverManager.maxPetLevel = SearchOverManager.maxPetLevel == false;
                this.updateMaxPetText();
            }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.general.searchOverlay.maxPet.@Tooltip"))).method_46433(startX, startY - 20 - 8).method_46437(rowWidth / 2, 20).method_46431();
            this.updateMaxPetText();
            this.dungeonStarButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u272a"), a -> this.updateStars()).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.general.searchOverlay.starsTooltip"))).method_46433(startX + (int)((double)rowWidth * 0.5), startY - 20 - 8).method_46437(rowWidth / 2, 20).method_46431();
            this.updateStars();
        }
        suggestionLayoutWidget.method_48222();
        historyGridWidget.method_48222();
        this.method_37063((class_364)this.searchField);
        suggestionLayoutWidget.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        historyGridWidget.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.method_37063((class_364)this.finishedButton);
        if (SearchOverManager.location == SearchOverManager.SearchLocation.AUCTION) {
            this.method_37063((class_364)this.maxPetButton);
            this.method_37063((class_364)this.dungeonStarButton);
        }
        this.method_48265((class_364)this.searchField);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (this.dungeonStarButton != null && this.dungeonStarButton.method_49606()) {
            double actualTextWidth = this.field_22787.field_1772.method_27525((class_5348)this.dungeonStarButton.method_25369());
            double textOffset = ((double)this.dungeonStarButton.method_25368() - actualTextWidth) / 2.0;
            double offset = click.comp_4798() - ((double)this.dungeonStarButton.method_46426() + textOffset);
            int starCount = (int)(offset / actualTextWidth * 10.0);
            SearchOverManager.dungeonStars = (starCount = Math.clamp((long)(starCount + 1), 0, 10)) == SearchOverManager.dungeonStars ? 0 : starCount;
        }
        return super.method_25402(click, doubled);
    }

    private void updateMaxPetText() {
        if (SearchOverManager.maxPetLevel.booleanValue()) {
            this.maxPetButton.method_25355((class_2561)class_2561.method_43471((String)"skyblocker.config.general.searchOverlay.maxPet").method_10852((class_2561)class_2561.method_43470((String)" \u2714")).method_27692(class_124.field_1060));
        } else {
            this.maxPetButton.method_25355((class_2561)class_2561.method_43471((String)"skyblocker.config.general.searchOverlay.maxPet").method_10852((class_2561)class_2561.method_43470((String)" \u274c")).method_27692(class_124.field_1061));
        }
    }

    private void updateStars() {
        int i;
        class_5250 stars = class_2561.method_43473();
        for (i = 0; i < SearchOverManager.dungeonStars; ++i) {
            stars.method_10852((class_2561)class_2561.method_43470((String)"\u272a").method_27692(i < 5 ? class_124.field_1054 : class_124.field_1061));
        }
        for (i = SearchOverManager.dungeonStars; i < 10; ++i) {
            stars.method_10852((class_2561)class_2561.method_43470((String)"\u272a"));
        }
        this.dungeonStarButton.method_25355((class_2561)stars);
    }

    private void removeHistoryItem(int slotId) {
        SearchOverManager.removeHistoryItem(slotId);
        this.updateHistoryButtons();
    }

    private void updateHistoryButtons() {
        int historyLength = SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.historyLength;
        for (int i = 0; i < historyLength; ++i) {
            String text = SearchOverManager.getHistory(i);
            if (text.isEmpty()) {
                this.historyButtons[i].field_22764 = false;
                this.deleteButtons[i].field_22764 = false;
                continue;
            }
            this.historyButtons[i].method_25355((class_2561)class_2561.method_43470((String)text));
            this.historyButtons[i].field_22764 = true;
            this.deleteButtons[i].field_22764 = true;
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        int maxHeight = 20 * (1 + this.suggestionButtons.length + this.historyButtons.length);
        if (this.historyButtons.length > 0) {
            maxHeight += 15;
        }
        context.method_52706(class_10799.field_56883, BACKGROUND_TEXTURE, this.searchField.method_46426() - 8, this.searchField.method_46427() - 8, (int)((double)this.field_22789 * 0.4) + 16, maxHeight + 16);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int i;
        super.method_25394(context, mouseX, mouseY, delta);
        int renderOffset = 2;
        context.method_52706(class_10799.field_56883, SEARCH_ICON_TEXTURE, this.finishedButton.method_46426() + renderOffset, this.finishedButton.method_46427() + renderOffset, 16, 16);
        if (this.historyButtons.length > 0 && this.historyButtons[0] != null) {
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"skyblocker.config.general.searchOverlay.historyLabel"), this.historyButtons[0].method_46426() + renderOffset, this.historyButtons[0].method_46427() - 10, -1, true);
        }
        for (i = 0; i < this.suggestionButtons.length; ++i) {
            this.drawItemAndTooltip(context, mouseX, mouseY, SearchOverManager.getSuggestionId(i), this.suggestionButtons[i], renderOffset);
        }
        for (i = 0; i < this.historyButtons.length; ++i) {
            this.drawItemAndTooltip(context, mouseX, mouseY, SearchOverManager.getHistoryId(i), this.historyButtons[i], renderOffset);
        }
        for (class_4185 deleteButton : this.deleteButtons) {
            if (!deleteButton.field_22764) break;
            context.method_25290(class_10799.field_56883, DELETE_ICON_TEXTURE, deleteButton.method_46426() + renderOffset, deleteButton.method_46427() + renderOffset, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    private void drawItemAndTooltip(class_332 context, int mouseX, int mouseY, String id, class_4185 button, int renderOffset) {
        if (id.isEmpty()) {
            return;
        }
        class_1799 item = ItemRepository.getItemStack(id);
        if (item == null) {
            return;
        }
        context.method_51427(item, button.method_46426() + renderOffset, button.method_46427() + renderOffset);
        if (button.method_25405((double)mouseX, (double)mouseY)) {
            context.method_51446(this.field_22793, item, mouseX, mouseY);
        }
    }

    public final void method_25393() {
        super.method_25393();
        for (int i = 0; i < SkyblockerConfigManager.get().uiAndVisuals.searchOverlay.maxSuggestions; ++i) {
            String text = SearchOverManager.getSuggestion(i);
            if (!text.isEmpty()) {
                boolean isNewText;
                this.suggestionButtons[i].field_22764 = true;
                boolean bl = isNewText = !text.equals(this.suggestionButtons[i].method_25369().getString());
                if (!isNewText) continue;
                this.suggestionButtons[i].method_25355((class_2561)class_2561.method_43470((String)text));
                continue;
            }
            this.suggestionButtons[i].field_22764 = false;
        }
    }

    public boolean method_25404(class_11908 input) {
        if (input.method_74230() && this.searchField.method_20315()) {
            this.method_25419();
            return true;
        }
        if (input.method_74231()) {
            SearchOverManager.search = "";
            this.method_25419();
            return true;
        }
        return super.method_25404(input);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        assert (this.field_22787.field_1724 != null);
        SearchOverManager.pushSearch();
        super.method_25419();
    }
}

