/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.slayers;

import de.hysky.skyblocker.skyblock.slayers.SlayerManager;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1259;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_345;
import org.jspecify.annotations.Nullable;

public class SlayerBossBar {
    private static final Pattern HEALTH_PATTERN = Pattern.compile("(\\d{1,3}(?:,\\d{3})*(?:\\.\\d+)?[kM]?)(?=\u2764)");
    private static int bossMaxHealth = -1;
    private static @Nullable class_345 bossBar;

    public static boolean shouldRenderBossBar() {
        String bossName;
        Matcher maxHealthMatcher;
        SlayerManager.BossFight bossFight;
        if (!SlayerManager.isFightingSlayer()) {
            bossBar = null;
            bossMaxHealth = -1;
            return false;
        }
        if (bossMaxHealth == -1 && (bossFight = SlayerManager.getBossFight()) != null && (maxHealthMatcher = HEALTH_PATTERN.matcher(bossName = bossFight.armorStand.method_5477().getString())).find()) {
            int currentHealth = SlayerBossBar.convertToInt(maxHealthMatcher.group(0));
            int maxHealth = bossFight.slayerType.getHealth(bossName, bossFight.slayerTier);
            bossMaxHealth = Math.max(maxHealth, currentHealth);
        }
        return true;
    }

    public static class_345 updateBossBar() {
        Matcher healthMatcher;
        class_1531 slayerArmorStand = SlayerManager.getSlayerArmorStand();
        assert (slayerArmorStand != null);
        class_2561 name = slayerArmorStand.method_5477();
        if (bossBar == null) {
            bossBar = new class_345(UUID.randomUUID(), name, 1.0f, class_1259.class_1260.field_5783, class_1259.class_1261.field_5795, false, false, false);
        }
        if ((healthMatcher = HEALTH_PATTERN.matcher(name.getString())).find()) {
            int health = SlayerBossBar.convertToInt(healthMatcher.group(1));
            if (health > bossMaxHealth) {
                bossMaxHealth = health;
            }
            bossBar.method_5408(bossMaxHealth < 1 ? 1.0f : (float)health / (float)bossMaxHealth);
            bossBar.method_5416(class_1259.class_1260.field_5788);
            bossBar.method_5413(name);
            bossBar.method_5409(class_1259.class_1261.field_5791);
        } else {
            bossBar.method_5416(class_1259.class_1260.field_5784);
            bossBar.method_5409(class_1259.class_1261.field_5795);
            bossBar.method_5413(name);
        }
        return bossBar;
    }

    private static int convertToInt(@Nullable String value) {
        int multiplier;
        if (value == null || value.isEmpty()) {
            return 0;
        }
        int n = (value = value.replace(",", "").trim().toLowerCase(Locale.ENGLISH)).endsWith("m") ? 1000000 : (multiplier = value.endsWith("k") ? 1000 : 1);
        if (multiplier > 1) {
            value = value.substring(0, value.length() - 1);
        }
        try {
            double numericValue = Double.parseDouble(value);
            return (int)(numericValue * (double)multiplier);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

