/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.slayers;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.slayers.SlayerManager;
import de.hysky.skyblocker.skyblock.slayers.SlayerTier;
import de.hysky.skyblocker.skyblock.slayers.SlayerType;
import de.hysky.skyblocker.skyblock.tabhud.config.WidgetsConfigurationScreen;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.skyblock.tabhud.widget.ComponentBasedWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.Components;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.TextureTextComponent;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.Location;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

@RegisterWidget
public class SlayerHudWidget
extends ComponentBasedWidget {
    private static final Set<Location> AVAILABLE_LOCATIONS = Set.of(Location.CRIMSON_ISLE, Location.HUB, Location.SPIDERS_DEN, Location.THE_END, Location.THE_PARK, Location.THE_RIFT);
    private static final class_310 CLIENT = class_310.method_1551();
    private static final int TEXTURE_SIZE = 16;
    private static SlayerHudWidget instance;

    public SlayerHudWidget() {
        super(class_2561.method_43470((String)"Slayer").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}), class_124.field_1064.method_532(), "hud_slayer");
        instance = this;
        this.update();
    }

    @Override
    public boolean shouldUpdateBeforeRendering() {
        return true;
    }

    public static SlayerHudWidget getInstance() {
        return instance;
    }

    @Override
    public Set<Location> availableLocations() {
        return AVAILABLE_LOCATIONS;
    }

    @Override
    public void setEnabledIn(Location location, boolean enabled) {
        if (!this.availableLocations().contains((Object)location)) {
            return;
        }
        SkyblockerConfigManager.get().slayers.enableHud = enabled;
    }

    @Override
    public boolean isEnabledIn(Location location) {
        return this.availableLocations().contains((Object)location) && SkyblockerConfigManager.get().slayers.enableHud;
    }

    @Override
    public boolean shouldRender(Location location) {
        return super.shouldRender(location) && SlayerManager.isInSlayerQuest();
    }

    @Override
    public void updateContent() {
        if (SlayerHudWidget.CLIENT.field_1755 instanceof WidgetsConfigurationScreen) {
            SlayerType slayerType = SlayerType.REVENANT;
            SlayerTier slayerTier = SlayerTier.V;
            class_5250 slayerName = class_2561.method_43470((String)(slayerType.bossName + " " + String.valueOf((Object)slayerTier))).method_27692(slayerTier.color);
            this.addComponent(new TextureTextComponent((class_2561)slayerName, slayerType.texture, 16, 16));
            this.addSimpleIcoText(Ico.EXPERIENCE_BOTTLE, "XP: ", class_124.field_1076, "100,000/400,000");
            this.addComponent(Components.iconTextComponent(Ico.NETHER_STAR, (class_2561)class_2561.method_43469((String)"skyblocker.slayer.hud.levelUpIn", (Object[])new Object[]{class_2561.method_43470((String)"200").method_27692(class_124.field_1076)})));
            return;
        }
        SlayerManager.SlayerQuest slayerQuest = SlayerManager.getSlayerQuest();
        if (SlayerHudWidget.CLIENT.field_1724 == null || slayerQuest == null) {
            return;
        }
        SlayerType slayerType = slayerQuest.slayerType;
        SlayerTier slayerTier = slayerQuest.slayerTier;
        int level = slayerQuest.level;
        int bossesNeeded = slayerQuest.bossesNeeded;
        class_5250 slayerName = class_2561.method_43470((String)(slayerType.bossName + " " + String.valueOf((Object)slayerTier))).method_27692(slayerTier.color);
        this.addComponent(new TextureTextComponent((class_2561)slayerName, slayerType.texture, 16, 16));
        if (level == slayerType.maxLevel) {
            this.addComponent(Components.iconTextComponent(Ico.EXPERIENCE_BOTTLE, (class_2561)class_2561.method_43470((String)"XP: ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.slayer.hud.levelMaxed").method_27692(class_124.field_1060))));
        } else if (level >= 0) {
            int nextMilestone = slayerType.levelMilestones[level];
            int currentXP = nextMilestone - slayerQuest.xpRemaining;
            this.addSimpleIcoText(Ico.EXPERIENCE_BOTTLE, "XP: ", class_124.field_1076, Formatters.INTEGER_NUMBERS.format(currentXP) + "/" + Formatters.INTEGER_NUMBERS.format(nextMilestone));
            if (bossesNeeded > 0) {
                this.addComponent(Components.iconTextComponent(Ico.NETHER_STAR, (class_2561)class_2561.method_43469((String)"skyblocker.slayer.hud.levelUpIn", (Object[])new Object[]{class_2561.method_43470((String)Formatters.INTEGER_NUMBERS.format(bossesNeeded)).method_27692(class_124.field_1076)})));
            }
        }
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43470((String)"Slayer Hud");
    }
}

