/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.slayers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.SlayersConfig;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.skyblock.slayers.SlayerTier;
import de.hysky.skyblocker.skyblock.slayers.SlayerType;
import de.hysky.skyblocker.skyblock.slayers.boss.vampire.ManiaIndicator;
import de.hysky.skyblocker.skyblock.slayers.boss.vampire.StakeIndicator;
import de.hysky.skyblocker.skyblock.slayers.boss.vampire.TwinClawsIndicator;
import de.hysky.skyblocker.skyblock.slayers.features.CallMaddox;
import de.hysky.skyblocker.skyblock.slayers.features.SlayerTimer;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.ProfiledData;
import de.hysky.skyblocker.utils.mayor.MayorUtils;
import de.hysky.skyblocker.utils.render.title.Title;
import de.hysky.skyblocker.utils.render.title.TitleContainer;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import org.jspecify.annotations.Nullable;

public class SlayerManager {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Pattern SLAYER_PATTERN = Pattern.compile("\\b(Revenant Horror|Atoned Horror|Tarantula Broodfather|Conjoined Brood|Sven Packmaster|Voidgloom Seraph|Inferno Demonlord|Riftstalker Bloodfiend|Bloodfiend)(?:\\s+(V|IV|III|II|I))?\\b");
    private static final Pattern XP_NEEDED_PATTERN = Pattern.compile("\\s*(Wolf|Zombie|Spider|Enderman|Blaze|Vampire) Slayer LVL ([0-9]) - (?:Next LVL in ([\\d,]+) XP!|LVL MAXED OUT!)\\s*");
    private static final Pattern LVL_UP_PATTERN = Pattern.compile("\\s*LVL UP! \u279c (Wolf|Zombie|Spider|Enderman|Blaze|Vampire) Slayer LVL [1-9]\\s*");
    private static final Title BOSS_SPAWN = new Title(class_2561.method_43471((String)"skyblocker.slayer.bossSpawnAlert").method_27692(class_124.field_1061));
    private static final Title MINIBOSS_SPAWN = new Title(class_2561.method_43471((String)"skyblocker.slayer.miniBossSpawnAlert").method_27692(class_124.field_1061));
    private static final Path FILE = SkyblockerMod.CONFIG_DIR.resolve("slayers_data.json");
    private static final ProfiledData<Object2ObjectOpenHashMap<SlayerType, SlayerInfo>> SLAYERS_DATA = new ProfiledData<Object2ObjectOpenHashMap<SlayerType, SlayerInfo>>(FILE, SlayerInfo.CODEC);
    private static final Set<class_1297> ENTITIES_CACHE = Collections.newSetFromMap(new WeakHashMap());
    private static @Nullable SlayerQuest slayerQuest;
    private static @Nullable BossFight bossFight;
    private static float slayerExpBuff;

    @Init
    public static void init() {
        SLAYERS_DATA.load();
        ClientReceiveMessageEvents.ALLOW_GAME.register(SlayerManager::onChatMessage);
        SkyblockEvents.MAYOR_CHANGE.register(SlayerManager::onMayorChange);
        SkyblockEvents.PROFILE_CHANGE.register((_prev, _profile) -> {
            slayerQuest = null;
        });
        ClientPlayConnectionEvents.JOIN.register((_c, _p, _m) -> {
            bossFight = null;
        });
        AttackEntityCallback.EVENT.register(SlayerManager::onEntityAttack);
        Scheduler.INSTANCE.scheduleCyclic(TwinClawsIndicator::updateIce, SkyblockerConfigManager.get().slayers.vampireSlayer.holyIceUpdateFrequency);
        Scheduler.INSTANCE.scheduleCyclic(ManiaIndicator::updateMania, SkyblockerConfigManager.get().slayers.vampireSlayer.maniaUpdateFrequency);
        Scheduler.INSTANCE.scheduleCyclic(StakeIndicator::updateStake, SkyblockerConfigManager.get().slayers.vampireSlayer.steakStakeUpdateFrequency);
    }

    private static void onMayorChange() {
        slayerExpBuff = 1.0f;
        if (MayorUtils.getActivePerks().contains("Work Smarter")) {
            slayerExpBuff *= 1.5f;
        }
        if (MayorUtils.getActivePerks().contains("Slayer XP Buff")) {
            slayerExpBuff *= 1.25f;
        }
    }

    private static boolean onChatMessage(class_2561 text, boolean overlay) {
        if (overlay || !Utils.isOnSkyblock()) {
            return true;
        }
        String message = text.getString();
        String string = message.stripLeading();
        Objects.requireNonNull(string);
        String string2 = string;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"Your Slayer Quest has been cancelled!", "SLAYER QUEST FAILED!", "SLAYER QUEST STARTED!", "NICE! SLAYER BOSS SLAIN!", "SLAYER QUEST COMPLETE!", String.class}, (Object)string2, n)) {
                case 0: 
                case 1: {
                    slayerQuest = null;
                    CallMaddox.onSlayerFailed();
                    return true;
                }
                case 2: {
                    return true;
                }
                case 3: 
                case 4: {
                    if (slayerQuest != null) {
                        SlayerTimer.sendMessage();
                        CallMaddox.onBossKilled();
                    }
                    return true;
                }
                case 5: {
                    String s = string2;
                    if (!s.startsWith("SLAYER MINI-BOSS")) {
                        n = 6;
                        continue block6;
                    }
                    if (!SkyblockerConfigManager.get().slayers.miniBossSpawnAlert || SkyblockerConfigManager.get().slayers.alertOtherMinibosses) break block6;
                    TitleContainer.addTitleAndPlaySound(MINIBOSS_SPAWN, 20);
                    break block6;
                }
            }
            break;
        }
        if (slayerQuest != null) {
            Matcher matcherNextLvl = XP_NEEDED_PATTERN.matcher(message);
            if (matcherNextLvl.matches()) {
                if (message.contains("LVL MAXED OUT")) {
                    level = message.contains("Vampire") ? 5 : 9;
                    slayerQuest.update(level, -1, true);
                } else {
                    String xpRemainingStr = matcherNextLvl.group(3);
                    if (xpRemainingStr != null) {
                        int level = Integer.parseInt(matcherNextLvl.group(2));
                        int xpRemaining = Integer.parseInt(xpRemainingStr.replace(",", "").trim());
                        slayerQuest.update(level, xpRemaining, true);
                    }
                }
            } else if (LVL_UP_PATTERN.matcher(message).matches()) {
                level = Integer.parseInt(message.replaceAll("(\\d+).+", "$1"));
                slayerQuest.update(level, -1, true);
            }
        }
        return true;
    }

    private static class_1269 onEntityAttack(class_1657 player, class_1937 level, class_1268 interactionHand, class_1297 entity, @Nullable class_3966 entityHitResult) {
        if (ENTITIES_CACHE.contains(entity)) {
            return class_1269.field_5811;
        }
        ENTITIES_CACHE.add(entity);
        if (Arrays.stream(SlayerType.values()).noneMatch(slayer -> slayer.mobType == entity.method_5864())) {
            return class_1269.field_5811;
        }
        BossFight boss = SlayerManager.findBoss(entity);
        if (boss != null && (!SlayerManager.isSlayerArmorStandAlive() || boss.playerBoss && bossFight != null && SlayerManager.bossFight.armorStand != boss.armorStand)) {
            bossFight = boss;
            ENTITIES_CACHE.clear();
            ENTITIES_CACHE.add(entity);
        }
        return class_1269.field_5811;
    }

    public static void checkSlayerQuest() {
        boolean active = false;
        boolean bossSpawned = false;
        for (String line : Utils.STRING_SCOREBOARD) {
            Matcher matcher = SLAYER_PATTERN.matcher(line);
            if (matcher.find()) {
                String bossName = matcher.group(1);
                String bossTier = matcher.group(2);
                if (slayerQuest == null || !bossName.equals(SlayerManager.slayerQuest.slayerType.bossName) || !bossTier.equals(SlayerManager.slayerQuest.slayerTier.name())) {
                    SlayerType slayerType = SlayerType.fromBossName(bossName);
                    assert (slayerType != null);
                    slayerQuest = new SlayerQuest(slayerType, SlayerTier.valueOf(bossTier));
                }
                active = true;
                continue;
            }
            if (!line.equals("Slay the boss!")) continue;
            bossSpawned = true;
        }
        if (slayerQuest != null) {
            SlayerManager.slayerQuest.active = active;
            if (active && bossSpawned) {
                slayerQuest.onBossSpawn();
            }
            SlayerManager.slayerQuest.bossSpawned = bossSpawned;
        }
    }

    public static void checkSlayerBoss(class_1531 armorStand) {
        if (!armorStand.method_16914() || !SlayerManager.isInSlayerQuest() || SlayerManager.isSlayerArmorStandAlive()) {
            return;
        }
        String entityName = armorStand.method_5477().getString();
        BossFight boss = SlayerManager.findBoss((class_1297)armorStand);
        if (boss != null) {
            bossFight = boss;
            slayerQuest.onBossSpawn();
            if (!SlayerManager.slayerQuest.sentBossAlert) {
                BossFight.alert();
                SlayerManager.slayerQuest.sentBossAlert = true;
            }
            return;
        }
        assert (SlayerManager.CLIENT.field_1724 != null);
        if (armorStand.method_24516((class_1297)SlayerManager.CLIENT.field_1724, 15.0) && SlayerManager.slayerQuest.slayerType.isMiniboss(entityName, SlayerManager.slayerQuest.slayerTier)) {
            slayerQuest.onMinibossSpawn(armorStand);
        }
    }

    private static @Nullable BossFight findBoss(class_1297 entity) {
        class_1297 boss;
        String username = CLIENT.method_1548().method_1676();
        class_1531 bossStand = null;
        SlayerType slayerType = null;
        SlayerTier slayerTier = null;
        boolean playerBoss = false;
        if (entity instanceof class_1531) {
            boolean isBossStand;
            class_1531 armorStand = (class_1531)entity;
            String entityName = armorStand.method_5477().getString();
            Matcher entityMatcher = SLAYER_PATTERN.matcher(entityName);
            boolean isPlayerStand = entityName.contains(username);
            boolean bl = isBossStand = entityMatcher.find() && SlayerManager.isValidBossArmorStand(armorStand);
            if (!isBossStand && !isPlayerStand) {
                return null;
            }
            for (class_1531 stand : SlayerManager.getEntityArmorStands(entity, 1.5f)) {
                Matcher matcher;
                String standName = stand.method_5477().getString();
                if (isBossStand && standName.contains(username)) {
                    String bossName = entityMatcher.group(1);
                    slayerType = SlayerType.fromBossName(bossName);
                    slayerTier = SlayerTier.valueOf(entityMatcher.group(2), bossName);
                    bossStand = armorStand;
                    playerBoss = true;
                    break;
                }
                if (!isPlayerStand || !(matcher = SLAYER_PATTERN.matcher(standName)).find() || !SlayerManager.isValidBossArmorStand(stand)) continue;
                String bossName = matcher.group(1);
                slayerType = SlayerType.fromBossName(bossName);
                slayerTier = SlayerTier.valueOf(matcher.group(2), bossName);
                bossStand = stand;
                playerBoss = true;
                break;
            }
            boss = slayerType != null ? SlayerManager.findClosestMobEntity(slayerType.mobType, armorStand) : null;
        } else {
            boss = entity;
            for (class_1531 stand : SlayerManager.getEntityArmorStands(entity, 1.5f)) {
                String standName = stand.method_5477().getString();
                Matcher matcher = SLAYER_PATTERN.matcher(standName);
                if (matcher.find() && SlayerManager.isValidBossArmorStand(stand)) {
                    bossStand = stand;
                    String bossName = matcher.group(1);
                    slayerType = SlayerType.fromBossName(bossName);
                    slayerTier = SlayerTier.valueOf(matcher.group(2), bossName);
                    continue;
                }
                if (!standName.contains(username)) continue;
                playerBoss = true;
            }
        }
        return bossStand != null && boss != null && slayerType != null ? new BossFight(bossStand, boss, playerBoss, slayerType, slayerTier) : null;
    }

    public static List<class_1531> getEntityArmorStands(class_1297 entity, float expandY) {
        return entity.method_73183().method_8333(entity, entity.method_5829().method_1009((double)0.1f, (double)expandY, (double)0.1f), x -> x instanceof class_1531 && x.method_16914()).stream().map(e -> (class_1531)e).toList();
    }

    private static <T extends class_1297> @Nullable T findClosestMobEntity(class_1299<T> entityType, class_1531 armorStand) {
        List mobEntities = armorStand.method_73183().method_18023(entityType, armorStand.method_5829().method_1009(0.0, 1.5, 0.0), class_1297::method_5805);
        mobEntities.sort(Comparator.comparingDouble(arg_0 -> ((class_1531)armorStand).method_5858(arg_0)));
        return (T)(switch (mobEntities.size()) {
            case 0 -> null;
            case 1 -> (class_1297)mobEntities.getFirst();
            default -> mobEntities.stream().min(Comparator.comparingInt(entity -> Math.abs(entity.field_6012 - armorStand.field_6012))).get();
        });
    }

    public static boolean shouldGlow(class_1297 entity, SlayersConfig.HighlightSlayerEntities highlightType) {
        if (SkyblockerConfigManager.get().slayers.highlightMinis == highlightType && SlayerManager.isInSlayerQuest() && SlayerManager.slayerQuest.minibosses.contains(entity)) {
            return true;
        }
        return SkyblockerConfigManager.get().slayers.highlightBosses == highlightType && SlayerManager.isSelectedBoss(entity.method_5667());
    }

    public static @Nullable SlayerQuest getSlayerQuest() {
        return slayerQuest;
    }

    public static @Nullable BossFight getBossFight() {
        return bossFight;
    }

    public static boolean isInSlayerQuest() {
        return slayerQuest != null && SlayerManager.slayerQuest.active;
    }

    public static boolean isFightingSlayer() {
        return bossFight != null && SlayerManager.bossFight.boss.method_5805();
    }

    public static boolean isFightingOwnedSlayer() {
        return SlayerManager.isFightingSlayer() && SlayerManager.bossFight.playerBoss;
    }

    public static boolean isFightingSlayerType(SlayerType slayerType) {
        return bossFight != null && SlayerManager.bossFight.slayerType.equals((Object)slayerType);
    }

    public static boolean isSelectedBoss(UUID uuid) {
        return bossFight != null && SlayerManager.bossFight.boss.method_5667().equals(uuid);
    }

    public static @Nullable class_1531 getSlayerArmorStand() {
        return SlayerManager.isFightingSlayer() ? SlayerManager.bossFight.armorStand : null;
    }

    public static boolean isSlayerArmorStandAlive() {
        return SlayerManager.isFightingOwnedSlayer() && SlayerManager.isValidBossArmorStand(SlayerManager.bossFight.armorStand);
    }

    public static boolean isValidBossArmorStand(class_1531 armorStandEntity) {
        return armorStandEntity.method_5805() && !armorStandEntity.method_5477().getString().endsWith(" 0\u2764");
    }

    static {
        slayerExpBuff = 1.0f;
    }

    public static class SlayerQuest {
        public final SlayerType slayerType;
        public final SlayerTier slayerTier;
        public final List<class_1531> minibossesArmorStand = new ArrayList<class_1531>();
        public final List<class_1297> minibosses = new ArrayList<class_1297>();
        public boolean active = true;
        public int level;
        public int xpRemaining;
        public int bossesNeeded;
        public @Nullable Instant bossSpawnTime;
        public @Nullable Instant bossDeathTime;
        public boolean bossSpawned;
        public boolean sentBossAlert;

        private SlayerQuest(SlayerType slayerType, SlayerTier slayerTier) {
            this.slayerType = slayerType;
            this.slayerTier = slayerTier;
            Object2ObjectOpenHashMap<SlayerType, SlayerInfo> slayersData = SLAYERS_DATA.get();
            if (slayersData != null && slayersData.containsKey((Object)slayerType)) {
                SlayerInfo slayerInfo = (SlayerInfo)slayersData.get((Object)slayerType);
                this.update(slayerInfo.level, slayerInfo.xpRemaining, false);
            } else {
                this.update(-1, -1, false);
            }
        }

        private void save() {
            Object2ObjectOpenHashMap slayers = SLAYERS_DATA.computeIfAbsent(Object2ObjectOpenHashMap::new);
            if (slayers != null) {
                slayers.put((Object)this.slayerType, (Object)new SlayerInfo(this.level, this.xpRemaining));
                SLAYERS_DATA.save();
            }
        }

        private void update(int level, int xpRemaining, boolean saveCache) {
            this.sentBossAlert = false;
            this.level = level;
            int n = this.xpRemaining = xpRemaining <= 0 && level != -1 && level < this.slayerType.maxLevel ? this.slayerType.levelMilestones[level + 1] - this.slayerType.levelMilestones[level] : xpRemaining;
            if (saveCache) {
                this.save();
            }
            if (this.xpRemaining <= 0) {
                this.bossesNeeded = -1;
            } else {
                int xpPerTier = (int)((float)this.slayerType.xpPerTier[this.slayerTier.ordinal()] * slayerExpBuff);
                this.bossesNeeded = (int)Math.ceil((double)this.xpRemaining / (double)xpPerTier);
            }
        }

        private void onBossSpawn() {
            if (!this.bossSpawned) {
                this.bossSpawnTime = Instant.now();
                this.bossDeathTime = null;
                this.bossSpawned = true;
            }
        }

        private void onMinibossSpawn(class_1531 armorStand) {
            if (this.minibossesArmorStand.contains(armorStand)) {
                return;
            }
            this.minibossesArmorStand.add(armorStand);
            class_1299<?> minibossType = this.slayerType.getMinibossType(armorStand.method_5477().getString());
            Object miniboss = SlayerManager.findClosestMobEntity(minibossType, armorStand);
            if (miniboss == null) {
                return;
            }
            this.minibosses.add((class_1297)miniboss);
            SlayersConfig slayersConfig = SkyblockerConfigManager.get().slayers;
            if (slayersConfig.miniBossSpawnAlert && slayersConfig.alertOtherMinibosses) {
                class_5250 armorStandName = (class_5250)armorStand.method_5797();
                Title title = slayersConfig.showMiniBossNameInAlert && armorStandName != null ? new Title(armorStandName) : MINIBOSS_SPAWN;
                TitleContainer.addTitleAndPlaySound(title, 20);
            }
        }
    }

    public static class BossFight {
        public final class_1531 armorStand;
        public final class_1297 boss;
        public final boolean playerBoss;
        public final SlayerType slayerType;
        public final SlayerTier slayerTier;

        private BossFight(class_1531 armorStand, class_1297 boss, boolean playerBoss, SlayerType slayerType, SlayerTier slayerTier) {
            this.armorStand = armorStand;
            this.boss = boss;
            this.playerBoss = playerBoss;
            this.slayerType = slayerType;
            this.slayerTier = slayerTier;
        }

        private static void alert() {
            if (SkyblockerConfigManager.get().slayers.bossSpawnAlert) {
                TitleContainer.addTitleAndPlaySound(BOSS_SPAWN, 20);
            }
        }

        public static void remove() {
            bossFight = null;
            ENTITIES_CACHE.clear();
        }
    }

    public record SlayerInfo(int level, int xpRemaining) {
        private static final Codec<SlayerInfo> SLAYER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("level").forGetter(SlayerInfo::level), (App)Codec.INT.fieldOf("xpRemaining").forGetter(SlayerInfo::xpRemaining)).apply((Applicative)instance, SlayerInfo::new));
        private static final Codec<Object2ObjectOpenHashMap<SlayerType, SlayerInfo>> CODEC = Codec.unboundedMap(SlayerType.CODEC, SLAYER_CODEC).xmap(Object2ObjectOpenHashMap::new, Function.identity());
    }
}

