/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.slayers;

import com.mojang.serialization.Codec;
import de.hysky.skyblocker.skyblock.profileviewer.slayers.SlayerWidget;
import de.hysky.skyblocker.skyblock.slayers.SlayerTier;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import org.jspecify.annotations.Nullable;

public enum SlayerType implements class_3542
{
    REVENANT("revenant", "Zombie", (class_1299<? extends class_1297>)class_1299.field_6051, "Revenant Horror", SlayerWidget.HEAD_ICON.get("Zombie"), SlayerWidget.DROP_ICON.get("Zombie"), new int[]{500, 20000, 400000, 1500000, 10000000}, new int[]{5, 25, 100, 500, 1500}, new int[]{5, 15, 200, 1000, 5000, 20000, 100000, 400000, 1000000}, List.of("Revenant Sycophant"), List.of("Revenant Champion", "Deformed Revenant"), List.of("Atoned Champion", "Atoned Revenant")),
    TARANTULA("tarantula", "Spider", (class_1299<? extends class_1297>)class_1299.field_6079, "Tarantula Broodfather", SlayerWidget.HEAD_ICON.get("Spider"), SlayerWidget.DROP_ICON.get("Spider"), new int[]{750, 30000, 900000, 2400000, 10000000}, new int[]{5, 25, 100, 500, 1500}, new int[]{5, 25, 200, 1000, 5000, 20000, 100000, 400000, 1000000}, List.of("Tarantula Vermin"), List.of("Tarantula Beast", "Mutant Tarantula"), List.of("Primordial Jockey", "Primordial Viscount")),
    SVEN("sven", "Wolf", (class_1299<? extends class_1297>)class_1299.field_6055, "Sven Packmaster", SlayerWidget.HEAD_ICON.get("Wolf"), SlayerWidget.DROP_ICON.get("Wolf"), new int[]{2000, 40000, 750000, 2000000}, new int[]{5, 25, 100, 500, 1500}, new int[]{10, 30, 250, 1500, 5000, 20000, 100000, 400000, 1000000}, List.of("Pack Enforcer"), List.of("Sven Follower", "Sven Alpha"), List.of()),
    VOIDGLOOM("voidgloom", "Enderman", (class_1299<? extends class_1297>)class_1299.field_6091, "Voidgloom Seraph", SlayerWidget.HEAD_ICON.get("Enderman"), SlayerWidget.DROP_ICON.get("Enderman"), new int[]{300000, 12000000, 50000000, 210000000}, new int[]{5, 25, 100, 500, 1500}, new int[]{10, 30, 250, 1500, 5000, 20000, 100000, 400000, 1000000}, List.of("Voidling Devotee"), List.of("Voidling Radical", "Voidcrazed Maniac"), List.of()),
    DEMONLORD("demonlord", "Blaze", (class_1299<? extends class_1297>)class_1299.field_6099, "Inferno Demonlord", SlayerWidget.HEAD_ICON.get("Blaze"), SlayerWidget.DROP_ICON.get("Blaze"), new int[]{2500000, 10000000, 45000000, 150000000}, new int[]{5, 25, 100, 500, 1500}, new int[]{10, 30, 250, 1500, 5000, 20000, 100000, 400000, 1000000}, List.of("Flare Demon"), List.of("Kindleheart Demon", "Burningsoul Demon"), List.of()),
    VAMPIRE("vampire", "Vampire", (class_1299<? extends class_1297>)class_1299.field_6097, "Riftstalker Bloodfiend", SlayerWidget.HEAD_ICON.get("Vampire"), SlayerWidget.DROP_ICON.get("Vampire"), new int[]{625, 1100, 1800, 2400, 3000}, new int[]{10, 25, 60, 120, 150}, new int[]{20, 75, 240, 840, 2400}, List.of(), List.of(), List.of());

    public static final Codec<SlayerType> CODEC;
    public final String name;
    public final String friendlyName;
    public final class_1299<? extends class_1297> mobType;
    public final String bossName;
    public final class_2960 texture;
    public final class_1799 dropIcon;
    private final int[] health;
    public final int maxLevel;
    public final int[] xpPerTier;
    public final int[] levelMilestones;
    private final List<String> t3Minibosses;
    private final List<String> t4Minibosses;
    private final List<String> t5Minibosses;

    private SlayerType(String name, String friendlyName, class_1299<? extends class_1297> mobType, String bossName, class_2960 texture, class_1799 dropIcon, int[] health, int[] xpPerTier, int[] levelMilestones, List<String> t3Minibosses, List<String> t4Minibosses, List<String> t5Minibosses) {
        this.name = name;
        this.friendlyName = friendlyName;
        this.mobType = mobType;
        this.bossName = bossName;
        this.texture = texture;
        this.dropIcon = dropIcon;
        this.health = health;
        this.maxLevel = levelMilestones.length;
        this.xpPerTier = xpPerTier;
        this.levelMilestones = levelMilestones;
        this.t3Minibosses = t3Minibosses;
        this.t4Minibosses = t4Minibosses;
        this.t5Minibosses = t5Minibosses;
    }

    public static @Nullable SlayerType fromBossName(String bossName) {
        return switch (bossName) {
            case "Revenant Horror", "Atoned Horror" -> REVENANT;
            case "Tarantula Broodfather", "Conjoined Brood" -> TARANTULA;
            case "Sven Packmaster" -> SVEN;
            case "Voidgloom Seraph" -> VOIDGLOOM;
            case "Inferno Demonlord" -> DEMONLORD;
            case "Riftstalker Bloodfiend", "Bloodfiend" -> VAMPIRE;
            default -> null;
        };
    }

    public boolean isMiniboss(String name, SlayerTier slayerTier) {
        List minibossLists = switch (slayerTier) {
            case SlayerTier.III -> List.of(this.t3Minibosses);
            case SlayerTier.IV -> List.of(this.t3Minibosses, this.t4Minibosses);
            case SlayerTier.V -> List.of(this.t3Minibosses, this.t4Minibosses, this.t5Minibosses);
            default -> List.of();
        };
        return minibossLists.stream().flatMap(Collection::stream).anyMatch(name::contains);
    }

    public class_1299<?> getMinibossType(String minibossName) {
        if (this == TARANTULA) {
            if (minibossName.contains("Primordial Jockey")) {
                return class_1299.field_6137;
            }
            if (minibossName.contains("Primordial Viscount")) {
                return class_1299.field_6084;
            }
        }
        return this.mobType;
    }

    public int getHealth(String bossName, SlayerTier slayerTier) {
        if (bossName.contains("Conjoined Brood")) {
            return 20000000;
        }
        return this.health[slayerTier.ordinal()];
    }

    public String method_15434() {
        return this.name;
    }

    static {
        CODEC = class_3542.method_28140(SlayerType::values);
    }
}

