/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.slayers.boss.demonlord;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.SlayersConfig;
import de.hysky.skyblocker.skyblock.slayers.SlayerManager;
import de.hysky.skyblocker.skyblock.slayers.SlayerType;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.title.Title;
import de.hysky.skyblocker.utils.render.title.TitleContainer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class FirePillarAnnouncer {
    private static final Pattern FIRE_PILLAR_PATTERN = Pattern.compile("(\\d+)s \\d+ hits");

    public static void checkFirePillar(class_1297 entity) {
        String entityName;
        Matcher matcher;
        if (SkyblockerConfigManager.get().slayers.blazeSlayer.firePillarCountdown == SlayersConfig.BlazeSlayer.FirePillar.OFF) {
            return;
        }
        if (Utils.isInCrimson() && SlayerManager.isFightingSlayerType(SlayerType.DEMONLORD) && (matcher = FIRE_PILLAR_PATTERN.matcher(entityName = entity.method_5477().getString())).matches()) {
            int seconds = Integer.parseInt(matcher.group(1));
            if (seconds > 5) {
                return;
            }
            class_1531 referenceEntity = SlayerManager.getSlayerArmorStand();
            if (!(referenceEntity != null ? referenceEntity : class_310.method_1551().field_1724).method_24515().method_19769((class_2374)entity.method_73189(), 22.0)) {
                return;
            }
            FirePillarAnnouncer.announceFirePillarDetails(entityName);
        }
    }

    private static void announceFirePillarDetails(String entityName) {
        Title title = new Title(class_2561.method_43470((String)entityName).method_27695(new class_124[]{class_124.field_1067, class_124.field_1064}));
        if (SkyblockerConfigManager.get().slayers.blazeSlayer.firePillarCountdown == SlayersConfig.BlazeSlayer.FirePillar.SOUND_AND_VISUAL) {
            TitleContainer.addTitleAndPlaySound(title, 15);
        } else {
            TitleContainer.addTitle(title, 15);
        }
    }
}

