/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.slayers.boss.voidgloom;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.WorldEvents;
import de.hysky.skyblocker.skyblock.slayers.SlayerManager;
import de.hysky.skyblocker.skyblock.slayers.SlayerType;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5250;

public class BeaconHighlighter {
    private static final Object2LongOpenHashMap<class_2338> BEACONS = new Object2LongOpenHashMap();
    private static final float[] RED_COLOR_COMPONENTS = new float[]{1.0f, 0.0f, 0.0f};
    private static final long BEACON_DURATION_MS = 5000L;

    @Init
    public static void init() {
        WorldRenderExtractionCallback.EVENT.register(BeaconHighlighter::extractRendering);
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> BeaconHighlighter.reset());
        ClientReceiveMessageEvents.ALLOW_GAME.register(BeaconHighlighter::onMessage);
        WorldEvents.BLOCK_STATE_UPDATE.register(BeaconHighlighter::onBlockStateUpdate);
    }

    private static void reset() {
        BEACONS.clear();
    }

    private static void onBlockStateUpdate(class_2338 pos, class_2680 oldState, class_2680 newState) {
        if (Utils.isInTheEnd() && SlayerManager.isFightingSlayer()) {
            BEACONS.removeLong((Object)pos);
            if (newState.method_27852(class_2246.field_10327)) {
                BEACONS.put((Object)pos.method_10062(), System.currentTimeMillis());
            }
        }
    }

    private static boolean onMessage(class_2561 text, boolean overlay) {
        String message;
        if (Utils.isInTheEnd() && !overlay && ((message = text.getString()).contains("SLAYER QUEST COMPLETE!") || message.contains("NICE! SLAYER BOSS SLAIN!"))) {
            BeaconHighlighter.reset();
        }
        return true;
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (Utils.isInTheEnd() && SkyblockerConfigManager.get().slayers.endermanSlayer.highlightBeacons && SlayerManager.isFightingSlayerType(SlayerType.VOIDGLOOM)) {
            for (Object2LongMap.Entry beacon : BEACONS.object2LongEntrySet()) {
                collector.submitFilledBox((class_2338)beacon.getKey(), RED_COLOR_COMPONENTS, 0.6f, true);
                long elapsed = System.currentTimeMillis() - beacon.getLongValue();
                float remainingSec = (float)(5000L - elapsed) / 1000.0f;
                if (!(remainingSec >= 0.0f)) continue;
                class_5250 text = class_2561.method_43470((String)String.format("%.1fs", Float.valueOf(remainingSec))).method_27692(class_124.field_1075);
                collector.submitText((class_2561)text, ((class_2338)beacon.getKey()).method_10084().method_46558(), 3.0f, true);
            }
        }
    }
}

