/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.slayers.features;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.slayers.SlayerManager;
import de.hysky.skyblocker.skyblock.slayers.SlayerTier;
import de.hysky.skyblocker.skyblock.slayers.SlayerType;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.data.ProfiledData;
import de.hysky.skyblocker.utils.render.title.Title;
import de.hysky.skyblocker.utils.render.title.TitleContainer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_746;

public class SlayerTimer {
    private static final Path FILE = SkyblockerMod.CONFIG_DIR.resolve("slayer_personal_best.json");
    private static final ProfiledData<Object2ObjectOpenHashMap<SlayerType, Object2ObjectOpenHashMap<SlayerTier, SlayerPersonalBest>>> CACHED_SLAYER_STATS = new ProfiledData<Object2ObjectOpenHashMap<SlayerType, Object2ObjectOpenHashMap<SlayerTier, SlayerPersonalBest>>>(FILE, SlayerPersonalBest.SERIALIZATION_CODEC);

    @Init
    public static void init() {
        CACHED_SLAYER_STATS.load();
        ClientCommandRegistrationCallback.EVENT.register(SlayerTimer::registerCommands);
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 commandBuildContext) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"slayers").then(ClientCommandManager.literal((String)"revenant").executes(context -> SlayerTimer.sendSlayerPersonalBest((CommandContext<FabricClientCommandSource>)context, SlayerType.REVENANT)))).then(ClientCommandManager.literal((String)"tarantula").executes(context -> SlayerTimer.sendSlayerPersonalBest((CommandContext<FabricClientCommandSource>)context, SlayerType.TARANTULA)))).then(ClientCommandManager.literal((String)"sven").executes(context -> SlayerTimer.sendSlayerPersonalBest((CommandContext<FabricClientCommandSource>)context, SlayerType.SVEN)))).then(ClientCommandManager.literal((String)"voidgloom").executes(context -> SlayerTimer.sendSlayerPersonalBest((CommandContext<FabricClientCommandSource>)context, SlayerType.VOIDGLOOM)))).then(ClientCommandManager.literal((String)"demonlord").executes(context -> SlayerTimer.sendSlayerPersonalBest((CommandContext<FabricClientCommandSource>)context, SlayerType.DEMONLORD)))).then(ClientCommandManager.literal((String)"vampire").executes(context -> SlayerTimer.sendSlayerPersonalBest((CommandContext<FabricClientCommandSource>)context, SlayerType.VAMPIRE)))));
    }

    private static int sendSlayerPersonalBest(CommandContext<FabricClientCommandSource> context, SlayerType slayerType) {
        FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
        SlayerTier[] tiers = SlayerTier.values();
        for (int i = tiers.length - 1; i >= 0; --i) {
            SlayerTier slayerTier = tiers[i];
            long time = SlayerTimer.getPersonalBest(slayerType, slayerTier);
            if (time == -1L) continue;
            class_5250 bossText = class_2561.method_43470((String)(slayerType.bossName + " " + slayerTier.name())).method_27692(class_124.field_1064);
            class_5250 timeText = class_2561.method_43470((String)SlayerTimer.formatTime(time)).method_27692(class_124.field_1075);
            source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)bossText.method_27693(": ").method_10852((class_2561)timeText)));
            return 1;
        }
        source.sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.slayer.personalBestMissing", (Object[])new Object[]{slayerType.bossName})));
        return 0;
    }

    public static void sendMessage() {
        if (!SkyblockerConfigManager.get().slayers.slainTime) {
            return;
        }
        SlayerManager.SlayerQuest slayerQuest = SlayerManager.getSlayerQuest();
        if (slayerQuest == null || slayerQuest.bossSpawnTime == null) {
            return;
        }
        Instant bossDeathTime = slayerQuest.bossDeathTime != null ? slayerQuest.bossDeathTime : Instant.now();
        long currentPBMills = SlayerTimer.getPersonalBest(slayerQuest.slayerType, slayerQuest.slayerTier);
        long newPBMills = Duration.between(slayerQuest.bossSpawnTime, bossDeathTime).toMillis();
        String currentPB = SlayerTimer.formatTime(currentPBMills);
        String newPB = SlayerTimer.formatTime(newPBMills);
        class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        if (currentPBMills != -1L && currentPBMills > newPBMills) {
            player.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.slayer.slainTime", (Object[])new Object[]{class_2561.method_43470((String)newPB).method_27692(class_124.field_1054)}).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.slayer.personalBest").method_27692(class_124.field_1076))), false);
            player.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.slayer.previousPersonalBest", (Object[])new Object[]{class_2561.method_43470((String)currentPB).method_27692(class_124.field_1054)})), false);
            TitleContainer.addTitleAndPlaySound(new Title("skyblocker.slayer.personalBest", class_124.field_1075), 100);
            TitleContainer.addTitle(new Title(class_2561.method_43470((String)currentPB).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)" \u279c ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)newPB).method_27692(class_124.field_1060))), 100);
            SlayerTimer.updateBestTime(slayerQuest, newPBMills);
        } else {
            player.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.slayer.slainTime", (Object[])new Object[]{class_2561.method_43470((String)newPB).method_27692(class_124.field_1054)})), false);
            if (currentPBMills == -1L) {
                SlayerTimer.updateBestTime(slayerQuest, newPBMills);
            }
        }
    }

    private static long getPersonalBest(SlayerType slayerType, SlayerTier slayerTier) {
        Object2ObjectOpenHashMap profileData = CACHED_SLAYER_STATS.computeIfAbsent(Object2ObjectOpenHashMap::new);
        if (profileData != null) {
            Object2ObjectOpenHashMap typeData = (Object2ObjectOpenHashMap)profileData.computeIfAbsent((Object)slayerType, _type -> new Object2ObjectOpenHashMap());
            SlayerPersonalBest currentBest = (SlayerPersonalBest)typeData.get((Object)slayerTier);
            return currentBest != null ? currentBest.bestTimeMillis() : -1L;
        }
        return -1L;
    }

    private static void updateBestTime(SlayerManager.SlayerQuest slayerQuest, long timeElapsed) {
        Object2ObjectOpenHashMap profileData = CACHED_SLAYER_STATS.computeIfAbsent(Object2ObjectOpenHashMap::new);
        if (profileData != null) {
            Object2ObjectOpenHashMap typeData = (Object2ObjectOpenHashMap)profileData.computeIfAbsent((Object)slayerQuest.slayerType, _type -> new Object2ObjectOpenHashMap());
            typeData.put((Object)slayerQuest.slayerTier, (Object)new SlayerPersonalBest(timeElapsed, System.currentTimeMillis()));
            CACHED_SLAYER_STATS.save();
        }
    }

    private static String formatTime(long millis) {
        return String.format("%.2fs", (double)millis / 1000.0);
    }

    private record SlayerPersonalBest(long bestTimeMillis, long dateMillis) {
        private static final Codec<SlayerPersonalBest> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("bestTimeMillis").forGetter(SlayerPersonalBest::bestTimeMillis), (App)Codec.LONG.fieldOf("dateMillis").forGetter(SlayerPersonalBest::dateMillis)).apply((Applicative)instance, SlayerPersonalBest::new));
        private static final Codec<Object2ObjectOpenHashMap<SlayerType, Object2ObjectOpenHashMap<SlayerTier, SlayerPersonalBest>>> SERIALIZATION_CODEC = Codec.unboundedMap(SlayerType.CODEC, (Codec)Codec.unboundedMap(SlayerTier.CODEC, CODEC).xmap(Object2ObjectOpenHashMap::new, Function.identity())).xmap(Object2ObjectOpenHashMap::new, Function.identity());
    }
}

