/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.special;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.utils.Utils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RareDropSpecialEffects {
    private static final Logger LOGGER = LoggerFactory.getLogger(RareDropSpecialEffects.class);
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Pattern MAGIC_FIND_PATTERN = Pattern.compile("^(?!.*:)(?:RARE|VERY RARE|CRAZY RARE|INSANE) DROP!\\s+(?<item>.+?)(?:\\s+\\(\\+\\d+%? \u272f Magic Find\\))?$");

    @Init
    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(RareDropSpecialEffects::displayRareDropEffect);
    }

    private static boolean displayRareDropEffect(class_2561 message, boolean overlay) {
        if (Utils.isOnSkyblock() && SkyblockerConfigManager.get().general.specialEffects.rareDropEffects && !overlay) {
            try {
                String stringForm = message.getString();
                Matcher magicFindMatcher = MAGIC_FIND_PATTERN.matcher(stringForm);
                if (magicFindMatcher.matches()) {
                    RareDropSpecialEffects.triggerDropEffect(magicFindMatcher.group("item"));
                }
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker Special Effects] An unexpected exception was encountered: ", (Throwable)e);
            }
        }
        return true;
    }

    private static void triggerDropEffect(String itemName) {
        class_1799 stack = RareDropSpecialEffects.getStackFromName(itemName);
        if (stack != null && !stack.method_7960()) {
            RareDropSpecialEffects.CLIENT.field_1713.method_3051((class_1297)RareDropSpecialEffects.CLIENT.field_1724, (class_2394)class_2398.field_29645, 30);
            RareDropSpecialEffects.CLIENT.field_1773.method_3189(stack);
        }
    }

    private static @Nullable class_1799 getStackFromName(String itemName) {
        String itemId = switch (itemName) {
            case "Scythe Blade" -> "SCYTHE_BLADE";
            case "Shard Of The Shredded" -> "SHARD_OF_THE_SHREDDED";
            case "Severed Hand" -> "SEVERED_HAND";
            case "Warden Heart" -> "WARDEN_HEART";
            case "Shriveled Wasp" -> "SHRIVELED_WASP";
            case "Digested Mosquito" -> "DIGESTED_MOSQUITO";
            case "Ensnared Snail" -> "ENSNARED_SNAIL";
            case "Primordial Eye" -> "PRIMORDIAL_EYE";
            case "Overflux Capacitor" -> "OVERFLUX_CAPACITOR";
            case "End Stone Idol" -> "END_STONE_IDOL";
            case "Judgement Core" -> "JUDGEMENT_CORE";
            case "High Class Archfiend Dice" -> "HIGH_CLASS_ARCHFIEND_DICE";
            case "Radioactive Vial" -> "RADIOACTIVE_VIAL";
            case "Tiki Mask" -> "TIKI_MASK";
            case "Titanoboa Shed" -> "TITANOBOA_SHED";
            default -> "NONE";
        };
        return ItemRepository.getItemStack(itemId);
    }
}

