/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.speedpreset;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.serialization.Codec;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.CodecUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.command.CommandUtils;
import de.hysky.skyblocker.utils.data.JsonData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientSendMessageEvents;
import net.minecraft.class_2172;

public class SpeedPresets {
    private static final Pattern COMMAND_PATTERN = Pattern.compile("^setmaxspeed\\s([a-zA-Z]\\w*)$");
    private static final Codec<Object2IntMap<String>> MAP_CODEC = CodecUtils.object2IntMapCodec(Codec.STRING);
    private static final Path PRESETS_FILE = SkyblockerMod.CONFIG_DIR.resolve("speed_presets.json");
    private static SpeedPresets instance;
    private final JsonData<Object2IntMap<String>> presets = new JsonData<Object2IntOpenHashMap<String>>(PRESETS_FILE, MAP_CODEC, SpeedPresets.createDefaultMap());

    private SpeedPresets() {
    }

    public static SpeedPresets getInstance() {
        return instance == null ? (instance = new SpeedPresets()) : instance;
    }

    public static CommandNode<FabricClientCommandSource> getCommandNode() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"setmaxspeed").requires(source -> Utils.isOnSkyblock())).executes(CommandUtils.noOp)).then(ClientCommandManager.argument((String)"preset", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
            if (SkyblockerConfigManager.get().general.speedPresets.enableSpeedPresets && SpeedPresets.getInstance().presets.isLoaded()) {
                return class_2172.method_9265((Iterable)instance.getPresets().keySet(), (SuggestionsBuilder)builder);
            }
            return builder.buildFuture();
        }).executes(CommandUtils.noOp))).build();
    }

    @Init
    public static void init() {
        SpeedPresets instance = SpeedPresets.getInstance();
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> instance.presets.init());
        ClientSendMessageEvents.MODIFY_COMMAND.register(command -> {
            String preset;
            Matcher matcher = COMMAND_PATTERN.matcher(command);
            if (matcher.matches() && SkyblockerConfigManager.get().general.speedPresets.enableSpeedPresets && instance.hasPreset(preset = matcher.group(1))) {
                return String.format("setmaxspeed %d", instance.getPreset(preset));
            }
            return command;
        });
    }

    public boolean hasPreset(String name) {
        return this.getPresets().containsKey((Object)name);
    }

    public int getPreset(String name) {
        return this.getPresets().getOrDefault((Object)name, 0);
    }

    public void setPreset(String name, int value) {
        this.getPresets().put((Object)name, value);
        this.presets.save();
    }

    public boolean arePresetsEqual(Map<String, Integer> presets) {
        if (presets.size() != this.getPresets().size()) {
            return false;
        }
        for (Map.Entry<String, Integer> entry : presets.entrySet()) {
            if (this.getPresets().containsKey((Object)entry.getKey()) && this.getPresets().getInt((Object)entry.getKey()) == entry.getValue().intValue()) continue;
            return false;
        }
        return true;
    }

    public Object2IntMap<String> getPresets() {
        return this.presets.getData();
    }

    public CompletableFuture<Void> savePresets() {
        return this.presets.save();
    }

    public static Object2IntOpenHashMap<String> createDefaultMap() {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        map.put((Object)"default", 100);
        map.put((Object)"crops", 93);
        map.put((Object)"cocoa", 155);
        map.put((Object)"mushroom", 233);
        map.put((Object)"cane", 327);
        map.put((Object)"squash", 327);
        map.put((Object)"cactus", 464);
        return map;
    }
}

