/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.config.entries.slot;

import de.hysky.skyblocker.skyblock.tabhud.config.WidgetsElementList;
import de.hysky.skyblocker.skyblock.tabhud.config.WidgetsListTab;
import de.hysky.skyblocker.skyblock.tabhud.config.entries.slot.WidgetsListSlotEntry;
import de.hysky.skyblocker.utils.ItemUtils;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_11909;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4185;

public class WidgetSlotEntry
extends WidgetsListSlotEntry {
    private final class_4185 editButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"EDIT"), button -> {
        this.parent.clickAndWaitForServer(this.slotId, 1);
        this.parent.resetScrollOnLoad();
    }).method_46437(32, 12).method_46431();
    private final State state;
    private final class_4185 enableButton;
    private final boolean alwaysEnabled;

    public WidgetSlotEntry(WidgetsListTab parent, int slotId, class_1799 icon) {
        super(parent, slotId, icon);
        String string = icon.method_7964().getString().trim();
        this.state = string.startsWith("\u2714") ? State.ENABLED : (string.startsWith("\u2716") ? State.DISABLED : State.LOCKED);
        this.enableButton = class_4185.method_46430((class_2561)(this.state.equals((Object)State.ENABLED) ? ENABLED_TEXT : DISABLED_TEXT), button -> this.parent.clickAndWaitForServer(this.slotId, 0)).method_46437(64, 12).method_46431();
        this.alwaysEnabled = ItemUtils.getLoreLineIf(icon, s -> s.toLowerCase(Locale.ENGLISH).contains("always enable")) != null;
    }

    @Override
    public void renderTooltip(class_332 context, int x, int y, int entryWidth, int entryHeight, int mouseX, int mouseY) {
        if (mouseX >= x && mouseX <= x + entryWidth - 110 && mouseY >= y && mouseY <= y + entryHeight) {
            List<class_2561> lore = ItemUtils.getLore(this.icon);
            if (this.alwaysEnabled) {
                lore = lore.subList(0, Math.max(lore.size() - 2, 0));
            } else if (this.state != State.LOCKED) {
                lore = lore.subList(0, Math.max(lore.size() - 3, 0));
            }
            context.method_51434(class_310.method_1551().field_1772, lore, mouseX, mouseY);
        }
    }

    public List<? extends class_364> method_25396() {
        return this.alwaysEnabled ? List.of(this.editButton) : List.of(this.editButton, this.enableButton);
    }

    public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
        int textY = this.method_46427() + (this.method_25364() - 9) / 2;
        class_327 textRenderer = class_310.method_1551().field_1772;
        this.renderIconAndText(context, this.method_46427(), this.method_46426(), this.method_25364());
        if (this.state != State.LOCKED) {
            this.editButton.method_48229(this.method_46426() + this.method_25368() - 40, this.method_46427() + (this.method_25364() - 12) / 2);
            this.editButton.method_25394(context, mouseX, mouseY, deltaTicks);
            if (!this.alwaysEnabled) {
                this.enableButton.method_48229(this.method_46426() + this.method_25368() - 110, this.method_46427() + (this.method_25364() - 12) / 2);
                this.enableButton.method_25394(context, mouseX, mouseY, deltaTicks);
            }
        } else {
            context.method_51433(textRenderer, "LOCKED", this.method_46426() + this.method_25368() - 50, textY, -65536, true);
        }
    }

    private static void addToast(class_2561 message) {
        class_310.method_1551().method_1566().method_1999((class_368)new class_370(WidgetsListTab.SYSTEM_TOAST_ID, message, null));
    }

    public boolean method_25402(class_11909 event, boolean doubled) {
        boolean isGreater;
        boolean isSelect;
        if (super.method_25402(event, doubled) || this.parent.isWaitingForServer()) {
            return true;
        }
        boolean bl = isSelect = event.method_74245() == 0;
        if (isSelect && this.state != State.ENABLED) {
            WidgetSlotEntry.addToast((class_2561)class_2561.method_43471((String)"skyblocker.uiAndVisuals.tabHud.widgetsScreen.toast.mustEnableWidget"));
            return false;
        }
        int relativePosition = this.slotId - 18 - 1;
        if (WidgetsElementList.editingPosition == (relativePosition -= 2 * (relativePosition / 9))) {
            return false;
        }
        if (isSelect && relativePosition == 0 && !WidgetsElementList.isOnSecondPage) {
            WidgetSlotEntry.addToast((class_2561)class_2561.method_43471((String)"skyblocker.uiAndVisuals.tabHud.widgetsScreen.toast.unselectableWidget"));
            return false;
        }
        if (!isSelect && relativePosition > WidgetsElementList.maxPosition) {
            WidgetSlotEntry.addToast((class_2561)class_2561.method_43471((String)"skyblocker.uiAndVisuals.tabHud.widgetsScreen.toast.cannotMoveHere"));
            return true;
        }
        boolean bl2 = isGreater = WidgetsElementList.editingPosition > relativePosition;
        if (isSelect) {
            this.parent.clickAndWaitForServer(13, isGreater ? 1 : 0);
        } else {
            this.parent.shiftClickAndWaitForServer(13, isGreater ? 1 : 0);
        }
        int remainingClicks = Math.abs(WidgetsElementList.editingPosition - relativePosition) - 1;
        if (remainingClicks == 0) {
            return true;
        }
        if (isSelect) {
            WidgetSlotEntry.addToast((class_2561)class_2561.method_43469((String)"skyblocker.uiAndVisuals.tabHud.widgetsScreen.toast.remainingClicksToSelect", (Object[])new Object[]{remainingClicks}));
        } else {
            WidgetSlotEntry.addToast((class_2561)class_2561.method_43469((String)"skyblocker.uiAndVisuals.tabHud.widgetsScreen.toast.remainingClicksToMove", (Object[])new Object[]{remainingClicks}));
        }
        return true;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        ENABLED,
        DISABLED,
        LOCKED;

    }
}

