/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.screenbuilder.pipeline;

import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.WidgetManager;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.pipeline.PositionRule;
import de.hysky.skyblocker.skyblock.tabhud.widget.HudWidget;
import java.util.function.Function;
import net.minecraft.class_8029;
import org.jspecify.annotations.Nullable;

public abstract class WidgetPositioner {
    protected final int screenWidth;
    protected final int screenHeight;

    public WidgetPositioner(int screenWidth, int screenHeight) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public abstract void positionWidget(HudWidget var1);

    public abstract void finalizePositioning();

    public static void applyRuleToWidget(HudWidget widget, int screenWidth, int screenHeight, Function<String, PositionRule> ruleProvider) {
        int startY;
        int startX;
        widget.setPositioned(true);
        PositionRule rule = ruleProvider.apply(widget.getInternalID());
        if (rule == null) {
            return;
        }
        if (rule.parent().equals("screen")) {
            startX = (int)(rule.parentPoint().horizontalPoint().getPercentage() * (float)screenWidth);
            startY = (int)(rule.parentPoint().verticalPoint().getPercentage() * (float)screenHeight);
        } else {
            HudWidget parentWidget = WidgetManager.widgetInstances.get(rule.parent());
            if (parentWidget == null) {
                return;
            }
            if (!parentWidget.isPositioned()) {
                WidgetPositioner.applyRuleToWidget(parentWidget, screenWidth, screenHeight, ruleProvider);
            }
            if (parentWidget.isVisible()) {
                startX = parentWidget.method_46426() + (int)(rule.parentPoint().horizontalPoint().getPercentage() * (float)parentWidget.method_25368());
                startY = parentWidget.method_46427() + (int)(rule.parentPoint().verticalPoint().getPercentage() * (float)parentWidget.method_25364());
            } else {
                startX = parentWidget.method_46426();
                startY = parentWidget.method_46427();
            }
        }
        if (widget.isVisible()) {
            widget.method_46421(startX + rule.relativeX() - (int)(rule.thisPoint().horizontalPoint().getPercentage() * (float)widget.method_25368()));
            widget.method_46419(startY + rule.relativeY() - (int)(rule.thisPoint().verticalPoint().getPercentage() * (float)widget.method_25364()));
        } else {
            widget.method_46421(startX + rule.relativeX());
            widget.method_46419(startY + rule.relativeY());
        }
    }

    public static @Nullable class_8029 getStartPosition(String parent, int screenWidth, int screenHeight, PositionRule.Point parentPoint) {
        if (parent.equals("screen")) {
            return new class_8029((int)(parentPoint.horizontalPoint().getPercentage() * (float)screenWidth), (int)(parentPoint.verticalPoint().getPercentage() * (float)screenHeight));
        }
        HudWidget parentWidget = WidgetManager.widgetInstances.get(parent);
        if (parentWidget == null) {
            return null;
        }
        return new class_8029(parentWidget.method_46426() + (int)(parentPoint.horizontalPoint().getPercentage() * (float)parentWidget.method_25368()), parentWidget.method_46427() + (int)(parentPoint.verticalPoint().getPercentage() * (float)parentWidget.method_25364()));
    }
}

