/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.widget;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.skyblock.tabhud.widget.TabHudWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.Components;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.PlainTextComponent;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

@RegisterWidget
public class ElectionWidget
extends TabHudWidget {
    private static final class_5250 TITLE = class_2561.method_43470((String)"Election Info").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067});
    private static final Map<String, class_1799> MAYOR_DATA = Map.ofEntries(Map.entry("Aatrox", Ico.DIA_SWORD), Map.entry("Cole", Ico.IRON_PICKAXE), Map.entry("Diana", Ico.BONE), Map.entry("Diaz", Ico.GOLD), Map.entry("Finnegan", Ico.IRON_HOE), Map.entry("Foxy", Ico.SUGAR), Map.entry("Paul", Ico.COMPASS), Map.entry("Scorpius", Ico.GOLDEN_APPLE), Map.entry("Jerry", Ico.VILLAGER), Map.entry("Derpy", Ico.DBUSH), Map.entry("Marina", Ico.FISH_ROD), Map.entry("Aura", Ico.OMINOUS_BOTTLE));
    private static final class_2561 EL_OVER = class_2561.method_43470((String)"Election: ").method_10852((class_2561)class_2561.method_43470((String)"Over!").method_27692(class_124.field_1061));
    private static final Pattern VOTE_PATTERN = Pattern.compile("(?<mayor>\\S*): \\|+ \\((?<pcnt>\\d*)%\\)");
    private static final class_124[] COLS = new class_124[]{class_124.field_1061, class_124.field_1076, class_124.field_1060, class_124.field_1075, class_124.field_1054};

    public ElectionWidget() {
        super("Election", TITLE, class_124.field_1054.method_532());
    }

    @Override
    public void updateContent(List<class_2561> lines) {
        String status = lines.getFirst().getString();
        if (status == null) {
            this.addComponent(Components.iconTextComponent());
            this.addComponent(Components.iconTextComponent());
            this.addComponent(Components.iconTextComponent());
            this.addComponent(Components.iconTextComponent());
            return;
        }
        if (status.contains("Over!")) {
            this.addComponent(Components.iconTextComponent(Ico.BARRIER, EL_OVER));
            for (int i = 1; i < lines.size(); ++i) {
                this.addComponent(new PlainTextComponent(lines.get(i)));
            }
        } else {
            this.addSimpleIcoText(Ico.CLOCK, "Ends in: ", class_124.field_1065, lines.getFirst().getString().trim());
            for (int i = 1; i < lines.size(); ++i) {
                String string = lines.get(i).getString();
                Matcher m = VOTE_PATTERN.matcher(string);
                if (m.matches()) {
                    String mayorname = m.group("mayor");
                    String pcntstr = m.group("pcnt");
                    float pcnt = Float.parseFloat(pcntstr);
                    class_5250 candidate = class_2561.method_43470((String)mayorname).method_27692(COLS[i - 1]);
                    this.addComponent(Components.progressComponent(MAYOR_DATA.get(mayorname), (class_2561)candidate, pcnt, COLS[i - 1].method_532()));
                    continue;
                }
                this.addComponent(new PlainTextComponent(lines.get(i)));
            }
        }
    }
}

