/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonParser;
import com.mojang.util.UndashedUuid;
import de.hysky.skyblocker.utils.Http;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_310;
import net.minecraft.class_320;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiUtils.class);
    private static final LoadingCache<String, String> NAME_2_UUID_CACHE = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String key) throws Exception {
            return ApiUtils.name2UuidInternal(key, 0);
        }
    });

    public static String name2Uuid(String name) {
        return (String)NAME_2_UUID_CACHE.getUnchecked((Object)name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String name2UuidInternal(String name, int retries) {
        class_320 session = class_310.method_1551().method_1548();
        if (session.method_1676().equalsIgnoreCase(name)) {
            return UndashedUuid.toString((UUID)session.method_44717());
        }
        try (Http.ApiResponse response = Http.sendName2UuidRequest(name);){
            if (response.ok()) {
                String string = JsonParser.parseString(response.content()).getAsJsonObject().get("id").getAsString();
                return string;
            }
            if (!response.ratelimited()) return "";
            if (retries >= 3) return "";
            Thread.sleep(800L);
            String string = ApiUtils.name2UuidInternal(name, ++retries);
            return string;
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Name to uuid lookup failed! Name: {}", (Object)name, (Object)e);
        }
        return "";
    }
}

