/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import java.util.Arrays;

public sealed interface Area {
    public static final Area UNKNOWN = new Unknown();

    public String displayName();

    public static Area from(String name) {
        return Arrays.stream(Area.class.getPermittedSubclasses()).mapMulti((clazz, consumer) -> {
            if (clazz.isEnum()) {
                for (Area area : (Area[])clazz.getEnumConstants()) {
                    consumer.accept(area);
                }
            }
        }).filter(area -> area.displayName().equals(name)).findFirst().orElse(UNKNOWN);
    }

    @Deprecated
    public record Unknown() implements Area
    {
        @Override
        public String displayName() {
            return "Unknown";
        }
    }

    public static enum TheRift implements Area
    {
        CHATEAU("Stillgore Ch\u00e2teau"),
        MIRRORVERSE("Mirrorverse");

        private final String displayName;

        private TheRift(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String displayName() {
            return this.displayName;
        }
    }

    public static enum CrystalHollows implements Area
    {
        MINES_OF_DIVAN("Mines of Divan"),
        JUNGLE_TEMPLE("Jungle Temple");

        private final String displayName;

        private CrystalHollows(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String displayName() {
            return this.displayName;
        }
    }

    public static enum DwarvenMines implements Area
    {
        DWARVEN_BASE_CAMP("Dwarven Base Camp"),
        GLACITE_MINESHAFTS("Glacite Mineshafts"),
        GLACITE_TUNNELS("Glacite Tunnels"),
        GREAT_GLACITE_LAKE("Great Glacite Lake");

        private final String displayName;

        private DwarvenMines(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String displayName() {
            return this.displayName;
        }
    }

    public static enum CrimsonIsle implements Area
    {
        DOJO("Dojo");

        private final String displayName;

        private CrimsonIsle(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String displayName() {
            return this.displayName;
        }
    }

    public static enum TheEnd implements Area
    {
        DRAGONS_NEST("Dragon's Nest"),
        THE_END("The End");

        private final String displayName;

        private TheEnd(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String displayName() {
            return this.displayName;
        }
    }

    public static enum Galatea implements Area
    {
        FOREST_TEMPLE("Forest Temple");

        private final String displayName;

        private Galatea(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String displayName() {
            return this.displayName;
        }
    }

    public static enum TheFarmingIslands implements Area
    {
        GLOWING_MUSHROOM_CAVE("Glowing Mushroom Cave");

        private final String displayName;

        private TheFarmingIslands(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String displayName() {
            return this.displayName;
        }
    }

    public static enum Hub implements Area
    {
        BANK("Bank"),
        BAZAAR("Bazaar Alley"),
        CARNIVAL("Carnival"),
        FOREST("Forest");

        private final String displayName;

        private Hub(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String displayName() {
            return this.displayName;
        }
    }

    public static enum PrivateIsland implements Area
    {
        YOUR_ISLAND("Your Island");

        private final String displayName;

        private PrivateIsland(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public String displayName() {
            return this.displayName;
        }
    }
}

