/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import ca.weblite.objc.Client;
import com.ibm.icu.text.DateTimePatternGenerator;
import de.hysky.skyblocker.debug.Debug;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import net.minecraft.class_11906;
import net.minecraft.class_156;

public class Formatters {
    public static final NumberFormat INTEGER_NUMBERS = NumberFormat.getIntegerInstance(Locale.US);
    public static final NumberFormat DOUBLE_NUMBERS = (NumberFormat)class_156.method_654((Object)NumberFormat.getInstance(Locale.US), nf -> nf.setMaximumFractionDigits(2));
    public static final NumberFormat FLOAT_NUMBERS = (NumberFormat)class_156.method_654((Object)NumberFormat.getInstance(Locale.US), nf -> nf.setMaximumFractionDigits(1));
    public static final NumberFormat SHORT_INTEGER_NUMBERS = NumberFormat.getCompactNumberInstance(Locale.US, NumberFormat.Style.SHORT);
    public static final NumberFormat SHORT_FLOAT_NUMBERS = (NumberFormat)class_156.method_654((Object)NumberFormat.getCompactNumberInstance(Locale.US, NumberFormat.Style.SHORT), nf -> nf.setMinimumFractionDigits(1));
    public static final NumberFormat DIFF_NUMBERS = (NumberFormat)class_156.method_654((Object)((DecimalFormat)NumberFormat.getNumberInstance(Locale.US)), nf -> nf.setPositivePrefix("+"));
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("E MMM d yyyy " + Formatters.getTimeFormat(), Locale.US).withZone(Formatters.getTimeZone());

    public static Number parseNumber(String number) throws NumberFormatException {
        try {
            return SHORT_INTEGER_NUMBERS.parse(number.replace(",", ""));
        }
        catch (ParseException e) {
            throw new NumberFormatException("For input string: \"" + number + "\"");
        }
    }

    private static String getTimeFormat() {
        return Formatters.is12HourClock() || Debug.isTestEnvironment() ? "h:mm:ss a" : "HH:mm:ss";
    }

    private static ZoneId getTimeZone() {
        return Debug.isTestEnvironment() ? ZoneId.of("UTC") : ZoneId.systemDefault();
    }

    private static boolean is12HourClock() {
        if (class_11906.field_62586) {
            Object locale = Client.getInstance().send("NSLocale", "currentLocale", new Object[0]);
            String timeFormat = (String)Client.getInstance().send("NSDateFormatter", "dateFormatFromTemplate:options:locale:", new Object[]{"j", 0, locale});
            return timeFormat.contains("a");
        }
        return DateTimePatternGenerator.getInstance((Locale)Locale.getDefault()).getBestPattern("j").contains("a");
    }
}

