/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.utils.ApiAuthentication;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.class_155;
import org.jspecify.annotations.Nullable;

public class Http {
    private static final String NAME_2_UUID = "https://api.minecraftservices.com/minecraft/profile/lookup/name/";
    private static final String HYPIXEL_PROXY = "https://api.azureaaron.net/hypixel/v2/";
    public static final String USER_AGENT = "Skyblocker/" + SkyblockerMod.VERSION + " (" + class_155.method_16673().comp_4025() + ")";
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).executor(Executors.newVirtualThreadPerTaskExecutor()).followRedirects(HttpClient.Redirect.NORMAL).build();

    public static ApiResponse sendCacheableGetRequest(String url, @Nullable String token) throws IOException, InterruptedException {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().GET().header("Accept", "application/json").header("Accept-Encoding", "gzip, deflate").header("User-Agent", USER_AGENT).version(HttpClient.Version.HTTP_2).uri(URI.create(url));
        if (token != null) {
            requestBuilder.header("Authorization", "Bearer " + token);
        }
        HttpRequest request = requestBuilder.build();
        HttpResponse<InputStream> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofInputStream());
        try (InputStream decodedInputStream = Http.getDecodedInputStream(response);){
            String body = new String(decodedInputStream.readAllBytes());
            HttpHeaders headers = response.headers();
            ApiResponse apiResponse = new ApiResponse(body, response.statusCode(), Http.getCacheStatuses(headers), Http.getAge(headers));
            return apiResponse;
        }
    }

    public static InputStream downloadContent(String url) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().GET().header("Accept", "*/*").header("Accept-Encoding", "gzip, deflate").header("User-Agent", USER_AGENT).version(HttpClient.Version.HTTP_2).uri(URI.create(url)).build();
        HttpResponse<InputStream> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofInputStream());
        return Http.getDecodedInputStream(response);
    }

    public static String sendGetRequest(String url) throws IOException, InterruptedException {
        return Http.sendCacheableGetRequest(url, null).content();
    }

    public static HttpHeaders sendHeadRequest(String url) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().method("HEAD", HttpRequest.BodyPublishers.noBody()).header("User-Agent", USER_AGENT).version(HttpClient.Version.HTTP_2).uri(URI.create(url)).build();
        HttpResponse<Void> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.discarding());
        return response.headers();
    }

    public static String sendPostRequest(String url, String requestBody, String contentType) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(requestBody)).header("Accept", contentType).header("Accept-Encoding", "gzip, deflate").header("Content-Type", contentType).header("User-Agent", USER_AGENT).version(HttpClient.Version.HTTP_2).uri(URI.create(url)).build();
        HttpResponse<InputStream> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofInputStream());
        try (InputStream decodedInputStream = Http.getDecodedInputStream(response);){
            String string = new String(decodedInputStream.readAllBytes());
            return string;
        }
    }

    public static ApiResponse sendName2UuidRequest(String name) throws IOException, InterruptedException {
        return Http.sendCacheableGetRequest(NAME_2_UUID + name, null);
    }

    public static ApiResponse sendHypixelRequest(String endpoint, String query) throws IOException, InterruptedException {
        return Http.sendCacheableGetRequest(HYPIXEL_PROXY + endpoint + query, ApiAuthentication.getToken());
    }

    private static InputStream getDecodedInputStream(HttpResponse<InputStream> response) {
        String encoding = Http.getContentEncoding(response.headers());
        try {
            return switch (encoding) {
                case "" -> response.body();
                case "gzip" -> new GZIPInputStream(response.body());
                case "deflate" -> new InflaterInputStream(response.body());
                default -> throw new UnsupportedOperationException("The server sent content in an unexpected encoding: " + encoding);
            };
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String getContentEncoding(HttpHeaders headers) {
        return headers.firstValue("Content-Encoding").orElse("");
    }

    public static String getEtag(HttpHeaders headers) {
        return headers.firstValue("Etag").orElse("");
    }

    public static String getLastModified(HttpHeaders headers) {
        return headers.firstValue("Last-Modified").orElse("");
    }

    private static String[] getCacheStatuses(HttpHeaders headers) {
        return new String[]{headers.firstValue("CF-Cache-Status").orElse("UNKNOWN"), headers.firstValue("Local-Cache-Status").orElse("UNKNOWN")};
    }

    private static int getAge(HttpHeaders headers) {
        return Integer.parseInt(headers.firstValue("Age").orElse("-1"));
    }

    public record ApiResponse(String content, int statusCode, String[] cacheStatuses, int age) implements AutoCloseable
    {
        public boolean ok() {
            return this.statusCode == 200;
        }

        public boolean ratelimited() {
            return this.statusCode == 429;
        }

        public boolean cached() {
            return this.cacheStatuses[0].equals("HIT") || this.cacheStatuses[1].equals("HIT");
        }

        @Override
        public void close() {
        }
    }
}

