/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import org.apache.commons.lang3.math.NumberUtils;

public record ItemAbility(String name, Activation activation, OptionalInt manaCost, OptionalInt soulflowCost, OptionalInt cooldown) {
    private static final Pattern ABILITY_NAME_PATTERN = Pattern.compile("(?:\u29be )?Ability: (.+) {2}(" + String.join((CharSequence)"|", (CharSequence[])Arrays.stream(Activation.values()).map(Activation::toString).toArray(String[]::new)) + ")");
    private static final Pattern MANA_COST_PATTERN = Pattern.compile("Mana Cost: (\\d+)");
    private static final Pattern SOULFLOW_COST_PATTERN = Pattern.compile("Soulflow Cost: (\\d+)");
    private static final Pattern COOLDOWN_PATTERN = Pattern.compile("Cooldown: ([0-9]+\\.?[0-9]*)s");

    @Deprecated
    public static List<ItemAbility> getAbilities(class_1799 stack) {
        List strings = stack.skyblocker$getLoreStrings();
        ArrayList<ItemAbility> abilities = new ArrayList<ItemAbility>(2);
        String name = null;
        int manaCost = -1;
        int soulflowCost = -1;
        int cooldown = -1;
        Activation activation = null;
        for (String string : strings) {
            Matcher matcher = ABILITY_NAME_PATTERN.matcher(string = class_124.method_539((String)string).trim());
            if (matcher.matches()) {
                if (name != null) {
                    abilities.add(new ItemAbility(name, activation, ItemAbility.positiveOnly(manaCost), ItemAbility.positiveOnly(soulflowCost), ItemAbility.positiveOnly(cooldown)));
                }
                name = matcher.group(1);
                manaCost = -1;
                soulflowCost = -1;
                cooldown = -1;
                activation = Activation.of(matcher.group(2));
            }
            if (name == null) continue;
            if (manaCost < 0 && (matcher = MANA_COST_PATTERN.matcher(string)).matches()) {
                manaCost = NumberUtils.toInt((String)matcher.group(1), (int)-1);
                continue;
            }
            if (soulflowCost < 0 && (matcher = SOULFLOW_COST_PATTERN.matcher(string)).matches()) {
                soulflowCost = NumberUtils.toInt((String)matcher.group(1), (int)-1);
                continue;
            }
            if (cooldown >= 0 || !(matcher = COOLDOWN_PATTERN.matcher(string)).matches()) continue;
            cooldown = (int)(NumberUtils.toFloat((String)matcher.group(1), (float)-1.0f) * 20.0f);
        }
        if (name != null) {
            abilities.add(new ItemAbility(name, activation, ItemAbility.positiveOnly(manaCost), ItemAbility.positiveOnly(soulflowCost), ItemAbility.positiveOnly(cooldown)));
        }
        return abilities;
    }

    public static boolean hasAbility(class_1799 stack, String ability) {
        List abilities = stack.skyblocker$getAbilities();
        for (ItemAbility itemAbility : abilities) {
            if (!itemAbility.name().equals(ability)) continue;
            return true;
        }
        return false;
    }

    private static OptionalInt positiveOnly(int value) {
        return value < 0 ? OptionalInt.empty() : OptionalInt.of(value);
    }

    public static enum Activation {
        RIGHT_CLICK,
        LEFT_CLICK,
        SNEAK_RIGHT_CLICK,
        SNEAK_LEFT_CLICK;


        public String toString() {
            return this.name().replace('_', ' ');
        }

        public static Activation of(String name) {
            for (Activation value : Activation.values()) {
                if (!value.toString().equals(name)) continue;
                return value;
            }
            return RIGHT_CLICK;
        }

        public boolean isRightClick() {
            return this == SNEAK_RIGHT_CLICK || this == RIGHT_CLICK;
        }

        public boolean isLeftClick() {
            return this == SNEAK_LEFT_CLICK || this == LEFT_CLICK;
        }
    }
}

