/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import com.mojang.serialization.Codec;
import de.hysky.skyblocker.utils.CodecUtils;
import java.util.Arrays;
import java.util.EnumSet;
import net.minecraft.class_3542;

public enum Location implements class_3542
{
    PRIVATE_ISLAND("dynamic", "Private Island"),
    GARDEN("garden", "Garden"),
    HUB("hub", "Hub", true),
    THE_FARMING_ISLAND("farming_1", "The Farming Islands", true),
    THE_PARK("foraging_1", "The Park", true),
    SPIDERS_DEN("combat_1", "Spider's Den", true),
    BLAZING_FORTRESS("combat_2", "Blazing Fortress"),
    THE_END("combat_3", "The End", true),
    CRIMSON_ISLE("crimson_isle", "Crimson Isle"),
    GOLD_MINE("mining_1", "Gold Mine", true),
    DEEP_CAVERNS("mining_2", "Deep Caverns"),
    DWARVEN_MINES("mining_3", "Dwarven Mines"),
    BACKWATER_BAYOU("fishing_1", "Backwater Bayou"),
    DUNGEON_HUB("dungeon_hub", "Dungeon Hub"),
    WINTER_ISLAND("winter", "Jerry's Workshop"),
    THE_RIFT("rift", "The Rift"),
    DARK_AUCTION("dark_auction", "Dark Auction"),
    CRYSTAL_HOLLOWS("crystal_hollows", "Crystal Hollows"),
    DUNGEON("dungeon", "Dungeons"),
    KUUDRAS_HOLLOW("kuudra", "Kuudra's Hollow"),
    GLACITE_MINESHAFTS("mineshaft", "Glacite Mineshafts"),
    GALATEA("foraging_2", "Galatea", true),
    UNKNOWN("unknown", "Unknown");

    public static final Codec<Location> CODEC;
    public static final Codec<EnumSet<Location>> SET_CODEC;
    private final String id;
    private final String friendlyName;
    private final boolean modern;

    private Location(String id, String friendlyName) {
        this.id = id;
        this.friendlyName = friendlyName;
        this.modern = false;
    }

    private Location(String id, String friendlyName, boolean modern) {
        this.id = id;
        this.friendlyName = friendlyName;
        this.modern = modern;
    }

    public String id() {
        return this.id;
    }

    public boolean isModern() {
        return this.modern;
    }

    public String method_15434() {
        return this.id();
    }

    public static Location from(String id) {
        return Arrays.stream(Location.values()).filter(loc -> loc.id.equals(id)).findFirst().orElse(UNKNOWN);
    }

    public static Location fromFriendlyName(String friendlyName) {
        return Arrays.stream(Location.values()).filter(loc -> loc.friendlyName.equalsIgnoreCase(friendlyName)).findFirst().orElse(UNKNOWN);
    }

    public String toString() {
        return this.friendlyName;
    }

    static {
        CODEC = class_3542.method_28140(Location::values);
        SET_CODEC = CodecUtils.enumSetCodec(CODEC, Location.class);
    }
}

