/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.utils.ApiUtils;
import de.hysky.skyblocker.utils.Http;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ProfileUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final LoadingCache<String, JsonObject> UUID_TO_PROFILES_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, JsonObject>(){

        public JsonObject load(String uuid) throws Exception {
            return ProfileUtils.fetchProfilesInternal(uuid);
        }
    });

    public static CompletableFuture<@Nullable JsonObject> fetchProfileMember(String name) {
        return CompletableFuture.supplyAsync(() -> {
            String uuid = ApiUtils.name2Uuid(name);
            if (!uuid.isEmpty()) {
                JsonObject profile = (JsonObject)UUID_TO_PROFILES_CACHE.getUnchecked((Object)uuid);
                JsonObject player = profile.getAsJsonArray("profiles").asList().stream().map(JsonElement::getAsJsonObject).filter(profileObj -> profileObj.getAsJsonPrimitive("selected").getAsBoolean()).findFirst().orElseThrow(() -> new IllegalStateException("No selected profile found!?")).getAsJsonObject("members").get(uuid).getAsJsonObject();
                return player;
            }
            return null;
        }, Executors.newVirtualThreadPerTaskExecutor());
    }

    public static CompletableFuture<@Nullable JsonObject> fetchFullProfile(String name) {
        return CompletableFuture.supplyAsync(() -> {
            String uuid = ApiUtils.name2Uuid(name);
            return !uuid.isEmpty() ? (JsonObject)UUID_TO_PROFILES_CACHE.getUnchecked((Object)uuid) : null;
        }, Executors.newVirtualThreadPerTaskExecutor());
    }

    public static CompletableFuture<@Nullable JsonObject> fetchFullProfileByUuid(String uuid) {
        return CompletableFuture.supplyAsync(() -> !uuid.isEmpty() ? (JsonObject)UUID_TO_PROFILES_CACHE.getUnchecked((Object)uuid) : null, Executors.newVirtualThreadPerTaskExecutor());
    }

    private static @Nullable JsonObject fetchProfilesInternal(String uuid) {
        Http.ApiResponse response = Http.sendHypixelRequest("skyblock/profiles", "?uuid=" + uuid);
        try {
            if (!response.ok()) {
                throw new IllegalStateException(String.format("Failed to get profile for player: %s!, Status Code: %d, Response: %s", uuid, response.statusCode(), response.content()));
            }
            JsonObject jsonObject = SkyblockerMod.GSON.fromJson(response.content(), JsonObject.class);
            if (response != null) {
                response.close();
            }
            return jsonObject;
        }
        catch (Throwable throwable) {
            try {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker Profile Utils] Failed to get Player Profile Data for player {}, is the API Down/Limited?", (Object)uuid, (Object)e);
                return null;
            }
        }
    }
}

