/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public final class RegexListUtils {
    private RegexListUtils() {
    }

    public static int indexOfInList(List<String> list, Pattern pattern) {
        return RegexListUtils.indexOfInList(list, Function.identity(), pattern);
    }

    public static <T> int indexOfInList(List<T> list, Function<T, String> toStringFunction, Pattern pattern) {
        return RegexListUtils.indexOfInList(list, toStringFunction, pattern, 0);
    }

    public static <T> int indexOfInList(List<T> list, Function<T, String> toStringFunction, Pattern pattern, int startIndex) {
        if (startIndex >= list.size()) {
            return -1;
        }
        Matcher matcher = pattern.matcher("");
        int listSize = list.size();
        for (int i = startIndex; i < listSize; ++i) {
            String string = toStringFunction.apply(list.get(i));
            if (!matcher.reset(string).matches()) continue;
            return i;
        }
        return -1;
    }

    public static @Nullable Matcher findInList(List<String> list, Pattern pattern) {
        return RegexListUtils.findInList(list, Function.identity(), pattern);
    }

    public static <T> @Nullable Matcher findInList(List<T> list, Function<T, String> toStringFunction, Pattern pattern) {
        return RegexListUtils.findInList(list, toStringFunction, pattern, 0);
    }

    public static <T> @Nullable Matcher findInList(List<T> list, Function<T, String> toStringFunction, Pattern pattern, int startIndex) {
        if (startIndex >= list.size()) {
            return null;
        }
        Matcher matcher = pattern.matcher("");
        int listSize = list.size();
        for (int i = startIndex; i < listSize; ++i) {
            String string = toStringFunction.apply(list.get(i));
            if (!matcher.reset(string).find()) continue;
            return matcher;
        }
        return null;
    }

    public static @Nullable Matcher matchInList(List<String> list, Pattern pattern) {
        return RegexListUtils.matchInList(list, Function.identity(), pattern);
    }

    public static <T> @Nullable Matcher matchInList(List<T> list, Function<T, String> toStringFunction, Pattern pattern) {
        return RegexListUtils.matchInList(list, toStringFunction, pattern, 0);
    }

    public static <T> @Nullable Matcher matchInList(List<T> list, Function<T, String> toStringFunction, Pattern pattern, int startIndex) {
        if (startIndex >= list.size()) {
            return null;
        }
        Matcher matcher = pattern.matcher("");
        int listSize = list.size();
        for (int i = startIndex; i < listSize; ++i) {
            String string = toStringFunction.apply(list.get(i));
            if (!matcher.reset(string).matches()) continue;
            return matcher;
        }
        return null;
    }

    public static List<Matcher> matchInList(List<String> list, Pattern ... patterns) {
        return RegexListUtils.matchInList(list, Function.identity(), patterns);
    }

    public static <T> List<Matcher> matchInList(List<T> list, Function<T, String> toStringFunction, Pattern ... patterns) {
        return RegexListUtils.matchInList(list, toStringFunction, 0, patterns);
    }

    public static <T> List<Matcher> matchInList(List<T> list, Function<T, String> toStringFunction, int startIndex, Pattern ... patterns) {
        if (list.isEmpty()) {
            return List.of();
        }
        List<Matcher> matchers = Arrays.stream(patterns).map(p -> p.matcher("")).toList();
        int listSize = list.size();
        for (int i = startIndex; i < listSize; ++i) {
            String line = toStringFunction.apply(list.get(i));
            boolean allMatched = true;
            for (Matcher matcher : matchers) {
                if (matcher.hasMatch() || matcher.reset(line).matches()) continue;
                allMatched = false;
            }
            if (!allMatched) continue;
            return matchers;
        }
        return List.of();
    }
}

