/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.Locale;

public class RomanNumerals {
    private static final Int2ObjectMap<String> ROMAN_NUMERALS = Int2ObjectMaps.unmodifiable((Int2ObjectMap)new Int2ObjectLinkedOpenHashMap(new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1}, (Object[])new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"}));

    private RomanNumerals() {
    }

    private static int getDecimalValue(char romanChar) {
        return switch (romanChar) {
            case 'I' -> 1;
            case 'V' -> 5;
            case 'X' -> 10;
            case 'L' -> 50;
            case 'C' -> 100;
            case 'D' -> 500;
            case 'M' -> 1000;
            default -> 0;
        };
    }

    public static boolean isValidRomanNumeral(String romanNumeral) {
        if (romanNumeral == null || romanNumeral.isEmpty()) {
            return false;
        }
        for (int i = 0; i < romanNumeral.length(); ++i) {
            if (RomanNumerals.getDecimalValue(romanNumeral.charAt(i)) != 0) continue;
            return false;
        }
        return true;
    }

    public static int romanToDecimal(String romanNumeral) {
        if (romanNumeral == null || romanNumeral.isEmpty()) {
            return 0;
        }
        romanNumeral = romanNumeral.trim().toUpperCase(Locale.ENGLISH);
        int decimal = 0;
        int lastNumber = 0;
        for (int i = romanNumeral.length() - 1; i >= 0; --i) {
            char ch = romanNumeral.charAt(i);
            int number = RomanNumerals.getDecimalValue(ch);
            if (number == 0) {
                return 0;
            }
            decimal = number >= lastNumber ? decimal + number : decimal - number;
            lastNumber = number;
        }
        return decimal;
    }

    public static String decimalToRoman(int decimal) {
        if (decimal <= 0 || decimal >= 4000) {
            return "";
        }
        StringBuilder roman = new StringBuilder();
        for (Int2ObjectMap.Entry entry : ROMAN_NUMERALS.int2ObjectEntrySet()) {
            int value = entry.getIntKey();
            String numeral = (String)entry.getValue();
            while (decimal >= value) {
                roman.append(numeral);
                decimal -= value;
            }
        }
        return roman.toString();
    }
}

