/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.util.UndashedUuid;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.mixins.accessors.ChatListenerAccessor;
import de.hysky.skyblocker.skyblock.slayers.SlayerManager;
import de.hysky.skyblocker.utils.Area;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.purse.PurseChangeCause;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.azureaaron.hmapi.data.rank.MonthlyPackageRank;
import net.azureaaron.hmapi.data.rank.PackageRank;
import net.azureaaron.hmapi.data.rank.PlayerRank;
import net.azureaaron.hmapi.data.rank.RankType;
import net.azureaaron.hmapi.data.server.Environment;
import net.azureaaron.hmapi.events.HypixelPacketEvents;
import net.azureaaron.hmapi.network.HypixelNetworking;
import net.azureaaron.hmapi.network.packet.s2c.ErrorS2CPacket;
import net.azureaaron.hmapi.network.packet.s2c.HelloS2CPacket;
import net.azureaaron.hmapi.network.packet.s2c.HypixelS2CPacket;
import net.azureaaron.hmapi.network.packet.v1.s2c.LocationUpdateS2CPacket;
import net.azureaaron.hmapi.network.packet.v1.s2c.PlayerInfoS2CPacket;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3673;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7887;
import net.minecraft.class_8646;
import net.minecraft.class_9015;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final String ALTERNATE_HYPIXEL_ADDRESS = System.getProperty("skyblocker.alternateHypixelAddress", "");
    private static final String PROFILE_PREFIX = "Profile: ";
    private static final String PROFILE_MESSAGE_PREFIX = "\u00a7aYou are playing on profile: \u00a7e";
    public static final String PROFILE_ID_PREFIX = "Profile ID: ";
    private static final String PROFILE_ID_SUGGEST_PREFIX = "CLICK THIS TO SUGGEST IT IN CHAT";
    private static final Pattern PURSE = Pattern.compile("(Purse|Piggy): (?<purse>[0-9,.]+)( \\((?<change>[+\\-][0-9,.]+)\\))?");
    private static final class_7225.class_7874 LOOKUP = class_7887.method_46817();
    private static boolean isOnHypixel = false;
    private static boolean isOnSkyblock = false;
    private static RankType rank = PackageRank.NONE;
    private static Location location = Location.UNKNOWN;
    private static Area area = Area.UNKNOWN;
    private static String profile = "";
    private static String profileId = "";
    private static int profileIdRequest = 0;
    private static int profileSuggestionMessages = 0x3FFFFFFF;
    private static Environment environment = Environment.PRODUCTION;
    private static String server = "";
    private static String gameType = "";
    private static String locationRaw = "";
    private static String map = "";
    public static double purse = 0.0;
    public static final ObjectArrayList<class_2561> TEXT_SCOREBOARD = new ObjectArrayList();
    public static final ObjectArrayList<String> STRING_SCOREBOARD = new ObjectArrayList();

    public static boolean isOnHypixel() {
        return isOnHypixel;
    }

    public static boolean isOnSkyblock() {
        return isOnSkyblock;
    }

    public static boolean isInDungeons() {
        return location == Location.DUNGEON;
    }

    public static boolean isInCrystalHollows() {
        return location == Location.CRYSTAL_HOLLOWS;
    }

    public static boolean isInDwarvenMines() {
        return location == Location.DWARVEN_MINES || location == Location.GLACITE_MINESHAFTS;
    }

    public static boolean isInTheRift() {
        return location == Location.THE_RIFT;
    }

    public static boolean isInGarden() {
        return location == Location.GARDEN;
    }

    public static boolean isInTheEnd() {
        return location == Location.THE_END;
    }

    public static boolean isInKuudra() {
        return location == Location.KUUDRAS_HOLLOW;
    }

    public static boolean isInCrimson() {
        return location == Location.CRIMSON_ISLE;
    }

    public static boolean isInSpidersDen() {
        return location == Location.SPIDERS_DEN;
    }

    public static boolean isInFarm() {
        return location == Location.THE_FARMING_ISLAND;
    }

    public static boolean isInGalatea() {
        return location == Location.GALATEA;
    }

    public static boolean isInHub() {
        return location == Location.HUB;
    }

    public static boolean isInPrivateIsland() {
        return location == Location.PRIVATE_ISLAND;
    }

    public static boolean isInPark() {
        return location == Location.THE_PARK;
    }

    public static boolean isOnBingo() {
        return profile.endsWith("\u24b7");
    }

    public static String getProfile() {
        return profile;
    }

    public static String getProfileId() {
        return profileId;
    }

    public static Location getLocation() {
        return location;
    }

    public static Area getArea() {
        return area;
    }

    public static Environment getEnvironment() {
        return environment;
    }

    public static String getServer() {
        return server;
    }

    public static String getGameType() {
        return gameType;
    }

    public static String getLocationRaw() {
        return locationRaw;
    }

    public static String getMap() {
        return map;
    }

    public static RankType getRank() {
        return rank;
    }

    @Init
    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(Utils::onChatMessage);
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> Utils.onDisconnect());
        HypixelNetworking.registerToEvents((Object2IntMap)((Object2IntMap)class_156.method_654((Object)new Object2IntOpenHashMap(), map -> map.put((Object)LocationUpdateS2CPacket.ID, 1))));
        HypixelPacketEvents.HELLO.register(Utils::onPacket);
        HypixelPacketEvents.LOCATION_UPDATE.register(Utils::onPacket);
        HypixelPacketEvents.PLAYER_INFO.register(Utils::onPacket);
    }

    public static void update() {
        class_310 client = class_310.method_1551();
        Utils.updateScoreboard(client);
        Utils.updatePlayerPresence(client);
        Utils.updateFromPlayerList(client);
    }

    private static void updatePlayerPresence(class_310 client) {
        FabricLoader fabricLoader = FabricLoader.getInstance();
        if ((client.field_1687 == null || client.method_1542()) && fabricLoader.isDevelopmentEnvironment()) {
            isOnSkyblock = true;
        }
        if (fabricLoader.isDevelopmentEnvironment() || Utils.isConnectedToHypixel(client)) {
            if (!isOnHypixel) {
                isOnHypixel = true;
            }
        } else if (isOnHypixel) {
            isOnHypixel = false;
        }
    }

    private static boolean isConnectedToHypixel(class_310 client) {
        String serverAddress = client.method_1558() != null ? client.method_1558().field_3761.toLowerCase(Locale.ENGLISH) : "";
        String serverBrand = client.field_1724 != null && client.field_1724.field_3944 != null && client.field_1724.field_3944.method_52790() != null ? client.field_1724.field_3944.method_52790() : "";
        return !serverAddress.isEmpty() && serverAddress.equalsIgnoreCase(ALTERNATE_HYPIXEL_ADDRESS) || serverAddress.contains("hypixel.net") || serverAddress.contains("hypixel.io") || serverBrand.contains("Hypixel BungeeCord");
    }

    @Deprecated
    public static String getIslandArea() {
        try {
            for (String sidebarLine : STRING_SCOREBOARD) {
                if (!sidebarLine.contains("\u23e3") && !sidebarLine.contains("\u0444")) continue;
                return sidebarLine.strip();
            }
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.error("[Skyblocker] Failed to get location from sidebar", (Throwable)e);
        }
        return "Unknown";
    }

    public static double getPurse() {
        return purse;
    }

    public static int getBits() {
        int bits = 0;
        String bitsString = null;
        try {
            for (String sidebarLine : STRING_SCOREBOARD) {
                if (!sidebarLine.contains("Bits")) continue;
                bitsString = sidebarLine;
            }
            if (bitsString != null) {
                bits = Integer.parseInt(bitsString.replaceAll("[^0-9.]", "").strip());
            }
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.error("[Skyblocker] Failed to get bits from sidebar", (Throwable)e);
        }
        return bits;
    }

    private static void updateScoreboard(class_310 client) {
        try {
            TEXT_SCOREBOARD.clear();
            STRING_SCOREBOARD.clear();
            class_638 world = client.field_1687;
            if (world == null) {
                return;
            }
            class_269 scoreboard = world.method_8428();
            class_266 objective = scoreboard.method_1189((class_8646)class_8646.field_45176.apply(1));
            ObjectArrayList textLines = new ObjectArrayList();
            ObjectArrayList stringLines = new ObjectArrayList();
            for (class_9015 scoreHolder : scoreboard.method_1178()) {
                class_268 team;
                if (!scoreboard.method_1166(scoreHolder).containsKey((Object)objective) || (team = scoreboard.method_1164(scoreHolder.method_5820())) == null) continue;
                class_5250 textLine = class_2561.method_43473().method_10852((class_2561)team.method_1144().method_27661()).method_10852((class_2561)team.method_1136().method_27661());
                String strLine = team.method_1144().getString() + team.method_1136().getString();
                if (strLine.trim().isEmpty()) continue;
                String formatted = class_124.method_539((String)strLine);
                textLines.add((Object)textLine);
                stringLines.add((Object)formatted);
            }
            if (objective != null) {
                stringLines.add((Object)objective.method_1114().getString());
                textLines.add((Object)class_2561.method_43473().method_10852((class_2561)objective.method_1114().method_27661()));
                Collections.reverse(stringLines);
                Collections.reverse(textLines);
            }
            TEXT_SCOREBOARD.addAll((ObjectList)textLines);
            STRING_SCOREBOARD.addAll((ObjectList)stringLines);
            if (isOnSkyblock) {
                Utils.updatePurse();
                SlayerManager.checkSlayerQuest();
                Utils.updateArea();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static void updateArea() {
        Area oldArea = area;
        String areaName = Utils.getIslandArea().replaceAll("[\u23e3\u0444]", "").strip();
        if (!oldArea.equals(area = Area.from(areaName))) {
            ((SkyblockEvents.SkyblockAreaChange)SkyblockEvents.AREA_CHANGE.invoker()).onSkyblockAreaChange(area);
        }
    }

    public static void updatePurse() {
        STRING_SCOREBOARD.stream().filter(s -> s.contains("Piggy:") || s.contains("Purse:")).findFirst().ifPresent(purseString -> {
            Matcher matcher = PURSE.matcher((CharSequence)purseString);
            if (matcher.find()) {
                try {
                    double newPurse = Double.parseDouble(matcher.group("purse").replaceAll(",", ""));
                    double changeSinceLast = newPurse - purse;
                    if (changeSinceLast == 0.0) {
                        return;
                    }
                    ((SkyblockEvents.PurseChange)SkyblockEvents.PURSE_CHANGE.invoker()).onPurseChange(changeSinceLast, PurseChangeCause.getCause(changeSinceLast));
                    purse = newPurse;
                }
                catch (NumberFormatException e) {
                    LOGGER.error("[Skyblocker] Failed to parse purse string. Input: '{}'", purseString, (Object)e);
                }
            }
        });
    }

    private static void updateFromPlayerList(class_310 client) {
        if (client.method_1562() == null) {
            return;
        }
        for (class_640 playerListEntry : client.method_1562().method_2880()) {
            String name;
            if (playerListEntry.method_2971() == null || !(name = playerListEntry.method_2971().getString()).startsWith(PROFILE_PREFIX)) continue;
            profile = name.substring(PROFILE_PREFIX.length());
        }
    }

    private static void onDisconnect() {
        if (isOnSkyblock) {
            ((SkyblockEvents.SkyblockLeave)SkyblockEvents.LEAVE.invoker()).onSkyblockLeave();
        }
        isOnSkyblock = false;
        server = "";
        gameType = "";
        locationRaw = "";
        location = Location.UNKNOWN;
        area = Area.UNKNOWN;
        map = "";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void onPacket(HypixelS2CPacket packet) {
        HypixelS2CPacket hypixelS2CPacket = packet;
        Objects.requireNonNull(hypixelS2CPacket);
        HypixelS2CPacket hypixelS2CPacket2 = hypixelS2CPacket;
        int n = 0;
        block11: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{HelloS2CPacket.class, LocationUpdateS2CPacket.class, ErrorS2CPacket.class, PlayerInfoS2CPacket.class}, (Object)hypixelS2CPacket2, n)) {
                case 0: {
                    HelloS2CPacket helloS2CPacket = (HelloS2CPacket)hypixelS2CPacket2;
                    try {
                        Environment environment;
                        Environment serverEnvironment;
                        Utils.environment = serverEnvironment = (environment = helloS2CPacket.environment());
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    HypixelNetworking.sendPlayerInfoC2SPacket((int)1);
                    return;
                }
                case 1: {
                    String previousServerType;
                    Object mapName;
                    Object object;
                    LocationUpdateS2CPacket locationUpdateS2CPacket = (LocationUpdateS2CPacket)hypixelS2CPacket2;
                    {
                        object = locationUpdateS2CPacket.serverName();
                        Object serverName = object;
                        Object serverType = object = locationUpdateS2CPacket.serverType();
                        object = locationUpdateS2CPacket.lobbyName();
                        Object _lobbyName = object;
                        Object mode = object = locationUpdateS2CPacket.mode();
                        mapName = object = locationUpdateS2CPacket.map();
                        server = serverName;
                        previousServerType = gameType;
                        gameType = ((Optional)serverType).orElse("");
                        locationRaw = ((Optional)mode).orElse("");
                    }
                    location = Location.from(locationRaw);
                    map = ((Optional)mapName).orElse("");
                    ((SkyblockEvents.SkyblockLocationChange)SkyblockEvents.LOCATION_CHANGE.invoker()).onSkyblockLocationChange(location);
                    if (gameType.equals("SKYBLOCK")) {
                        isOnSkyblock = true;
                        Utils.tickProfileId();
                        if (previousServerType.equals("SKYBLOCK")) return;
                        ((SkyblockEvents.SkyblockJoin)SkyblockEvents.JOIN.invoker()).onSkyblockJoin();
                        return;
                    }
                    if (!previousServerType.equals("SKYBLOCK")) return;
                    isOnSkyblock = false;
                    ((SkyblockEvents.SkyblockLeave)SkyblockEvents.LEAVE.invoker()).onSkyblockLeave();
                    return;
                }
                case 2: {
                    PlayerInfoS2CPacket error;
                    PlayerInfoS2CPacket id;
                    PlayerInfoS2CPacket playerInfoS2CPacket;
                    Object object = (ErrorS2CPacket)hypixelS2CPacket2;
                    {
                        id = playerInfoS2CPacket = object.id();
                        error = playerInfoS2CPacket = object.reason();
                    }
                    if (!id.equals((Object)LocationUpdateS2CPacket.ID)) {
                        n = 3;
                        continue block11;
                    }
                    server = "";
                    gameType = "";
                    locationRaw = "";
                    location = Location.UNKNOWN;
                    map = "";
                    class_746 player = class_310.method_1551().field_1724;
                    if (player != null) {
                        player.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.utils.locationUpdateError").method_27692(class_124.field_1061)), false);
                    }
                    LOGGER.error("[Skyblocker] Failed to update your current location! Some features of the mod may not work correctly :( - Error: {}", (Object)error);
                    return;
                }
                case 3: {
                    PlayerRank monthlyPackageRank;
                    PlayerRank packageRank;
                    PlayerRank playerRank;
                    PlayerInfoS2CPacket playerInfoS2CPacket = (PlayerInfoS2CPacket)hypixelS2CPacket2;
                    {
                        Object object;
                        playerRank = object = playerInfoS2CPacket.playerRank();
                        packageRank = object = playerInfoS2CPacket.packageRank();
                        monthlyPackageRank = object = playerInfoS2CPacket.monthlyPackageRank();
                        Object _prefix = object = playerInfoS2CPacket.prefix();
                    }
                    rank = RankType.getEffectiveRank((PlayerRank)playerRank, (PackageRank)packageRank, (MonthlyPackageRank)monthlyPackageRank);
                    return;
                }
            }
            break;
        }
    }

    private static void tickProfileId() {
        ++profileIdRequest;
        Scheduler.INSTANCE.schedule(new Runnable(){
            private final int requestId = profileIdRequest;

            @Override
            public void run() {
                if (this.requestId == profileIdRequest) {
                    MessageScheduler.INSTANCE.sendMessageAfterCooldown("/profileid", true);
                    profileSuggestionMessages = 0;
                }
            }
        }, 160);
    }

    @Deprecated
    private static void parseLocRaw(String message) {
        JsonObject locRaw = JsonParser.parseString(message).getAsJsonObject();
        if (locRaw.has("server")) {
            server = locRaw.get("server").getAsString();
        }
        if (locRaw.has("gametype")) {
            gameType = locRaw.get("gametype").getAsString();
            isOnSkyblock = gameType.equals("SKYBLOCK");
        }
        if (locRaw.has("mode")) {
            locationRaw = locRaw.get("mode").getAsString();
            location = Location.from(locationRaw);
        } else {
            location = Location.UNKNOWN;
        }
        if (locRaw.has("map")) {
            map = locRaw.get("map").getAsString();
        }
    }

    public static boolean onChatMessage(class_2561 text, boolean overlay) {
        if (overlay) {
            return true;
        }
        String message = text.getString();
        if (message.startsWith("{\"server\":") && message.endsWith("}")) {
            Utils.parseLocRaw(message);
        }
        if (isOnSkyblock) {
            if (message.startsWith(PROFILE_MESSAGE_PREFIX)) {
                profile = message.substring(PROFILE_MESSAGE_PREFIX.length()).split("\u00a7b")[0];
            } else if (message.startsWith(PROFILE_ID_PREFIX)) {
                String prevProfileId = profileId;
                profileId = message.substring(PROFILE_ID_PREFIX.length());
                ++profileIdRequest;
                if (!prevProfileId.equals(profileId)) {
                    ((SkyblockEvents.ProfileChange)SkyblockEvents.PROFILE_CHANGE.invoker()).onSkyblockProfileChange(prevProfileId, profileId);
                }
            } else if (class_124.method_539((String)message).startsWith(PROFILE_ID_SUGGEST_PREFIX)) {
                int suggestions;
                return (suggestions = profileSuggestionMessages++) >= 2;
            }
        }
        return true;
    }

    public static void sendMessageToBypassEvents(class_2561 message) {
        class_310 client = class_310.method_1551();
        client.field_1705.method_1743().method_1812(message);
        ((ChatListenerAccessor)client.method_44714()).invokeLogSystemMessage(message, Instant.now());
        client.method_44713().method_47976(message);
    }

    public static UUID getUuid() {
        return class_310.method_1551().method_1548().method_44717();
    }

    public static String getUndashedUuid() {
        return UndashedUuid.toString((UUID)Utils.getUuid());
    }

    public static class_7225.class_7874 getRegistryWrapperLookup() {
        class_310 client = class_310.method_1551();
        return client != null && client.method_1562() != null && client.method_1562().method_29091() != null ? client.method_1562().method_29091() : LOOKUP;
    }

    public static OptionalInt parseInt(String input) {
        try {
            return OptionalInt.of(Integer.parseInt(input));
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }

    public static float getEyeHeight(class_1657 player) {
        if (player == null || !player.method_5715()) {
            return 1.62f;
        }
        return Utils.getLocation().isModern() ? 1.27f : 1.54f;
    }

    public static void checkForIllegalResourceModification(class_2960 id, class_3298 resource, String error) {
        if (!resource.method_14480().equals("skyblocker")) {
            LOGGER.error("!".repeat(50));
            LOGGER.error(LogUtils.FATAL_MARKER, error, (Object)id, (Object)resource.method_14480());
            LOGGER.error("!".repeat(50));
            class_3673.method_15973();
        }
    }
}

