/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.container;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.mixins.accessors.AbstractContainerScreenAccessor;
import de.hysky.skyblocker.skyblock.RaffleTaskHighlight;
import de.hysky.skyblocker.skyblock.accessories.AccessoriesContainerSolver;
import de.hysky.skyblocker.skyblock.accessories.newyearcakes.NewYearCakeBagHelper;
import de.hysky.skyblocker.skyblock.accessories.newyearcakes.NewYearCakesHelper;
import de.hysky.skyblocker.skyblock.auction.CopyUnderbidPrice;
import de.hysky.skyblocker.skyblock.bazaar.ReorderHelper;
import de.hysky.skyblocker.skyblock.chocolatefactory.ChocolateFactorySolver;
import de.hysky.skyblocker.skyblock.dungeon.CroesusHelper;
import de.hysky.skyblocker.skyblock.dungeon.CroesusProfit;
import de.hysky.skyblocker.skyblock.dungeon.SalvageHelper;
import de.hysky.skyblocker.skyblock.dungeon.SellableItemsHighlighter;
import de.hysky.skyblocker.skyblock.dungeon.terminal.ColorTerminal;
import de.hysky.skyblocker.skyblock.dungeon.terminal.LightsOnTerminal;
import de.hysky.skyblocker.skyblock.dungeon.terminal.OrderTerminal;
import de.hysky.skyblocker.skyblock.dungeon.terminal.SameColorTerminal;
import de.hysky.skyblocker.skyblock.dungeon.terminal.StartsWithTerminal;
import de.hysky.skyblocker.skyblock.dwarven.CommissionHighlight;
import de.hysky.skyblocker.skyblock.dwarven.fossil.FossilSolver;
import de.hysky.skyblocker.skyblock.end.EndStatsBestiaryUpdater;
import de.hysky.skyblocker.skyblock.experiment.ChronomatronSolver;
import de.hysky.skyblocker.skyblock.experiment.SuperpairsSolver;
import de.hysky.skyblocker.skyblock.experiment.UltrasequencerSolver;
import de.hysky.skyblocker.skyblock.galatea.TunerSolver;
import de.hysky.skyblocker.skyblock.garden.StereoHarmonyHelper;
import de.hysky.skyblocker.skyblock.hunting.HuntingBoxHelper;
import de.hysky.skyblocker.skyblock.item.AnvilHelper;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.BitsHelper;
import de.hysky.skyblocker.skyblock.slayers.features.RewardsHighlighter;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.container.ContainerAndInventorySolver;
import de.hysky.skyblocker.utils.container.ContainerSolver;
import de.hysky.skyblocker.utils.container.RegexContainerMatcher;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.List;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_476;
import org.jspecify.annotations.Nullable;

public class ContainerSolverManager {
    private static final ContainerSolver[] solvers = new ContainerSolver[]{new ColorTerminal(), new OrderTerminal(), new StartsWithTerminal(), new LightsOnTerminal(), CroesusHelper.INSTANCE, CroesusProfit.INSTANCE, new SalvageHelper(), new ChronomatronSolver(), new CommissionHighlight(), new SuperpairsSolver(), UltrasequencerSolver.INSTANCE, new NewYearCakeBagHelper(), NewYearCakesHelper.INSTANCE, ChocolateFactorySolver.INSTANCE, TunerSolver.INSTANCE, new ReorderHelper(), BitsHelper.INSTANCE, new RaffleTaskHighlight(), new FossilSolver(), SameColorTerminal.INSTANCE, new CopyUnderbidPrice(), new HuntingBoxHelper(), new SellableItemsHighlighter(), StereoHarmonyHelper.INSTANCE, new EndStatsBestiaryUpdater(), AccessoriesContainerSolver.INSTANCE, new AnvilHelper(), new RewardsHighlighter()};
    private static @Nullable ContainerSolver currentSolver = null;
    private static @Nullable List<ColorHighlight> highlights;
    private static int screenId;

    private ContainerSolverManager() {
    }

    public static @Nullable ContainerSolver getCurrentSolver() {
        return currentSolver;
    }

    @Init
    public static void init() {
        ScreenEvents.BEFORE_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (Utils.isOnSkyblock() && screen instanceof class_476) {
                class_476 genericContainerScreen = (class_476)screen;
                ScreenEvents.remove((class_437)screen).register(screen1 -> ContainerSolverManager.clearScreen());
                ContainerSolverManager.onSetScreen(genericContainerScreen);
            } else {
                ContainerSolverManager.clearScreen();
            }
        });
    }

    public static void onSetScreen(class_476 screen) {
        String screenName = screen.method_25440().getString();
        for (ContainerSolver solver : solvers) {
            RegexContainerMatcher containerMatcher;
            if (!solver.isEnabled() || (!(solver instanceof RegexContainerMatcher) || !(containerMatcher = (RegexContainerMatcher)((Object)solver)).test(screenName)) && !solver.test((class_437)screen)) continue;
            ++screenId;
            currentSolver = solver;
            currentSolver.start(screen);
            ContainerSolverManager.markHighlightsDirty();
            return;
        }
        ContainerSolverManager.clearScreen();
    }

    public static void clearScreen() {
        if (currentSolver != null) {
            currentSolver.reset();
            currentSolver = null;
        }
    }

    public static void markHighlightsDirty() {
        highlights = null;
        if (currentSolver != null) {
            currentSolver.markDirty();
        }
    }

    public static boolean onSlotClick(int slot, class_1799 stack, int button) {
        return currentSolver != null && currentSolver.onClickSlot(slot, stack, screenId, button);
    }

    public static void onDraw(class_332 context, class_465<class_1707> handledScreen, List<class_1735> slots) {
        if (currentSolver == null) {
            return;
        }
        context.method_51448().pushMatrix();
        context.method_51448().translate((float)((AbstractContainerScreenAccessor)handledScreen).getX(), (float)((AbstractContainerScreenAccessor)handledScreen).getY());
        if (highlights == null) {
            highlights = currentSolver.getColors(ContainerSolverManager.slotMap(currentSolver instanceof ContainerAndInventorySolver ? slots : slots.subList(0, ((class_1707)handledScreen.method_17577()).method_17388() * 9)));
        }
        for (ColorHighlight highlight : highlights) {
            class_1735 slot = slots.get(highlight.slot());
            int color = highlight.color();
            context.method_25294(slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, color);
        }
        context.method_51448().popMatrix();
    }

    public static Int2ObjectMap<class_1799> slotMap(List<class_1735> slots) {
        Int2ObjectRBTreeMap slotMap = new Int2ObjectRBTreeMap();
        for (int i = 0; i < slots.size(); ++i) {
            slotMap.put(i, (Object)slots.get(i).method_7677());
        }
        return slotMap;
    }

    static {
        screenId = 0;
    }
}

