/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.backup.ConfigBackupManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonData<T> {
    public static final class_370.class_9037 ERROR_TOAST_ID = new class_370.class_9037(10000L);
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonData.class);
    private final Path file;
    private final Codec<T> codec;
    private final boolean compressed;
    private final boolean loadAsync;
    private final boolean saveAsync;
    private T data;
    private @Nullable CompletableFuture<Void> loaded;

    public JsonData(Path file, Codec<T> codec, T defaultValue) {
        this(file, codec, defaultValue, false);
    }

    public JsonData(Path file, Codec<T> codec, T defaultValue, boolean loadAsync, boolean saveAsync) {
        this(file, codec, defaultValue, false, loadAsync, saveAsync);
    }

    public JsonData(Path file, Codec<T> codec, T defaultValue, boolean compressed) {
        this(file, codec, defaultValue, compressed, true, true);
    }

    public JsonData(Path file, Codec<T> codec, T defaultValue, boolean compressed, boolean loadAsync, boolean saveAsync) {
        this.file = file;
        this.codec = codec;
        this.data = defaultValue;
        this.compressed = compressed;
        this.loadAsync = loadAsync;
        this.saveAsync = saveAsync;
    }

    public CompletableFuture<Void> init() {
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> this.save().join());
        return this.load();
    }

    public CompletableFuture<Void> load() {
        if (this.loadAsync) {
            this.loaded = CompletableFuture.runAsync(this::loadInternal, Executors.newVirtualThreadPerTaskExecutor());
        } else {
            this.loadInternal();
            this.loaded = CompletableFuture.completedFuture(null);
        }
        return this.loaded;
    }

    private void loadInternal() {
        boolean createBackup = false;
        try (BufferedReader reader2 = Files.newBufferedReader(this.file);){
            DataResult parsed = this.codec.parse((DynamicOps)(this.compressed ? JsonOps.COMPRESSED : JsonOps.INSTANCE), (Object)JsonParser.parseReader(reader2));
            parsed.resultOrPartial(s -> LOGGER.error("[Skyblocker Json Data] Failed to parse data from file: `{}`. {}", (Object)this.file, s)).ifPresent(t -> {
                this.data = t;
            });
            createBackup = parsed.isError();
        }
        catch (NoSuchFileException reader2) {
        }
        catch (Exception e) {
            createBackup = true;
            LOGGER.error("[Skyblocker Json Data] Failed to load data from file: `{}`", (Object)this.file, (Object)e);
        }
        if (createBackup) {
            class_310.method_1551().method_1566().method_1999((class_368)class_370.method_29047((class_310)class_310.method_1551(), (class_370.class_9037)ERROR_TOAST_ID, (class_2561)class_2561.method_43470((String)"Skyblocker Config Error"), (class_2561)class_2561.method_43470((String)("Failed to load '" + String.valueOf(FabricLoader.getInstance().getConfigDir().relativize(this.file)) + "'")).method_27693("\n").method_27693("See logs for details. A backup of the file has been made.")));
            try {
                String newFileName;
                String fileName = this.file.getFileName().toString();
                int extensionIndex = fileName.lastIndexOf(46);
                if (extensionIndex >= 0) {
                    String extension = fileName.substring(extensionIndex);
                    newFileName = fileName.substring(0, extensionIndex) + "_" + ConfigBackupManager.FORMATTER.format(LocalDateTime.now()) + extension;
                } else {
                    LOGGER.warn("[Skyblocker Json Data] No extension? {}", (Object)this.file);
                    newFileName = fileName + "_" + ConfigBackupManager.FORMATTER.format(LocalDateTime.now());
                }
                Files.copy(this.file, this.file.getParent().resolve(newFileName), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOGGER.error("[Skyblocker Json Data] Failed to create backup for file: `{}`", (Object)this.file, (Object)e);
            }
        }
    }

    public CompletableFuture<Void> save() {
        if (this.saveAsync && class_310.method_1551().method_22108()) {
            return CompletableFuture.runAsync(this::saveInternal, Executors.newVirtualThreadPerTaskExecutor());
        }
        this.saveInternal();
        return CompletableFuture.completedFuture(null);
    }

    private void saveInternal() {
        if (this.loaded == null) {
            LOGGER.error("[Skyblocker Json Data] Save data called when loading has not started for file `{}`. This will override the contents of the file with the default value.", (Object)this.file);
        } else if (!this.isLoaded()) {
            LOGGER.warn("[Skyblocker Json Data] Save data called when loading has not finished for file `{}`. Blocking until data is loaded.", (Object)this.file);
            this.loaded.join();
        }
        try {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Json Data] Failed to create directories for file: `{}`", (Object)this.file, (Object)e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            SkyblockerMod.GSON.toJson((JsonElement)this.codec.encodeStart((DynamicOps)(this.compressed ? JsonOps.COMPRESSED : JsonOps.INSTANCE), this.data).getOrThrow(), (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Json Data] Failed to save data to file: `{}`", (Object)this.file, (Object)e);
        }
    }

    @Deprecated(forRemoval=true)
    public boolean isEmpty() {
        return !this.isLoaded();
    }

    public boolean isLoaded() {
        return this.loaded != null && this.loaded.isDone();
    }

    public T getData() {
        if (this.loaded == null) {
            LOGGER.error("[Skyblocker Json Data] Get data called when loading has not started for file `{}`. Returning default value.", (Object)this.file);
        } else if (!this.isLoaded()) {
            LOGGER.warn("[Skyblocker Json Data] Get data called when loading has not finished for file `{}`. Blocking until data is loaded.", (Object)this.file);
            this.loaded.join();
        }
        return this.data;
    }

    public T setData(T data) {
        T oldData = this.data;
        this.data = data;
        return oldData;
    }
}

