/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.data;

import com.mojang.serialization.Codec;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.JsonData;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_4844;
import org.jspecify.annotations.Nullable;

public class ProfiledData<T>
extends JsonData<Object2ObjectOpenHashMap<UUID, Object2ObjectOpenHashMap<String, T>>> {
    public ProfiledData(Path file, Codec<T> codec) {
        this(file, codec, false);
    }

    public ProfiledData(Path file, Codec<T> codec, boolean compressed) {
        this(file, codec, compressed, true, true);
    }

    public ProfiledData(Path file, Codec<T> codec, boolean loadAsync, boolean saveAsync) {
        this(file, codec, false, loadAsync, saveAsync);
    }

    public ProfiledData(Path file, Codec<T> codec, boolean compressed, boolean loadAsync, boolean saveAsync) {
        super(file, Codec.unboundedMap((Codec)class_4844.field_40825, (Codec)Codec.unboundedMap((Codec)Codec.STRING, codec).xmap(Object2ObjectOpenHashMap::new, Function.identity())).xmap(Object2ObjectOpenHashMap::new, Function.identity()), new Object2ObjectOpenHashMap(), compressed, loadAsync, saveAsync);
    }

    public boolean containsKey() {
        return this.containsKey(Utils.getUuid(), Utils.getProfileId());
    }

    public boolean containsKey(UUID uuid, String profileId) {
        return this.getPlayerData(uuid).containsKey(profileId);
    }

    public @Nullable T get() {
        return this.get(Utils.getUuid(), Utils.getProfileId());
    }

    public @Nullable T get(UUID uuid, String profileId) {
        return this.getPlayerData(uuid).get(profileId);
    }

    public @Nullable T put(T value) {
        return this.put(Utils.getUuid(), Utils.getProfileId(), value);
    }

    public @Nullable T put(UUID uuid, String profileId, T value) {
        return this.getPlayerData(uuid).put(profileId, value);
    }

    public @Nullable T putIfAbsent(T value) {
        return this.putIfAbsent(Utils.getUuid(), Utils.getProfileId(), value);
    }

    public @Nullable T putIfAbsent(UUID uuid, String profileId, T value) {
        return this.getPlayerData(uuid).putIfAbsent(profileId, value);
    }

    public @Nullable T computeIfAbsent(Supplier<T> valueSupplier) {
        return this.computeIfAbsent(Utils.getUuid(), Utils.getProfileId(), valueSupplier);
    }

    public @Nullable T computeIfAbsent(UUID uuid, String profileId, Supplier<T> valueSupplier) {
        return (T)this.getPlayerData(uuid).computeIfAbsent(profileId, _profileId -> valueSupplier.get());
    }

    public @Nullable T remove() {
        return this.remove(Utils.getUuid(), Utils.getProfileId());
    }

    public @Nullable T remove(UUID uuid, String profileId) {
        return this.getPlayerData(uuid).remove(profileId);
    }

    private Map<String, T> getPlayerData(UUID uuid) {
        return (Map)((Object2ObjectOpenHashMap)this.getData()).computeIfAbsent((Object)uuid, _uuid -> new Object2ObjectOpenHashMap());
    }
}

