/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.mayor;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.utils.Http;
import de.hysky.skyblocker.utils.SkyblockTime;
import de.hysky.skyblocker.utils.mayor.Mayor;
import de.hysky.skyblocker.utils.mayor.Minister;
import de.hysky.skyblocker.utils.mayor.Perk;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MayorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MayorUtils.class);
    private static Mayor mayor = Mayor.EMPTY;
    private static Minister minister = Minister.EMPTY;
    private static List<PerkOverride> mayorPerkOverrides = List.of();
    private static boolean mayorTickScheduled = false;
    private static int mayorTickRetryAttempts = 0;

    private MayorUtils() {
    }

    public static List<String> getActivePerks() {
        Stream<String> mayorPerks = mayor.perks().stream().map(Perk::name);
        Stream<String> ministerPerk = Stream.of(minister.perk().name());
        Stream<String> overriddenMayorPerks = mayorPerkOverrides.stream().filter(PerkOverride::isActive).map(PerkOverride::perk);
        return Stream.concat(Stream.concat(mayorPerks, ministerPerk), overriddenMayorPerks).toList();
    }

    @Init
    public static void init() {
        SkyblockEvents.JOIN.register(() -> {
            if (!mayorTickScheduled) {
                MayorUtils.tickMayorCache();
                MayorUtils.scheduleMayorTick();
                mayorTickScheduled = true;
            }
        });
    }

    private static void scheduleMayorTick() {
        long currentYearMillis = SkyblockTime.getSkyblockMillis() % 446400000L;
        long millisUntilNextMayorChange = currentYearMillis > 105600000L ? 446400000L - currentYearMillis + 105600000L : 105600000L - currentYearMillis;
        RenderHelper.runOnRenderThread(() -> Scheduler.INSTANCE.schedule(MayorUtils::tickMayorCache, (int)(millisUntilNextMayorChange / 50L) + 6000));
    }

    private static void tickMayorCache() {
        MayorUtils.loadMayorPerkOverrides();
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Http.ApiResponse response = Http.sendCacheableGetRequest("https://api.hypixel.net/v2/resources/skyblock/election", null);
            try {
                if (!response.ok()) {
                    throw new RuntimeException("Received bad http response: " + response.statusCode() + " " + response.content());
                }
                JsonObject json = JsonParser.parseString(response.content()).getAsJsonObject();
                if (!json.get("success").getAsBoolean()) {
                    throw new RuntimeException("Request failed!");
                }
                JsonObject mayorObject = json.getAsJsonObject("mayor");
                if (mayorObject == null) {
                    throw new RuntimeException("No mayor object found in response!");
                }
                JsonObject jsonObject = mayorObject;
                if (response != null) {
                    response.close();
                }
                return jsonObject;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, Executors.newVirtualThreadPerTaskExecutor()).exceptionally(throwable -> {
            LOGGER.error("[Skyblocker] Failed to get mayor status!", throwable.getCause());
            if (mayorTickRetryAttempts < 5) {
                int minutes = 5 << mayorTickRetryAttempts;
                ++mayorTickRetryAttempts;
                LOGGER.warn("[Skyblocker] Retrying in {} minutes.", (Object)minutes);
                RenderHelper.runOnRenderThread(() -> Scheduler.INSTANCE.schedule(MayorUtils::tickMayorCache, minutes * 60 * 20));
            } else {
                LOGGER.warn("[Skyblocker] Failed to get mayor status after 5 retries! Stopping further retries until next reboot.");
            }
            return new JsonObject();
        })).thenAccept(result -> {
            if (!result.isEmpty()) {
                try {
                    mayor = (Mayor)Mayor.CODEC.parse((DynamicOps)JsonOps.INSTANCE, result).setPartial((Object)Mayor.EMPTY).resultOrPartial(error -> LOGGER.warn("[Skyblocker] Failed to parse mayor status from the API response. Error: {}", error)).get();
                }
                catch (Exception e) {
                    LOGGER.warn("[Skyblocker] Failed to parse mayor status from the API response.", (Throwable)e);
                    mayor = Mayor.EMPTY;
                }
                try {
                    JsonObject ministerObject = result.getAsJsonObject("minister");
                    if (ministerObject != null) {
                        minister = (Minister)Minister.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)ministerObject).setPartial((Object)Minister.EMPTY).resultOrPartial(error -> LOGGER.warn("[Skyblocker] Failed to parse minister status from the API response. Error: {}", error)).get();
                    } else {
                        LOGGER.info("[Skyblocker] No minister data found for the current mayor.");
                        minister = Minister.EMPTY;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("[Skyblocker] Failed to parse minister status from the API response.", (Throwable)e);
                    minister = Minister.EMPTY;
                }
                LOGGER.info("[Skyblocker] Mayor set to {}, minister set to {}.", (Object)mayor, (Object)minister);
                MayorUtils.scheduleMayorTick();
                ((SkyblockEvents.MayorChange)SkyblockEvents.MAYOR_CHANGE.invoker()).onMayorChange();
            }
        });
    }

    private static void loadMayorPerkOverrides() {
        CompletableFuture.runAsync(() -> {
            try {
                String response = Http.sendGetRequest("https://hysky.de/api/mayorperkoverrides");
                mayorPerkOverrides = (List)PerkOverride.LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString(response)).getOrThrow();
                LOGGER.info("[Skyblocker] Loaded {} mayor perk overrides.", (Object)mayorPerkOverrides.size());
                ((SkyblockEvents.MayorChange)SkyblockEvents.MAYOR_CHANGE.invoker()).onMayorChange();
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker] Failed to load mayor perk overrides.", (Throwable)e);
            }
        }, Executors.newVirtualThreadPerTaskExecutor());
    }

    private record PerkOverride(String perk, long from, long to) {
        private static final Codec<PerkOverride> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("perk").forGetter(PerkOverride::perk), (App)Codec.LONG.fieldOf("from").forGetter(PerkOverride::from), (App)Codec.LONG.fieldOf("to").forGetter(PerkOverride::to)).apply((Applicative)instance, PerkOverride::new));
        private static final Codec<List<PerkOverride>> LIST_CODEC = CODEC.listOf();

        public boolean isActive() {
            long now = System.currentTimeMillis();
            return now >= this.from && now <= this.to;
        }
    }
}

