/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render;

import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import de.hysky.skyblocker.mixins.accessors.OutlineBufferSourceAccessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMaps;
import java.util.SequencedMap;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4618;
import net.minecraft.class_9799;

public class GlowRenderer
implements AutoCloseable {
    private static GlowRenderer instance = null;
    private final class_310 client = class_310.method_1551();
    private final class_4618 glowOutlineVertexConsumers = (class_4618)class_156.method_654((Object)new class_4618(), outlineVertexConsumers -> ((OutlineBufferSourceAccessor)outlineVertexConsumers).setOutlineBufferSource(new GlowVertexConsumerProvider(new class_9799(1536))));
    private GpuTexture glowDepthTexture;
    private GpuTextureView glowDepthTextureView;
    private boolean isRenderingGlow = false;

    private GlowRenderer() {
    }

    public static GlowRenderer getInstance() {
        if (instance == null) {
            instance = new GlowRenderer();
        }
        return instance;
    }

    public class_4618 getGlowVertexConsumers() {
        return this.glowOutlineVertexConsumers;
    }

    public void updateGlowDepthTexDepth() {
        this.tryUpdateDepthTexture();
        RenderSystem.getDevice().createCommandEncoder().copyTextureToTexture(this.client.method_1522().method_30278(), this.glowDepthTexture, 0, 0, 0, 0, 0, this.glowDepthTexture.getWidth(0), this.glowDepthTexture.getHeight(0));
    }

    private void startRenderingGlow() {
        this.isRenderingGlow = true;
        RenderSystem.outputDepthTextureOverride = this.glowDepthTextureView;
    }

    private void stopRenderingGlow() {
        this.isRenderingGlow = false;
        RenderSystem.outputDepthTextureOverride = null;
    }

    public static boolean isRenderingGlow() {
        return instance != null ? GlowRenderer.instance.isRenderingGlow : false;
    }

    private void tryUpdateDepthTexture() {
        int neededWidth = this.client.method_22683().method_4489();
        int neededHeight = this.client.method_22683().method_4506();
        if (this.glowDepthTexture == null || this.glowDepthTexture.getWidth(0) != neededWidth || this.glowDepthTexture.getHeight(0) != neededHeight) {
            GpuDevice device = RenderSystem.getDevice();
            if (this.glowDepthTexture != null) {
                this.glowDepthTexture.close();
                this.glowDepthTextureView.close();
            }
            this.glowDepthTexture = device.createTexture(() -> "Skyblocker Glow Depth Tex", 13, TextureFormat.DEPTH32, neededWidth, neededHeight, 1, 1);
            this.glowDepthTextureView = device.createTextureView(this.glowDepthTexture);
        }
    }

    @Override
    public void close() {
        if (this.glowDepthTexture != null) {
            this.glowDepthTexture.close();
            this.glowDepthTextureView.close();
        }
    }

    private static class GlowVertexConsumerProvider
    extends class_4597.class_4598 {
        protected GlowVertexConsumerProvider(class_9799 allocator) {
            super(allocator, (SequencedMap)Object2ObjectSortedMaps.emptyMap());
        }

        public class_4588 method_73477(class_1921 renderLayer) {
            if (this.field_52157.get(renderLayer) != null && !renderLayer.method_43332()) {
                GlowRenderer.getInstance().startRenderingGlow();
                class_4588 buffer = super.method_73477(renderLayer);
                GlowRenderer.getInstance().stopRenderingGlow();
                return buffer;
            }
            return super.method_73477(renderLayer);
        }

        public void method_22994(class_1921 layer) {
            GlowRenderer.getInstance().startRenderingGlow();
            super.method_22994(layer);
            GlowRenderer.getInstance().stopRenderingGlow();
        }
    }
}

