/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import de.hysky.skyblocker.compatibility.CaxtonCompatibility;
import de.hysky.skyblocker.compatibility.ModernUICompatibility;
import de.hysky.skyblocker.mixins.accessors.GuiGraphicsInvoker;
import de.hysky.skyblocker.utils.render.SkyblockerRenderPipelines;
import de.hysky.skyblocker.utils.render.TexturePool;
import de.hysky.skyblocker.utils.render.gui.state.CustomShapeGuiElementRenderState;
import de.hysky.skyblocker.utils.render.gui.state.EquipmentGuiElementRenderState;
import de.hysky.skyblocker.utils.render.gui.state.HorizontalGradientGuiElementRenderState;
import de.hysky.skyblocker.utils.render.gui.state.OutlinedTextGuiElementRenderState;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_10186;
import net.minecraft.class_10197;
import net.minecraft.class_10394;
import net.minecraft.class_1041;
import net.minecraft.class_1068;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_11247;
import net.minecraft.class_11786;
import net.minecraft.class_12137;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_3879;
import net.minecraft.class_5321;
import net.minecraft.class_5481;
import net.minecraft.class_7532;
import net.minecraft.class_8685;
import net.minecraft.class_9296;
import net.minecraft.class_9848;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Vector2f;

public class HudHelper {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final TexturePool BLIT_TEXTURE_POOL = TexturePool.create("Blit Pool", 4, 5, TextureFormat.RGBA8);

    public static void renderNineSliceColored(class_332 context, class_2960 texture, int x, int y, int width, int height, int argb) {
        context.method_52707(class_10799.field_56883, texture, x, y, width, height, argb);
    }

    public static void renderNineSliceColored(class_332 context, class_2960 texture, int x, int y, int width, int height, Color color) {
        HudHelper.renderNineSliceColored(context, texture, x, y, width, height, class_9848.method_61324((int)color.getAlpha(), (int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()));
    }

    public static void drawHorizontalGradient(class_332 context, float startX, float startY, float endX, float endY, int colorStart, int colorEnd) {
        context.field_59826.method_70919((class_11244)new HorizontalGradientGuiElementRenderState(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)context.method_51448()), (int)startX, (int)startY, (int)endX, (int)endY, colorStart, colorEnd, context.field_44659.method_70863()));
    }

    public static void drawBorder(class_332 context, int x, int y, int width, int height, int color) {
        context.method_25294(x, y, x + width, y + 1, color);
        context.method_25294(x, y + height - 1, x + width, y + height, color);
        context.method_25294(x, y + 1, x + 1, y + height - 1, color);
        context.method_25294(x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    public static void drawCustomShape(class_332 context, List<Vector2f> vertices, int color) {
        context.field_59826.method_70919((class_11244)new CustomShapeGuiElementRenderState(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)context.method_51448()), vertices, color, context.field_44659.method_70863()));
    }

    public static void drawPlayerHead(class_332 context, int x, int y, int size, UUID uuid) {
        class_8685 texture = CLIENT.method_73362().method_74320(class_9296.method_73312((UUID)uuid)).getNow(Optional.empty()).map(class_11786.class_11787::method_73503).orElseGet(() -> class_1068.method_4648((UUID)uuid));
        class_7532.method_52722((class_332)context, (class_8685)texture, (int)x, (int)y, (int)size);
    }

    public static <S> void drawEquipment(class_332 context, class_10197 equipmentRenderer, class_10186.class_10190 layerType, class_5321<class_10394> assetKey, class_3879<S> model, S state, class_1799 stack, int x1, int y1, int x2, int y2, float rotation, float scale, float offset) {
        EquipmentGuiElementRenderState<S> renderState = new EquipmentGuiElementRenderState<S>(equipmentRenderer, layerType, assetKey, model, state, stack, x1, y1, x2, y2, rotation, scale, offset, context.field_44659.method_70863());
        context.field_59826.method_70922(renderState);
    }

    public static void drawOutlinedText(class_332 context, class_2561 text, int x, int y, int color, int outlineColor) {
        class_5481 orderedText = text.method_30937();
        HudHelper.drawOutlinedText(context, orderedText, ModernUICompatibility.MODERNUI_ENABLED ? class_2561.method_43470((String)text.getString()).method_30937() : orderedText, x, y, color, outlineColor);
    }

    public static void drawOutlinedText(class_332 context, class_5481 text, int x, int y, int color, int outlineColor) {
        HudHelper.drawOutlinedText(context, text, text, x, y, color, outlineColor);
    }

    private static void drawOutlinedText(class_332 context, class_5481 text, class_5481 outlineText, int x, int y, int color, int outlineColor) {
        if (CaxtonCompatibility.drawOutlinedText(context, text, x, y, color, outlineColor)) {
            return;
        }
        if (ModernUICompatibility.drawOutlinedText(context, text, outlineText, x, y, color, outlineColor)) {
            return;
        }
        OutlinedTextGuiElementRenderState renderState = new OutlinedTextGuiElementRenderState(HudHelper.CLIENT.field_1772, text, new Matrix3x2f((Matrix3x2fc)context.method_51448()), x, y, color, outlineColor, false, false, context.field_44659.method_70863());
        context.field_59826.method_70921((class_11247)renderState);
    }

    public static void submitBlurredRectangle(class_332 graphics, int x0, int y0, int x1, int y1, int radius) {
        class_276 mainRenderTarget = CLIENT.method_1522();
        int requiredWidth = mainRenderTarget.field_1482;
        int requiredHeight = mainRenderTarget.field_1481;
        int index = BLIT_TEXTURE_POOL.getNextAvailableIndex(requiredWidth, requiredHeight);
        GpuTexture blitTexture = BLIT_TEXTURE_POOL.getTexture(index);
        GpuTextureView blitTextureView = BLIT_TEXTURE_POOL.getTextureView(index);
        class_12137 sampler = RenderSystem.getSamplerCache().method_75294(FilterMode.LINEAR);
        int vertexColour = class_9848.method_61323((int)radius, (int)255, (int)255);
        RenderSystem.getDevice().createCommandEncoder().copyTextureToTexture(mainRenderTarget.method_30277(), blitTexture, 0, 0, 0, 0, 0, requiredWidth, requiredHeight);
        ((GuiGraphicsInvoker)graphics).invokeSubmitColoredRectangle(SkyblockerRenderPipelines.BLURRED_RECTANGLE, class_11231.method_70900((GpuTextureView)blitTextureView, (class_12137)sampler), x0, y0, x1, y1, vertexColour, null);
    }

    public static boolean pointIsInArea(double x, double y, double x1, double y1, double x2, double y2) {
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    public static boolean hasShiftDown() {
        return class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)340) || class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)344);
    }

    public static void close() {
        BLIT_TEXTURE_POOL.close();
    }
}

