/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render;

import com.mojang.blaze3d.systems.RenderSystem;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.utils.render.Renderer;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollectorImpl;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldExtractionContext;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.minecraft.class_10209;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_9779;
import org.jspecify.annotations.Nullable;

public class RenderHelper {
    private static final class_310 CLIENT = class_310.method_1551();
    private static PrimitiveCollectorImpl collector;

    @Init
    public static void init() {
        WorldRenderEvents.END_EXTRACTION.register(RenderHelper::startExtraction);
        WorldRenderEvents.BEFORE_ENTITIES.register(RenderHelper::submitVanillaSubmittables);
        WorldRenderEvents.END_MAIN.register(RenderHelper::executeDraws);
    }

    private static void startExtraction(WorldExtractionContext context) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("skyblockerPrimitiveCollection");
        collector = new PrimitiveCollectorImpl(context.worldState(), context.frustum());
        ((WorldRenderExtractionCallback)WorldRenderExtractionCallback.EVENT.invoker()).onExtract(collector);
        collector.endCollection();
        profiler.method_15407();
    }

    private static void submitVanillaSubmittables(WorldRenderContext context) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("skyblockerSubmitVanillaSubmittables");
        collector.dispatchVanillaSubmittables(context.worldState(), context.commandQueue());
        profiler.method_15407();
    }

    private static void executeDraws(WorldRenderContext context) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("skyblockerSubmitPrimitives");
        collector.dispatchPrimitivesToRenderers(context.worldState().field_63082);
        collector = null;
        profiler.method_15407();
        profiler.method_15396("skyblockerExecuteDraws");
        Renderer.executeDraws();
        profiler.method_15407();
    }

    public static void runOnRenderThread(Runnable runnable) {
        if (RenderSystem.isOnRenderThread()) {
            runnable.run();
        } else {
            CLIENT.execute(runnable);
        }
    }

    public static void assertOnRenderThread(String message) {
        if (!RenderSystem.isOnRenderThread()) {
            throw new IllegalStateException(message);
        }
    }

    public static class_9779 getTickCounter() {
        return CLIENT.method_61966();
    }

    public static class_4184 getCamera() {
        return RenderHelper.CLIENT.field_1773.method_19418();
    }

    public static @Nullable class_238 getBlockBoundingBox(class_638 world, class_2338 pos) {
        return RenderHelper.getBlockBoundingBox(world, world.method_8320(pos), pos);
    }

    public static @Nullable class_238 getBlockBoundingBox(class_638 world, class_2680 state, class_2338 pos) {
        class_265 shape = state.method_26218((class_1922)world, pos).method_52620();
        return shape.method_1110() ? null : shape.method_1107().method_996(pos);
    }
}

