/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import java.util.Arrays;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldTerrainRenderContext;
import org.jspecify.annotations.Nullable;

public record TexturePool(String name, int size, @GpuTexture.class_12115 int usage, TextureFormat format, @Nullable GpuTexture[] textures, @Nullable GpuTextureView[] textureViews, boolean[] usedSlots) implements AutoCloseable
{
    public TexturePool(String name, int size, @GpuTexture.class_12115 int usage, TextureFormat format, @Nullable GpuTexture[] textures, @Nullable GpuTextureView[] textureViews, boolean[] usedSlots) {
        WorldRenderEvents.START_MAIN.register(this::clearUnusedTextures);
        this.name = name;
        this.size = size;
        this.usage = usage;
        this.format = format;
        this.textures = textures;
        this.textureViews = textureViews;
        this.usedSlots = usedSlots;
    }

    public static TexturePool create(String name, int size, @GpuTexture.class_12115 int usage, TextureFormat format) {
        return new TexturePool(name, size, usage, format, new GpuTexture[size], new GpuTextureView[size], new boolean[size]);
    }

    private void clearUnusedTextures(WorldTerrainRenderContext context) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.usedSlots()[i]) continue;
            GpuTexture texture = this.textures()[i];
            GpuTextureView textureView = this.textureViews()[i];
            if (texture == null || textureView == null) continue;
            texture.close();
            textureView.close();
            this.textures()[i] = null;
            this.textureViews()[i] = null;
        }
        Arrays.fill(this.usedSlots(), false);
    }

    public int getNextAvailableIndex(int requiredWidth, int requiredHeight) {
        for (int i = 0; i < this.size(); ++i) {
            boolean textureSizesMatch;
            if (this.usedSlots()[i]) continue;
            GpuTexture texture = this.textures()[i];
            GpuTextureView textureView = this.textureViews()[i];
            boolean textureExists = texture != null && textureView != null;
            boolean bl = textureSizesMatch = textureExists && texture.getWidth(0) == requiredWidth && texture.getHeight(0) == requiredHeight;
            if (textureSizesMatch) {
                this.usedSlots()[i] = true;
                return i;
            }
            if (textureExists) continue;
            GpuTexture newTexture = RenderSystem.getDevice().createTexture(this.name() + " " + i, this.usage(), this.format(), requiredWidth, requiredHeight, 1, 1);
            GpuTextureView newTextureView = RenderSystem.getDevice().createTextureView(newTexture);
            this.textures()[i] = newTexture;
            this.textureViews()[i] = newTextureView;
            this.usedSlots()[i] = true;
            return i;
        }
        throw new UnsupportedOperationException("Trying to use too many textures than are allocated for the pool");
    }

    public GpuTexture getTexture(int index) {
        return Objects.requireNonNull(this.textures()[index]);
    }

    public GpuTextureView getTextureView(int index) {
        return Objects.requireNonNull(this.textureViews()[index]);
    }

    @Override
    public void close() {
        for (GpuTexture gpuTexture : this.textures()) {
            if (gpuTexture == null) continue;
            gpuTexture.close();
        }
        for (GpuTexture gpuTexture : this.textureViews()) {
            if (gpuTexture == null) continue;
            gpuTexture.close();
        }
        Arrays.fill(this.usedSlots(), false);
    }
}

