/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render.gui;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.utils.render.HudHelper;
import java.awt.Color;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;
import net.minecraft.class_8030;
import net.minecraft.class_9848;
import org.jspecify.annotations.Nullable;

public class ColorPickerWidget
extends class_339 {
    private static final class_2960 SV_THUMB_TEXTURE = SkyblockerMod.id("color_picker/sv_thumb");
    private final int[] rainbowColors;
    private final boolean hasAlpha;
    private final int alphaMask;
    private double aThumbX = 0.0;
    private double hThumbX = 0.0;
    private double svThumbX = 0.0;
    private double svThumbY = 0.0;
    private int svColor = -65536;
    private boolean draggingSV = false;
    private boolean draggingH = false;
    private boolean draggingA = false;
    private class_8030 svRect;
    private class_8030 hRect;
    private class_8030 aRect = class_8030.method_48248();
    private int argbColor = -1;
    private @Nullable Callback onColorChange = null;

    private static int[] createRainbowColors(int samples) {
        int[] rainbowColors = new int[samples];
        for (int i = 0; i < samples; ++i) {
            rainbowColors[i] = Color.HSBtoRGB((float)i / (float)samples, 1.0f, 1.0f);
        }
        return rainbowColors;
    }

    public ColorPickerWidget(int x, int y, int width, int height) {
        this(x, y, width, height, false);
    }

    public ColorPickerWidget(int x, int y, int width, int height, boolean hasAlpha) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"ColorPicker"));
        this.rainbowColors = ColorPickerWidget.createRainbowColors(Math.min(width / 20, 8));
        this.hasAlpha = hasAlpha;
        this.alphaMask = hasAlpha ? 0 : -16777216;
        this.updateRects();
    }

    public void method_25357(class_11909 click) {
        super.method_25357(click);
        if ((this.draggingH || this.draggingSV || this.draggingA) && this.onColorChange != null) {
            this.onColorChange.onColorChange(this.argbColor | this.alphaMask, true);
        }
        this.draggingH = false;
        this.draggingSV = false;
        this.draggingA = false;
    }

    private void updateRects() {
        int y = this.method_55443();
        if (this.hasAlpha) {
            this.aRect = new class_8030(this.method_46426() + 1, this.method_55443() - 9, this.method_25368() - 2, 8);
            y = this.aRect.method_49618();
        }
        this.hRect = new class_8030(this.method_46426() + 1, y - 9 - 4, this.method_25368() - 2, 8);
        int previewOffset = 15;
        int svY = this.method_46427() + 1;
        this.svRect = new class_8030(this.method_46426() + 1 + previewOffset, svY, this.method_25368() - 2 - previewOffset, this.hRect.method_49618() - svY - 4);
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.updateRects();
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.updateRects();
    }

    public void method_25358(int width) {
        super.method_25358(width);
        this.updateRects();
    }

    public void method_53533(int height) {
        super.method_53533(height);
        this.updateRects();
    }

    public void method_55445(int width, int height) {
        super.method_55445(width, height);
        this.updateRects();
    }

    public void method_25348(class_11909 click, boolean doubled) {
        super.method_25348(click, doubled);
        int i = (int)click.comp_4798();
        int j = (int)click.comp_4799();
        if (this.hRect.method_58137(i, j)) {
            this.draggingH = true;
            this.method_25349(click, 0.0, 0.0);
        }
        if (this.svRect.method_58137(i, j)) {
            this.draggingSV = true;
            this.method_25349(click, 0.0, 0.0);
        }
        if (this.hasAlpha && this.aRect.method_58137(i, j)) {
            this.draggingA = true;
            this.method_25349(click, 0.0, 0.0);
        }
    }

    protected void method_25349(class_11909 click, double deltaX, double deltaY) {
        super.method_25349(click, deltaX, deltaY);
        if (this.draggingH) {
            this.hThumbX = Math.clamp(click.comp_4798() - (double)this.hRect.method_49620(), 0.0, (double)(this.hRect.comp_1196() - 1));
            this.svColor = Color.HSBtoRGB((float)(this.hThumbX / (double)(this.hRect.comp_1196() - 1)), 1.0f, 1.0f);
        }
        if (this.draggingSV) {
            this.svThumbX = Math.clamp(click.comp_4798() - (double)this.svRect.method_49620(), 0.0, (double)(this.svRect.comp_1196() - 1));
            this.svThumbY = Math.clamp(click.comp_4799() - (double)this.svRect.method_49618(), 0.0, (double)(this.svRect.comp_1197() - 1));
        }
        if (this.draggingA) {
            this.aThumbX = Math.clamp(click.comp_4798() - (double)this.aRect.method_49620(), 0.0, (double)(this.aRect.comp_1196() - 1));
        }
        if (this.draggingH || this.draggingSV || this.draggingA) {
            float alpha = this.hasAlpha ? (float)this.aThumbX / (float)(this.aRect.comp_1196() - 1) : 1.0f;
            this.argbColor = class_9848.method_71346((float)alpha, (int)Color.HSBtoRGB((float)(this.hThumbX / (double)(this.hRect.comp_1196() - 1)), (float)(this.svThumbX / (double)(this.svRect.comp_1196() - 1)), (float)(1.0 - this.svThumbY / (double)(this.svRect.comp_1197() - 1))));
            if (this.onColorChange != null) {
                this.onColorChange.onColorChange(this.argbColor, false);
            }
        }
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        int color = -2141167520;
        context.method_25294(this.hRect.method_49620() - 1, this.hRect.method_49618() - 1, this.hRect.method_49621() + 1, this.hRect.method_49619() + 1, color);
        for (int i = 0; i < this.rainbowColors.length; ++i) {
            int startColor = this.rainbowColors[i];
            int endColor = this.rainbowColors[(i + 1) % this.rainbowColors.length];
            float segmentLength = (float)this.hRect.comp_1196() / (float)this.rainbowColors.length;
            float startX = (float)this.hRect.method_49620() + segmentLength * (float)i;
            float endX = (float)this.hRect.method_49620() + segmentLength * (float)(i + 1);
            HudHelper.drawHorizontalGradient(context, startX, this.hRect.method_49618(), endX, this.hRect.method_49619(), startColor, endColor);
        }
        this.drawThumb(context, this.hRect, (int)this.hThumbX);
        context.method_25294(this.svRect.method_49620() - 1, this.svRect.method_49618() - 1, this.svRect.method_49621() + 1, this.svRect.method_49619() + 1, color);
        int pickerX = this.svRect.method_49620();
        int pickerY = this.svRect.method_49618();
        int pickerEndX = this.svRect.method_49621();
        int pickerEndY = this.svRect.method_49619();
        HudHelper.drawHorizontalGradient(context, pickerX, pickerY, pickerEndX, pickerEndY, -1, this.svColor);
        context.method_25296(pickerX, pickerY, pickerEndX, pickerEndY, 1, -16777216);
        context.method_52706(class_10799.field_56883, SV_THUMB_TEXTURE, this.svRect.method_49620() + (int)this.svThumbX - 2, this.svRect.method_49618() + (int)this.svThumbY - 2, 5, 5);
        if (this.hasAlpha) {
            context.method_25294(this.aRect.method_49620() - 1, this.aRect.method_49618() - 1, this.aRect.method_49621() + 1, this.aRect.method_49619() + 1, color);
            HudHelper.drawHorizontalGradient(context, this.aRect.method_49620(), this.aRect.method_49618(), this.aRect.method_49621(), this.aRect.method_49619(), -16777216, -1);
            this.drawThumb(context, this.aRect, (int)this.aThumbX);
        }
        context.method_25294(this.method_46426(), this.method_46427(), this.svRect.method_49620() - 2, this.svRect.method_49619() + 1, color);
        context.method_25294(this.method_46426() + 1, this.method_46427() + 1, this.svRect.method_49620() - 3, this.svRect.method_49619(), this.argbColor);
        if (this.method_49606()) {
            if (this.svRect.method_58137(mouseX, mouseY) || this.hRect.method_58137(mouseX, mouseY) || this.aRect.method_58137(mouseX, mouseY)) {
                context.method_74037(class_11876.field_62455);
            }
            if (this.draggingSV) {
                context.method_74037(class_11876.field_62454);
            } else if (this.draggingH || this.draggingA) {
                context.method_74037(class_11876.field_62457);
            }
        }
    }

    private void drawThumb(class_332 context, class_8030 rect, int thumbX) {
        context.method_25294(rect.method_49620() + thumbX - 1, rect.method_49618(), rect.method_49620() + thumbX + 2, rect.method_49619(), -16777216);
        context.method_25294(rect.method_49620() + thumbX, rect.method_49618() - 1, rect.method_49620() + thumbX + 1, rect.method_49619() + 1, -16777216);
        context.method_25294(rect.method_49620() + thumbX, rect.method_49618(), rect.method_49620() + thumbX + 1, rect.method_49619(), -1);
    }

    public int getARGBColor() {
        return this.argbColor;
    }

    public void setARGBColor(int argb) {
        this.argbColor = argb | this.alphaMask;
        float[] floats = Color.RGBtoHSB(this.argbColor >> 16 & 0xFF, this.argbColor >> 8 & 0xFF, this.argbColor & 0xFF, null);
        this.setHSV(floats[0], floats[1], floats[2]);
        this.method_25350(class_9848.method_65100((int)this.argbColor));
    }

    public void setHSV(float h, float s, float v) {
        this.hThumbX = h * (float)(this.hRect.comp_1196() - 1);
        this.svThumbX = s * (float)(this.svRect.comp_1196() - 1);
        this.svThumbY = (1.0f - v) * (float)(this.svRect.comp_1197() - 1);
        this.svColor = Color.HSBtoRGB((float)(this.hThumbX / (double)(this.hRect.comp_1196() - 1)), 1.0f, 1.0f);
    }

    public void method_25350(float alpha) {
        if (!this.hasAlpha) {
            return;
        }
        this.aThumbX = alpha * (float)(this.aRect.comp_1196() - 1);
    }

    public void setOnColorChange(@Nullable Callback onColorChange) {
        this.onColorChange = onColorChange;
    }

    protected void method_47399(class_6382 builder) {
    }

    public static interface Callback {
        public void onColorChange(int var1, boolean var2);
    }
}

