/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render.gui;

import de.hysky.skyblocker.utils.Formatters;
import it.unimi.dsi.fastutil.doubles.Double2ObjectFunction;
import java.text.NumberFormat;
import java.util.function.DoubleConsumer;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_357;
import net.minecraft.class_5244;

public class RangedSliderWidget
extends class_357 {
    private final double min;
    private final double max;
    private final Double2ObjectFunction<class_2561> formatter;
    private final DoubleConsumer callback;
    private final double step;

    public RangedSliderWidget(int x, int y, int width, int height, double defaultValue, double min, double max, double step, Double2ObjectFunction<class_2561> formatter, DoubleConsumer callback) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
        this.min = min;
        this.max = max;
        this.step = step;
        this.formatter = formatter;
        this.callback = callback;
        this.method_25347(defaultValue);
    }

    private double roundToNearestStep(double value) {
        return this.step <= 0.0 ? value : (double)Math.round(value / this.step) * this.step;
    }

    private double progressToValue(double progress) {
        return progress * (this.max - this.min) + this.min;
    }

    private double valueToProgress(double value) {
        return Math.clamp((value - this.min) / (this.max - this.min), 0.0, 1.0);
    }

    protected void method_25346() {
        this.method_25355((class_2561)this.formatter.apply(this.getValue()));
    }

    public void method_25347(double value) {
        this.field_22753 = this.valueToProgress(value);
        this.method_25346();
    }

    public double getValue() {
        return this.roundToNearestStep(this.progressToValue(this.field_22753));
    }

    protected void method_25344() {
        this.callback.accept(this.getValue());
    }

    public void method_25357(class_11909 click) {
        super.method_25357(click);
        this.field_22753 = this.valueToProgress(this.getValue());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private double value;
        private double min = 0.0;
        private double max = 1.0;
        private double step;
        private Double2ObjectFunction<class_2561> formatter = d -> class_2561.method_43470((String)Formatters.DOUBLE_NUMBERS.format(d));
        private DoubleConsumer callback = d -> {};

        private Builder() {
        }

        public Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder height(int height) {
            this.height = height;
            return this;
        }

        public Builder minMax(double min, double max) {
            this.min = min;
            this.max = max;
            return this;
        }

        public Builder step(double step) {
            this.step = step;
            return this;
        }

        public Builder defaultValue(double value) {
            this.value = value;
            return this;
        }

        public Builder optionFormatter(class_2561 optionName, NumberFormat formatter) {
            return this.optionFormatter(optionName, (Double2ObjectFunction<class_2561>)((Double2ObjectFunction)d -> class_2561.method_43470((String)formatter.format(d))));
        }

        public Builder optionFormatter(class_2561 optionName, Double2ObjectFunction<class_2561> formatter) {
            return this.formatter((Double2ObjectFunction<class_2561>)((Double2ObjectFunction)d -> class_5244.method_32700((class_2561)optionName, (class_2561)((class_2561)formatter.apply(d)))));
        }

        public Builder formatter(Double2ObjectFunction<class_2561> formatter) {
            this.formatter = formatter;
            return this;
        }

        public Builder callback(DoubleConsumer callback) {
            this.callback = callback;
            return this;
        }

        public RangedSliderWidget build() {
            return new RangedSliderWidget(this.x, this.y, this.width, this.height, this.value, this.min, this.max, this.step, this.formatter, this.callback);
        }
    }
}

